/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Binder;
import android.os.SystemClock;
import android.text.format.DateFormat;
import android.util.ArrayMap;
import android.util.SparseArray;
import com.android.internal.annotations.GuardedBy;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.Preconditions;
import com.android.tools.layoutlib.java.System_Delegate;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class BinderCallsStats {
    private static final int CALL_SESSIONS_POOL_SIZE = 100;
    private static final BinderCallsStats sInstance = new BinderCallsStats();
    private volatile boolean mDetailedTracking = false;
    @GuardedBy(value="mLock")
    private final SparseArray<UidEntry> mUidEntries = new SparseArray();
    private final Queue<CallSession> mCallSessionsPool = new ConcurrentLinkedQueue<CallSession>();
    private final Object mLock = new Object();
    private long mStartTime = System_Delegate.currentTimeMillis();

    private BinderCallsStats() {
    }

    @VisibleForTesting
    public BinderCallsStats(boolean detailedTracking) {
        this.mDetailedTracking = detailedTracking;
    }

    public CallSession callStarted(Binder binder, int code) {
        return this.callStarted(binder.getClass().getName(), code);
    }

    private CallSession callStarted(String className, int code) {
        CallSession s = this.mCallSessionsPool.poll();
        if (s == null) {
            s = new CallSession();
        }
        s.mCallStat.className = className;
        s.mCallStat.msg = code;
        s.mStarted = this.getThreadTimeMicro();
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callEnded(CallSession s) {
        Preconditions.checkNotNull(s);
        long duration = this.mDetailedTracking ? this.getThreadTimeMicro() - s.mStarted : 1L;
        s.mCallingUId = Binder.getCallingUid();
        Object object = this.mLock;
        synchronized (object) {
            UidEntry uidEntry = this.mUidEntries.get(s.mCallingUId);
            if (uidEntry == null) {
                uidEntry = new UidEntry(s.mCallingUId);
                this.mUidEntries.put(s.mCallingUId, uidEntry);
            }
            if (this.mDetailedTracking) {
                CallStat callStat = uidEntry.mCallStats.get(s.mCallStat);
                if (callStat == null) {
                    callStat = new CallStat(s.mCallStat.className, s.mCallStat.msg);
                    uidEntry.mCallStats.put(callStat, callStat);
                }
                ++callStat.callCount;
                callStat.time += duration;
            }
            uidEntry.time += duration;
            ++uidEntry.callCount;
        }
        if (this.mCallSessionsPool.size() < 100) {
            this.mCallSessionsPool.add(s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump(PrintWriter pw) {
        HashMap<Integer, Long> uidTimeMap = new HashMap<Integer, Long>();
        HashMap<Integer, Long> uidCallCountMap = new HashMap<Integer, Long>();
        long totalCallsCount = 0L;
        long totalCallsTime = 0L;
        pw.print("Start time: ");
        pw.println(DateFormat.format((CharSequence)"yyyy-MM-dd HH:mm:ss", this.mStartTime));
        int uidEntriesSize = this.mUidEntries.size();
        ArrayList<UidEntry> entries = new ArrayList<UidEntry>();
        Object object = this.mLock;
        synchronized (object) {
            for (int i = 0; i < uidEntriesSize; ++i) {
                UidEntry uidEntry = this.mUidEntries.valueAt(i);
                entries.add(uidEntry);
                totalCallsTime += uidEntry.time;
                Long l = (Long)uidTimeMap.get(uidEntry.uid);
                uidTimeMap.put(uidEntry.uid, l == null ? uidEntry.time : l + uidEntry.time);
                Long totalCallsPerUid = (Long)uidCallCountMap.get(uidEntry.uid);
                uidCallCountMap.put(uidEntry.uid, totalCallsPerUid == null ? uidEntry.callCount : totalCallsPerUid + uidEntry.callCount);
                totalCallsCount += uidEntry.callCount;
            }
        }
        if (this.mDetailedTracking) {
            pw.println("Raw data (uid,call_desc,time):");
            entries.sort((o1, o2) -> {
                if (o1.time < o2.time) {
                    return 1;
                }
                if (o1.time > o2.time) {
                    return -1;
                }
                return 0;
            });
            StringBuilder sb = new StringBuilder();
            for (UidEntry uidEntry : entries) {
                ArrayList<CallStat> arrayList = new ArrayList<CallStat>(uidEntry.mCallStats.keySet());
                arrayList.sort((o1, o2) -> {
                    if (o1.time < o2.time) {
                        return 1;
                    }
                    if (o1.time > o2.time) {
                        return -1;
                    }
                    return 0;
                });
                for (CallStat e : arrayList) {
                    sb.setLength(0);
                    sb.append("    ").append(uidEntry.uid).append(",").append(e).append(',').append(e.time);
                    pw.println(sb);
                }
            }
            pw.println();
            pw.println("Per UID Summary(UID: time, % of total_time, calls_count):");
            ArrayList uidTotals = new ArrayList(uidTimeMap.entrySet());
            uidTotals.sort((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue()));
            for (Map.Entry entry : uidTotals) {
                Long callCount = (Long)uidCallCountMap.get(entry.getKey());
                pw.println(String.format("  %7d: %11d %3.0f%% %8d", entry.getKey(), entry.getValue(), 100.0 * (double)((Long)entry.getValue()).longValue() / (double)totalCallsTime, callCount));
            }
            pw.println();
            pw.println(String.format("  Summary: total_time=%d, calls_count=%d, avg_call_time=%.0f", totalCallsTime, totalCallsCount, (double)totalCallsTime / (double)totalCallsCount));
        } else {
            pw.println("Per UID Summary(UID: calls_count, % of total calls_count):");
            ArrayList uidTotals = new ArrayList(uidTimeMap.entrySet());
            uidTotals.sort((o1, o2) -> ((Long)o2.getValue()).compareTo((Long)o1.getValue()));
            for (Map.Entry entry : uidTotals) {
                Long l = (Long)uidCallCountMap.get(entry.getKey());
                pw.println(String.format("    %7d: %8d %3.0f%%", entry.getKey(), l, 100.0 * (double)((Long)entry.getValue()).longValue() / (double)totalCallsTime));
            }
        }
    }

    private long getThreadTimeMicro() {
        return this.mDetailedTracking ? SystemClock.currentThreadTimeMicro() : 0L;
    }

    public static BinderCallsStats getInstance() {
        return sInstance;
    }

    public void setDetailedTracking(boolean enabled) {
        if (enabled != this.mDetailedTracking) {
            this.reset();
            this.mDetailedTracking = enabled;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Object object = this.mLock;
        synchronized (object) {
            this.mUidEntries.clear();
            this.mStartTime = System_Delegate.currentTimeMillis();
        }
    }

    private static class UidEntry {
        int uid;
        long time;
        long callCount;
        Map<CallStat, CallStat> mCallStats = new ArrayMap<CallStat, CallStat>();

        UidEntry(int uid) {
            this.uid = uid;
        }

        public String toString() {
            return "UidEntry{time=" + this.time + ", callCount=" + this.callCount + ", mCallStats=" + this.mCallStats + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            UidEntry uidEntry = (UidEntry)o;
            return this.uid == uidEntry.uid;
        }

        public int hashCode() {
            return this.uid;
        }
    }

    public static class CallSession {
        int mCallingUId;
        long mStarted;
        CallStat mCallStat = new CallStat();
    }

    private static class CallStat {
        String className;
        int msg;
        long time;
        long callCount;

        CallStat() {
        }

        CallStat(String className, int msg) {
            this.className = className;
            this.msg = msg;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            CallStat callStat = (CallStat)o;
            return this.msg == callStat.msg && this.className.equals(callStat.className);
        }

        public int hashCode() {
            int result = this.className.hashCode();
            result = 31 * result + this.msg;
            return result;
        }

        public String toString() {
            return this.className + "/" + this.msg;
        }
    }
}

