/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.os.Trace;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.system.DelegateLastClassLoader;
import dalvik.system.DexClassLoader;
import dalvik.system.PathClassLoader;

public class ClassLoaderFactory {
    private static final String PATH_CLASS_LOADER_NAME = PathClassLoader.class.getName();
    private static final String DEX_CLASS_LOADER_NAME = DexClassLoader.class.getName();
    private static final String DELEGATE_LAST_CLASS_LOADER_NAME = DelegateLastClassLoader.class.getName();

    private ClassLoaderFactory() {
    }

    public static boolean isValidClassLoaderName(String name) {
        return name != null && (ClassLoaderFactory.isPathClassLoaderName(name) || ClassLoaderFactory.isDelegateLastClassLoaderName(name));
    }

    public static boolean isPathClassLoaderName(String name) {
        return name == null || PATH_CLASS_LOADER_NAME.equals(name) || DEX_CLASS_LOADER_NAME.equals(name);
    }

    public static boolean isDelegateLastClassLoaderName(String name) {
        return DELEGATE_LAST_CLASS_LOADER_NAME.equals(name);
    }

    public static ClassLoader createClassLoader(String dexPath, String librarySearchPath, ClassLoader parent, String classloaderName) {
        if (ClassLoaderFactory.isPathClassLoaderName(classloaderName)) {
            return new PathClassLoader(dexPath, librarySearchPath, parent);
        }
        if (ClassLoaderFactory.isDelegateLastClassLoaderName(classloaderName)) {
            return new DelegateLastClassLoader(dexPath, librarySearchPath, parent);
        }
        throw new AssertionError((Object)("Invalid classLoaderName: " + classloaderName));
    }

    public static ClassLoader createClassLoader(String dexPath, String librarySearchPath, String libraryPermittedPath, ClassLoader parent, int targetSdkVersion, boolean isNamespaceShared, String classloaderName) {
        ClassLoader classLoader = ClassLoaderFactory.createClassLoader(dexPath, librarySearchPath, parent, classloaderName);
        boolean isForVendor = false;
        for (String path : dexPath.split(":")) {
            if (!path.startsWith("/vendor/")) continue;
            isForVendor = true;
            break;
        }
        Trace.traceBegin(64L, "createClassloaderNamespace");
        String errorMessage = ClassLoaderFactory.createClassloaderNamespace(classLoader, targetSdkVersion, librarySearchPath, libraryPermittedPath, isNamespaceShared, isForVendor);
        Trace.traceEnd(64L);
        if (errorMessage != null) {
            throw new UnsatisfiedLinkError("Unable to create namespace for the classloader " + classLoader + ": " + errorMessage);
        }
        return classLoader;
    }

    private static String createClassloaderNamespace(ClassLoader classLoader, int n, String string2, String string3, boolean bl, boolean bl2) {
        return (String)OverrideMethod.invokeA("com.android.internal.os.ClassLoaderFactory#createClassloaderNamespace(Ljava/lang/ClassLoader;ILjava/lang/String;Ljava/lang/String;ZZ)Ljava/lang/String;", true, null);
    }
}

