/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.os;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import com.android.internal.annotations.VisibleForTesting;
import com.android.internal.util.XmlUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.xmlpull.v1.XmlPullParserException;

public class PowerProfile {
    public static final String POWER_CPU_SUSPEND = "cpu.suspend";
    public static final String POWER_CPU_IDLE = "cpu.idle";
    public static final String POWER_CPU_ACTIVE = "cpu.active";
    public static final String POWER_WIFI_SCAN = "wifi.scan";
    public static final String POWER_WIFI_ON = "wifi.on";
    public static final String POWER_WIFI_ACTIVE = "wifi.active";
    public static final String POWER_WIFI_CONTROLLER_IDLE = "wifi.controller.idle";
    public static final String POWER_WIFI_CONTROLLER_RX = "wifi.controller.rx";
    public static final String POWER_WIFI_CONTROLLER_TX = "wifi.controller.tx";
    public static final String POWER_WIFI_CONTROLLER_TX_LEVELS = "wifi.controller.tx_levels";
    public static final String POWER_WIFI_CONTROLLER_OPERATING_VOLTAGE = "wifi.controller.voltage";
    public static final String POWER_BLUETOOTH_CONTROLLER_IDLE = "bluetooth.controller.idle";
    public static final String POWER_BLUETOOTH_CONTROLLER_RX = "bluetooth.controller.rx";
    public static final String POWER_BLUETOOTH_CONTROLLER_TX = "bluetooth.controller.tx";
    public static final String POWER_BLUETOOTH_CONTROLLER_OPERATING_VOLTAGE = "bluetooth.controller.voltage";
    public static final String POWER_MODEM_CONTROLLER_SLEEP = "modem.controller.sleep";
    public static final String POWER_MODEM_CONTROLLER_IDLE = "modem.controller.idle";
    public static final String POWER_MODEM_CONTROLLER_RX = "modem.controller.rx";
    public static final String POWER_MODEM_CONTROLLER_TX = "modem.controller.tx";
    public static final String POWER_MODEM_CONTROLLER_OPERATING_VOLTAGE = "modem.controller.voltage";
    public static final String POWER_GPS_ON = "gps.on";
    public static final String POWER_GPS_SIGNAL_QUALITY_BASED = "gps.signalqualitybased";
    public static final String POWER_GPS_OPERATING_VOLTAGE = "gps.voltage";
    @Deprecated
    public static final String POWER_BLUETOOTH_ON = "bluetooth.on";
    @Deprecated
    public static final String POWER_BLUETOOTH_ACTIVE = "bluetooth.active";
    @Deprecated
    public static final String POWER_BLUETOOTH_AT_CMD = "bluetooth.at";
    public static final String POWER_AMBIENT_DISPLAY = "ambient.on";
    public static final String POWER_SCREEN_ON = "screen.on";
    public static final String POWER_RADIO_ON = "radio.on";
    public static final String POWER_RADIO_SCANNING = "radio.scanning";
    public static final String POWER_RADIO_ACTIVE = "radio.active";
    public static final String POWER_SCREEN_FULL = "screen.full";
    public static final String POWER_AUDIO = "audio";
    public static final String POWER_VIDEO = "video";
    public static final String POWER_FLASHLIGHT = "camera.flashlight";
    public static final String POWER_MEMORY = "memory.bandwidths";
    public static final String POWER_CAMERA = "camera.avg";
    public static final String POWER_WIFI_BATCHED_SCAN = "wifi.batchedscan";
    public static final String POWER_BATTERY_CAPACITY = "battery.capacity";
    static final HashMap<String, Double> sPowerItemMap = new HashMap();
    static final HashMap<String, Double[]> sPowerArrayMap = new HashMap();
    private static final String TAG_DEVICE = "device";
    private static final String TAG_ITEM = "item";
    private static final String TAG_ARRAY = "array";
    private static final String TAG_ARRAYITEM = "value";
    private static final String ATTR_NAME = "name";
    private static final Object sLock = new Object();
    private CpuClusterKey[] mCpuClusters;
    private static final String CPU_PER_CLUSTER_CORE_COUNT = "cpu.clusters.cores";
    private static final String CPU_CLUSTER_POWER_COUNT = "cpu.cluster_power.cluster";
    private static final String CPU_CORE_SPEED_PREFIX = "cpu.core_speeds.cluster";
    private static final String CPU_CORE_POWER_PREFIX = "cpu.core_power.cluster";

    @VisibleForTesting
    public PowerProfile(Context context) {
        this(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public PowerProfile(Context context, boolean forTest) {
        Object object = sLock;
        synchronized (object) {
            if (sPowerItemMap.size() == 0 && sPowerArrayMap.size() == 0) {
                this.readPowerValuesFromXml(context, forTest);
            }
            this.initCpuClusters();
        }
    }

    private void readPowerValuesFromXml(Context context, boolean forTest) {
        int id2 = forTest ? 18284562 : 0x1170011;
        Resources resources = context.getResources();
        XmlResourceParser parser = resources.getXml(id2);
        boolean parsingArray = false;
        ArrayList<Double> array2 = new ArrayList<Double>();
        String arrayName = null;
        try {
            XmlUtils.beginDocument(parser, TAG_DEVICE);
            while (true) {
                XmlUtils.nextElement(parser);
                String element = parser.getName();
                if (element == null) break;
                if (parsingArray && !element.equals(TAG_ARRAYITEM)) {
                    sPowerArrayMap.put(arrayName, array2.toArray(new Double[array2.size()]));
                    parsingArray = false;
                }
                if (element.equals(TAG_ARRAY)) {
                    parsingArray = true;
                    array2.clear();
                    arrayName = parser.getAttributeValue(null, ATTR_NAME);
                    continue;
                }
                if (!element.equals(TAG_ITEM) && !element.equals(TAG_ARRAYITEM)) continue;
                String name = null;
                if (!parsingArray) {
                    name = parser.getAttributeValue(null, ATTR_NAME);
                }
                if (parser.next() != 4) continue;
                String power = parser.getText();
                double value = 0.0;
                try {
                    value = Double.valueOf(power);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (element.equals(TAG_ITEM)) {
                    sPowerItemMap.put(name, value);
                    continue;
                }
                if (!parsingArray) continue;
                array2.add(value);
            }
            if (parsingArray) {
                sPowerArrayMap.put(arrayName, array2.toArray(new Double[array2.size()]));
            }
        }
        catch (XmlPullParserException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            parser.close();
        }
        int[] configResIds = new int[]{17694738, 17694743, 17694744, 17694742};
        String[] configResIdKeys = new String[]{POWER_BLUETOOTH_CONTROLLER_IDLE, POWER_BLUETOOTH_CONTROLLER_RX, POWER_BLUETOOTH_CONTROLLER_TX, POWER_BLUETOOTH_CONTROLLER_OPERATING_VOLTAGE};
        for (int i = 0; i < configResIds.length; ++i) {
            int value;
            String key = configResIdKeys[i];
            if (sPowerItemMap.containsKey(key) && sPowerItemMap.get(key) > 0.0 || (value = resources.getInteger(configResIds[i])) <= 0) continue;
            sPowerItemMap.put(key, Double.valueOf(value));
        }
    }

    private void initCpuClusters() {
        if (sPowerArrayMap.containsKey(CPU_PER_CLUSTER_CORE_COUNT)) {
            Double[] data = sPowerArrayMap.get(CPU_PER_CLUSTER_CORE_COUNT);
            this.mCpuClusters = new CpuClusterKey[data.length];
            for (int cluster = 0; cluster < data.length; ++cluster) {
                int numCpusInCluster = (int)Math.round(data[cluster]);
                this.mCpuClusters[cluster] = new CpuClusterKey(CPU_CORE_SPEED_PREFIX + cluster, CPU_CLUSTER_POWER_COUNT + cluster, CPU_CORE_POWER_PREFIX + cluster, numCpusInCluster);
            }
        } else {
            this.mCpuClusters = new CpuClusterKey[1];
            int numCpus = 1;
            if (sPowerItemMap.containsKey(CPU_PER_CLUSTER_CORE_COUNT)) {
                numCpus = (int)Math.round(sPowerItemMap.get(CPU_PER_CLUSTER_CORE_COUNT));
            }
            this.mCpuClusters[0] = new CpuClusterKey("cpu.core_speeds.cluster0", "cpu.cluster_power.cluster0", "cpu.core_power.cluster0", numCpus);
        }
    }

    public int getNumCpuClusters() {
        return this.mCpuClusters.length;
    }

    public int getNumCoresInCpuCluster(int cluster) {
        return this.mCpuClusters[cluster].numCpus;
    }

    public int getNumSpeedStepsInCpuCluster(int cluster) {
        if (cluster < 0 || cluster >= this.mCpuClusters.length) {
            return 0;
        }
        if (sPowerArrayMap.containsKey(this.mCpuClusters[cluster].freqKey)) {
            return sPowerArrayMap.get(this.mCpuClusters[cluster].freqKey).length;
        }
        return 1;
    }

    public double getAveragePowerForCpuCluster(int cluster) {
        if (cluster >= 0 && cluster < this.mCpuClusters.length) {
            return this.getAveragePower(this.mCpuClusters[cluster].clusterPowerKey);
        }
        return 0.0;
    }

    public double getAveragePowerForCpuCore(int cluster, int step) {
        if (cluster >= 0 && cluster < this.mCpuClusters.length) {
            return this.getAveragePower(this.mCpuClusters[cluster].corePowerKey, step);
        }
        return 0.0;
    }

    public int getNumElements(String key) {
        if (sPowerItemMap.containsKey(key)) {
            return 1;
        }
        if (sPowerArrayMap.containsKey(key)) {
            return sPowerArrayMap.get(key).length;
        }
        return 0;
    }

    public double getAveragePowerOrDefault(String type, double defaultValue) {
        if (sPowerItemMap.containsKey(type)) {
            return sPowerItemMap.get(type);
        }
        if (sPowerArrayMap.containsKey(type)) {
            return sPowerArrayMap.get(type)[0];
        }
        return defaultValue;
    }

    public double getAveragePower(String type) {
        return this.getAveragePowerOrDefault(type, 0.0);
    }

    public double getAveragePower(String type, int level) {
        if (sPowerItemMap.containsKey(type)) {
            return sPowerItemMap.get(type);
        }
        if (sPowerArrayMap.containsKey(type)) {
            Double[] values = sPowerArrayMap.get(type);
            if (values.length > level && level >= 0) {
                return values[level];
            }
            if (level < 0 || values.length == 0) {
                return 0.0;
            }
            return values[values.length - 1];
        }
        return 0.0;
    }

    public double getBatteryCapacity() {
        return this.getAveragePower(POWER_BATTERY_CAPACITY);
    }

    public static class CpuClusterKey {
        private final String freqKey;
        private final String clusterPowerKey;
        private final String corePowerKey;
        private final int numCpus;

        private CpuClusterKey(String freqKey, String clusterPowerKey, String corePowerKey, int numCpus) {
            this.freqKey = freqKey;
            this.clusterPowerKey = clusterPowerKey;
            this.corePowerKey = corePowerKey;
            this.numCpus = numCpus;
        }
    }
}

