/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.os.Trace;
import android.os._Original_Build;
import android.util.EventLog;
import android.util.Log;
import android.util.SparseLongArray;

public class LatencyTracker {
    private static final String ACTION_RELOAD_PROPERTY = "com.android.systemui.RELOAD_LATENCY_TRACKER_PROPERTY";
    private static final String TAG = "LatencyTracker";
    public static final int ACTION_EXPAND_PANEL = 0;
    public static final int ACTION_TOGGLE_RECENTS = 1;
    public static final int ACTION_FINGERPRINT_WAKE_AND_UNLOCK = 2;
    public static final int ACTION_CHECK_CREDENTIAL = 3;
    public static final int ACTION_CHECK_CREDENTIAL_UNLOCKED = 4;
    public static final int ACTION_TURN_ON_SCREEN = 5;
    public static final int ACTION_ROTATE_SCREEN = 6;
    private static final String[] NAMES = new String[]{"expand panel", "toggle recents", "fingerprint wake-and-unlock", "check credential", "check credential unlocked", "turn on screen", "rotate the screen"};
    private static LatencyTracker sLatencyTracker;
    private final SparseLongArray mStartRtc = new SparseLongArray();
    private boolean mEnabled;

    public static LatencyTracker getInstance(Context context) {
        if (sLatencyTracker == null) {
            sLatencyTracker = new LatencyTracker(context);
        }
        return sLatencyTracker;
    }

    private LatencyTracker(Context context) {
        context.registerReceiver(new BroadcastReceiver(){

            @Override
            public void onReceive(Context context, Intent intent) {
                LatencyTracker.this.reloadProperty();
            }
        }, new IntentFilter(ACTION_RELOAD_PROPERTY));
        this.reloadProperty();
    }

    private void reloadProperty() {
        this.mEnabled = SystemProperties.getBoolean("debug.systemui.latency_tracking", false);
    }

    public static boolean isEnabled(Context ctx) {
        return _Original_Build.IS_DEBUGGABLE && LatencyTracker.getInstance((Context)ctx).mEnabled;
    }

    public void onActionStart(int action) {
        if (!this.mEnabled) {
            return;
        }
        Trace.asyncTraceBegin(4096L, NAMES[action], 0);
        this.mStartRtc.put(action, SystemClock.elapsedRealtime());
    }

    public void onActionEnd(int action) {
        if (!this.mEnabled) {
            return;
        }
        long endRtc = SystemClock.elapsedRealtime();
        long startRtc = this.mStartRtc.get(action, -1L);
        if (startRtc == -1L) {
            return;
        }
        this.mStartRtc.delete(action);
        Trace.asyncTraceEnd(4096L, NAMES[action], 0);
        LatencyTracker.logAction(action, (int)(endRtc - startRtc));
    }

    public static void logAction(int action, int duration) {
        Log.i(TAG, "action=" + action + " latency=" + duration);
        EventLog.writeEvent(36070, action, duration);
    }
}

