/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util;

import com.android.internal.util.Preconditions;
import java.lang.reflect.Array;
import java.util.Arrays;

public class RingBuffer<T> {
    private final T[] mBuffer;
    private long mCursor = 0L;

    public RingBuffer(Class<T> c, int capacity) {
        Preconditions.checkArgumentPositive(capacity, "A RingBuffer cannot have 0 capacity");
        this.mBuffer = (Object[])Array.newInstance(c, capacity);
    }

    public int size() {
        return (int)Math.min((long)this.mBuffer.length, this.mCursor);
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        for (int i = 0; i < this.size(); ++i) {
            this.mBuffer[i] = null;
        }
        this.mCursor = 0L;
    }

    public void append(T t) {
        this.mBuffer[this.indexOf((long)this.mCursor++)] = t;
    }

    public T getNextSlot() {
        int nextSlotIdx;
        if (this.mBuffer[nextSlotIdx = this.indexOf(this.mCursor++)] == null) {
            this.mBuffer[nextSlotIdx] = this.createNewItem();
        }
        return this.mBuffer[nextSlotIdx];
    }

    protected T createNewItem() {
        try {
            return (T)this.mBuffer.getClass().getComponentType().newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    public T[] toArray() {
        T[] out = Arrays.copyOf(this.mBuffer, this.size(), this.mBuffer.getClass());
        long inCursor = this.mCursor - 1L;
        int outIdx = out.length - 1;
        while (outIdx >= 0) {
            out[outIdx--] = this.mBuffer[this.indexOf(inCursor--)];
        }
        return out;
    }

    private int indexOf(long cursor) {
        return (int)Math.abs(cursor % (long)this.mBuffer.length);
    }
}

