/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.util.function.pooled;

import android.os.Message;
import android.text.TextUtils;
import android.util.Pools;
import com.android.internal.util.ArrayUtils;
import com.android.internal.util.BitUtils;
import com.android.internal.util.function.HexConsumer;
import com.android.internal.util.function.HexFunction;
import com.android.internal.util.function.HexPredicate;
import com.android.internal.util.function.QuadConsumer;
import com.android.internal.util.function.QuadFunction;
import com.android.internal.util.function.QuadPredicate;
import com.android.internal.util.function.QuintConsumer;
import com.android.internal.util.function.QuintFunction;
import com.android.internal.util.function.QuintPredicate;
import com.android.internal.util.function.TriConsumer;
import com.android.internal.util.function.TriFunction;
import com.android.internal.util.function.TriPredicate;
import com.android.internal.util.function.pooled.ArgumentPlaceholder;
import com.android.internal.util.function.pooled.OmniFunction;
import com.android.internal.util.function.pooled.PooledLambda;
import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;

class PooledLambdaImpl<R>
extends OmniFunction<Object, Object, Object, Object, Object, Object, R> {
    private static final boolean DEBUG = false;
    private static final String LOG_TAG = "PooledLambdaImpl";
    private static final int MAX_ARGS = 5;
    private static final int MAX_POOL_SIZE = 50;
    static final Pool sPool = new Pool(new Object());
    static final Pool sMessageCallbacksPool = new Pool(Message.sPoolSync);
    Object mFunc;
    long mConstValue;
    Object[] mArgs = null;
    private static final int FLAG_RECYCLED = 32;
    private static final int FLAG_RECYCLE_ON_USE = 64;
    private static final int FLAG_ACQUIRED_FROM_MESSAGE_CALLBACKS_POOL = 128;
    static final int MASK_EXPOSED_AS = 16128;
    static final int MASK_FUNC_TYPE = 1032192;
    int mFlags = 0;

    private PooledLambdaImpl() {
    }

    @Override
    public void recycle() {
        if (!this.isRecycled()) {
            this.doRecycle();
        }
    }

    private void doRecycle() {
        Pool pool = (this.mFlags & 0x80) != 0 ? sMessageCallbacksPool : sPool;
        this.mFunc = null;
        if (this.mArgs != null) {
            Arrays.fill(this.mArgs, null);
        }
        this.mFlags = 32;
        this.mConstValue = 0L;
        pool.release(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    R invoke(Object a1, Object a2, Object a3, Object a4, Object a5, Object a6) {
        this.checkNotRecycled();
        boolean notUsed = this.fillInArg(a1) && this.fillInArg(a2) && this.fillInArg(a3) && this.fillInArg(a4) && this.fillInArg(a5) && this.fillInArg(a6);
        int argCount = LambdaType.decodeArgCount(this.getFlags(1032192));
        if (argCount != 7) {
            for (int i = 0; i < argCount; ++i) {
                if (this.mArgs[i] != ArgumentPlaceholder.INSTANCE) continue;
                throw new IllegalStateException("Missing argument #" + i + " among " + Arrays.toString(this.mArgs));
            }
        }
        try {
            R r = this.doInvoke();
            return r;
        }
        finally {
            if (this.isRecycleOnUse()) {
                this.doRecycle();
            }
            if (!this.isRecycled()) {
                int argsSize = ArrayUtils.size(this.mArgs);
                for (int i = 0; i < argsSize; ++i) {
                    this.popArg(i);
                }
            }
        }
    }

    private boolean fillInArg(Object invocationArg) {
        int argsSize = ArrayUtils.size(this.mArgs);
        for (int i = 0; i < argsSize; ++i) {
            if (this.mArgs[i] != ArgumentPlaceholder.INSTANCE) continue;
            this.mArgs[i] = invocationArg;
            this.mFlags = (int)((long)this.mFlags | BitUtils.bitAt(i));
            return true;
        }
        if (invocationArg != null && invocationArg != ArgumentPlaceholder.INSTANCE) {
            throw new IllegalStateException("No more arguments expected for provided arg " + invocationArg + " among " + Arrays.toString(this.mArgs));
        }
        return false;
    }

    private void checkNotRecycled() {
        if (this.isRecycled()) {
            throw new IllegalStateException("Instance is recycled: " + this);
        }
    }

    private R doInvoke() {
        int funcType = this.getFlags(1032192);
        int argCount = LambdaType.decodeArgCount(funcType);
        int returnType = LambdaType.decodeReturnType(funcType);
        switch (argCount) {
            case 7: {
                switch (returnType) {
                    case 4: {
                        return (R)Integer.valueOf(this.getAsInt());
                    }
                    case 5: {
                        return (R)Long.valueOf(this.getAsLong());
                    }
                    case 6: {
                        return (R)Double.valueOf(this.getAsDouble());
                    }
                }
                return (R)this.mFunc;
            }
            case 0: {
                switch (returnType) {
                    case 1: {
                        ((Runnable)this.mFunc).run();
                        return null;
                    }
                    case 2: 
                    case 3: {
                        return (R)((Supplier)this.mFunc).get();
                    }
                }
                break;
            }
            case 1: {
                switch (returnType) {
                    case 1: {
                        ((Consumer)this.mFunc).accept(this.popArg(0));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((Predicate)this.mFunc).test(this.popArg(0)));
                    }
                    case 3: {
                        return ((Function)this.mFunc).apply(this.popArg(0));
                    }
                }
                break;
            }
            case 2: {
                switch (returnType) {
                    case 1: {
                        ((BiConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((BiPredicate)this.mFunc).test(this.popArg(0), this.popArg(1)));
                    }
                    case 3: {
                        return ((BiFunction)this.mFunc).apply(this.popArg(0), this.popArg(1));
                    }
                }
                break;
            }
            case 3: {
                switch (returnType) {
                    case 1: {
                        ((TriConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1), this.popArg(2));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((TriPredicate)this.mFunc).test(this.popArg(0), this.popArg(1), this.popArg(2)));
                    }
                    case 3: {
                        return ((TriFunction)this.mFunc).apply(this.popArg(0), this.popArg(1), this.popArg(2));
                    }
                }
                break;
            }
            case 4: {
                switch (returnType) {
                    case 1: {
                        ((QuadConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((QuadPredicate)this.mFunc).test(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3)));
                    }
                    case 3: {
                        return ((QuadFunction)this.mFunc).apply(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3));
                    }
                }
                break;
            }
            case 5: {
                switch (returnType) {
                    case 1: {
                        ((QuintConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((QuintPredicate)this.mFunc).test(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4)));
                    }
                    case 3: {
                        return ((QuintFunction)this.mFunc).apply(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4));
                    }
                }
                break;
            }
            case 6: {
                switch (returnType) {
                    case 1: {
                        ((HexConsumer)this.mFunc).accept(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4), this.popArg(5));
                        return null;
                    }
                    case 2: {
                        return (R)Boolean.valueOf(((HexPredicate)this.mFunc).test(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4), this.popArg(5)));
                    }
                    case 3: {
                        return ((HexFunction)this.mFunc).apply(this.popArg(0), this.popArg(1), this.popArg(2), this.popArg(3), this.popArg(4), this.popArg(5));
                    }
                }
            }
        }
        throw new IllegalStateException("Unknown function type: " + LambdaType.toString(funcType));
    }

    private boolean isConstSupplier() {
        return LambdaType.decodeArgCount(this.getFlags(1032192)) == 7;
    }

    private Object popArg(int index) {
        Object result = this.mArgs[index];
        if (this.isInvocationArgAtIndex(index)) {
            this.mArgs[index] = ArgumentPlaceholder.INSTANCE;
            this.mFlags = (int)((long)this.mFlags & (BitUtils.bitAt(index) ^ 0xFFFFFFFFFFFFFFFFL));
        }
        return result;
    }

    public String toString() {
        if (this.isRecycled()) {
            return "<recycled PooledLambda@" + PooledLambdaImpl.hashCodeHex(this) + ">";
        }
        StringBuilder sb = new StringBuilder();
        if (this.isConstSupplier()) {
            sb.append(this.getFuncTypeAsString()).append("(").append(this.doInvoke()).append(")");
        } else {
            if (this.mFunc instanceof PooledLambdaImpl) {
                sb.append(this.mFunc);
            } else {
                sb.append(this.getFuncTypeAsString()).append("@").append(PooledLambdaImpl.hashCodeHex(this.mFunc));
            }
            sb.append("(");
            sb.append(this.commaSeparateFirstN(this.mArgs, LambdaType.decodeArgCount(this.getFlags(1032192))));
            sb.append(")");
        }
        return sb.toString();
    }

    private String commaSeparateFirstN(Object[] arr, int n) {
        if (arr == null) {
            return "";
        }
        return TextUtils.join((CharSequence)",", Arrays.copyOf(arr, n));
    }

    private static String hashCodeHex(Object o) {
        return Integer.toHexString(o.hashCode());
    }

    private String getFuncTypeAsString() {
        if (this.isRecycled()) {
            throw new IllegalStateException();
        }
        if (this.isConstSupplier()) {
            return "supplier";
        }
        String name = LambdaType.toString(this.getFlags(16128));
        if (name.endsWith("Consumer")) {
            return "consumer";
        }
        if (name.endsWith("Function")) {
            return "function";
        }
        if (name.endsWith("Predicate")) {
            return "predicate";
        }
        if (name.endsWith("Supplier")) {
            return "supplier";
        }
        if (name.endsWith("Runnable")) {
            return "runnable";
        }
        throw new IllegalStateException("Don't know the string representation of " + name);
    }

    static <E extends PooledLambda> E acquire(Pool pool, Object func, int fNumArgs, int numPlaceholders, int fReturnType, Object a, Object b, Object c, Object d, Object e, Object f) {
        PooledLambdaImpl r = PooledLambdaImpl.acquire(pool);
        r.mFunc = func;
        r.setFlags(1032192, LambdaType.encode(fNumArgs, fReturnType));
        r.setFlags(16128, LambdaType.encode(numPlaceholders, fReturnType));
        if (ArrayUtils.size(r.mArgs) < fNumArgs) {
            r.mArgs = new Object[fNumArgs];
        }
        PooledLambdaImpl.setIfInBounds(r.mArgs, 0, a);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 1, b);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 2, c);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 3, d);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 4, e);
        PooledLambdaImpl.setIfInBounds(r.mArgs, 5, f);
        return (E)r;
    }

    static PooledLambdaImpl acquireConstSupplier(int type) {
        PooledLambdaImpl r = PooledLambdaImpl.acquire(sPool);
        int lambdaType = LambdaType.encode(7, type);
        r.setFlags(1032192, lambdaType);
        r.setFlags(16128, lambdaType);
        return r;
    }

    static PooledLambdaImpl acquire(Pool pool) {
        PooledLambdaImpl r = (PooledLambdaImpl)pool.acquire();
        if (r == null) {
            r = new PooledLambdaImpl();
        }
        r.mFlags &= 0xFFFFFFDF;
        r.setFlags(128, pool == sMessageCallbacksPool ? 1 : 0);
        return r;
    }

    private static void setIfInBounds(Object[] array2, int i, Object a) {
        if (i < ArrayUtils.size(array2)) {
            array2[i] = a;
        }
    }

    @Override
    public OmniFunction<Object, Object, Object, Object, Object, Object, R> negate() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <V> OmniFunction<Object, Object, Object, Object, Object, Object, V> andThen(Function<? super R, ? extends V> after) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getAsDouble() {
        return Double.longBitsToDouble(this.mConstValue);
    }

    @Override
    public int getAsInt() {
        return (int)this.mConstValue;
    }

    @Override
    public long getAsLong() {
        return this.mConstValue;
    }

    @Override
    public OmniFunction<Object, Object, Object, Object, Object, Object, R> recycleOnUse() {
        this.mFlags |= 0x40;
        return this;
    }

    private boolean isRecycled() {
        return (this.mFlags & 0x20) != 0;
    }

    private boolean isRecycleOnUse() {
        return (this.mFlags & 0x40) != 0;
    }

    private boolean isInvocationArgAtIndex(int argIndex) {
        return (this.mFlags & 1 << argIndex) != 0;
    }

    int getFlags(int mask) {
        return PooledLambdaImpl.unmask(mask, this.mFlags);
    }

    void setFlags(int mask, int value) {
        this.mFlags &= ~mask;
        this.mFlags |= PooledLambdaImpl.mask(mask, value);
    }

    private static int mask(int mask, int value) {
        return value << Integer.numberOfTrailingZeros(mask) & mask;
    }

    private static int unmask(int mask, int bits) {
        return (bits & mask) / (1 << Integer.numberOfTrailingZeros(mask));
    }

    static class LambdaType {
        public static final int MASK_ARG_COUNT = 7;
        public static final int MASK_RETURN_TYPE = 56;
        public static final int MASK = 63;
        public static final int MASK_BIT_COUNT = 6;

        LambdaType() {
        }

        static int encode(int argCount, int returnType) {
            return PooledLambdaImpl.mask(7, argCount) | PooledLambdaImpl.mask(56, returnType);
        }

        static int decodeArgCount(int type) {
            return type & 7;
        }

        static int decodeReturnType(int type) {
            return PooledLambdaImpl.unmask(56, type);
        }

        static String toString(int type) {
            int argCount = LambdaType.decodeArgCount(type);
            int returnType = LambdaType.decodeReturnType(type);
            if (argCount == 0) {
                if (returnType == 1) {
                    return "Runnable";
                }
                if (returnType == 3 || returnType == 2) {
                    return "Supplier";
                }
            }
            return LambdaType.argCountPrefix(argCount) + ReturnType.lambdaSuffix(returnType);
        }

        private static String argCountPrefix(int argCount) {
            switch (argCount) {
                case 7: {
                    return "";
                }
                case 1: {
                    return "";
                }
                case 2: {
                    return "Bi";
                }
                case 3: {
                    return "Tri";
                }
                case 4: {
                    return "Quad";
                }
                case 5: {
                    return "Quint";
                }
                case 6: {
                    return "Hex";
                }
            }
            throw new IllegalArgumentException("" + argCount);
        }

        static class ReturnType {
            public static final int VOID = 1;
            public static final int BOOLEAN = 2;
            public static final int OBJECT = 3;
            public static final int INT = 4;
            public static final int LONG = 5;
            public static final int DOUBLE = 6;

            ReturnType() {
            }

            static String toString(int returnType) {
                switch (returnType) {
                    case 1: {
                        return "VOID";
                    }
                    case 2: {
                        return "BOOLEAN";
                    }
                    case 3: {
                        return "OBJECT";
                    }
                    case 4: {
                        return "INT";
                    }
                    case 5: {
                        return "LONG";
                    }
                    case 6: {
                        return "DOUBLE";
                    }
                }
                return "" + returnType;
            }

            static String lambdaSuffix(int type) {
                return ReturnType.prefix(type) + ReturnType.suffix(type);
            }

            private static String prefix(int type) {
                switch (type) {
                    case 4: {
                        return "Int";
                    }
                    case 5: {
                        return "Long";
                    }
                    case 6: {
                        return "Double";
                    }
                }
                return "";
            }

            private static String suffix(int type) {
                switch (type) {
                    case 1: {
                        return "Consumer";
                    }
                    case 2: {
                        return "Predicate";
                    }
                    case 3: {
                        return "Function";
                    }
                }
                return "Supplier";
            }
        }
    }

    static class Pool
    extends Pools.SynchronizedPool<PooledLambdaImpl> {
        public Pool(Object lock) {
            super(50, lock);
        }
    }
}

