/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.DrawableWrapper;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.RippleDrawable;
import android.util.AttributeSet;
import android.view.RemotableViewMethod;
import android.widget.Button;
import android.widget.RemoteViews;

@RemoteViews.RemoteView
public class EmphasizedNotificationButton
extends Button {
    private final RippleDrawable mRipple;
    private final int mStrokeWidth;
    private final int mStrokeColor;

    public EmphasizedNotificationButton(Context context) {
        this(context, null);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public EmphasizedNotificationButton(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        DrawableWrapper background = (DrawableWrapper)this.getBackground().mutate();
        this.mRipple = (RippleDrawable)background.getDrawable();
        this.mStrokeWidth = this.getResources().getDimensionPixelSize(17105042);
        this.mStrokeColor = this.getContext().getColor(17170662);
        this.mRipple.mutate();
    }

    @RemotableViewMethod
    public void setRippleColor(ColorStateList color2) {
        this.mRipple.setColor(color2);
        this.invalidate();
    }

    @RemotableViewMethod
    public void setButtonBackground(ColorStateList color2) {
        GradientDrawable inner = (GradientDrawable)this.mRipple.getDrawable(0);
        inner.setColor(color2);
        this.invalidate();
    }

    @RemotableViewMethod
    public void setHasStroke(boolean hasStroke) {
        GradientDrawable inner = (GradientDrawable)this.mRipple.getDrawable(0);
        inner.setStroke(hasStroke ? this.mStrokeWidth : 0, this.mStrokeColor);
        this.invalidate();
    }
}

