/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.util.ArraySet;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import com.android.internal.widget.MessagingPropertyAnimator;

public class ViewClippingUtil {
    private static final int CLIP_CLIPPING_SET = 16908798;
    private static final int CLIP_CHILDREN_TAG = 16908799;
    private static final int CLIP_TO_PADDING = 0x1020201;

    public static void setClippingDeactivated(View transformedView, boolean deactivated, ClippingParameters clippingParameters) {
        if (!deactivated && !clippingParameters.isClippingEnablingAllowed(transformedView)) {
            return;
        }
        if (!(transformedView.getParent() instanceof ViewGroup)) {
            return;
        }
        ViewGroup parent = (ViewGroup)transformedView.getParent();
        while (true) {
            Boolean clipToPadding;
            Boolean clipChildren;
            if (!deactivated && !clippingParameters.isClippingEnablingAllowed(transformedView)) {
                return;
            }
            ArraySet<View> clipSet = (ArraySet<View>)parent.getTag(16908798);
            if (clipSet == null) {
                clipSet = new ArraySet<View>();
                parent.setTagInternal(16908798, clipSet);
            }
            if ((clipChildren = (Boolean)parent.getTag(16908799)) == null) {
                clipChildren = parent.getClipChildren();
                parent.setTagInternal(16908799, clipChildren);
            }
            if ((clipToPadding = (Boolean)parent.getTag(0x1020201)) == null) {
                clipToPadding = parent.getClipToPadding();
                parent.setTagInternal(0x1020201, clipToPadding);
            }
            if (!deactivated) {
                clipSet.remove(transformedView);
                if (clipSet.isEmpty()) {
                    parent.setClipChildren(clipChildren);
                    parent.setClipToPadding(clipToPadding);
                    parent.setTagInternal(16908798, null);
                    clippingParameters.onClippingStateChanged(parent, true);
                }
            } else {
                clipSet.add(transformedView);
                parent.setClipChildren(false);
                parent.setClipToPadding(false);
                clippingParameters.onClippingStateChanged(parent, false);
            }
            if (clippingParameters.shouldFinish(parent)) {
                return;
            }
            ViewParent viewParent = parent.getParent();
            if (!(viewParent instanceof ViewGroup)) break;
            parent = (ViewGroup)viewParent;
        }
    }

    public static interface ClippingParameters {
        public boolean shouldFinish(View var1);

        default public boolean isClippingEnablingAllowed(View view) {
            return !MessagingPropertyAnimator.isAnimatingTranslation(view);
        }

        default public void onClippingStateChanged(View view, boolean isClipping) {
        }
    }
}

