/*
 * Decompiled with CFR 0.152.
 */
package com.android.internal.widget;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.database.DataSetObserver;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.util.Log;
import android.util.MathUtils;
import android.view.AbsSavedState;
import android.view.FocusFinder;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.SoundEffectConstants;
import android.view.VelocityTracker;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.view.animation.Interpolator;
import android.widget.EdgeEffect;
import android.widget.Scroller;
import com.android.internal.widget.PagerAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class ViewPager
extends ViewGroup {
    private static final String TAG = "ViewPager";
    private static final boolean DEBUG = false;
    private static final int MAX_SCROLL_X = 0x1000000;
    private static final boolean USE_CACHE = false;
    private static final int DEFAULT_OFFSCREEN_PAGES = 1;
    private static final int MAX_SETTLE_DURATION = 600;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int DEFAULT_GUTTER_SIZE = 16;
    private static final int MIN_FLING_VELOCITY = 400;
    private static final int[] LAYOUT_ATTRS = new int[]{16842931};
    private int mExpectedAdapterCount;
    private static final Comparator<ItemInfo> COMPARATOR = new Comparator<ItemInfo>(){

        @Override
        public int compare(ItemInfo lhs, ItemInfo rhs) {
            return lhs.position - rhs.position;
        }
    };
    private static final Interpolator sInterpolator = new Interpolator(){

        @Override
        public float getInterpolation(float t) {
            return (t -= 1.0f) * t * t * t * t + 1.0f;
        }
    };
    private final ArrayList<ItemInfo> mItems = new ArrayList();
    private final ItemInfo mTempItem = new ItemInfo();
    private final Rect mTempRect = new Rect();
    private PagerAdapter mAdapter;
    private int mCurItem;
    private int mRestoredCurItem = -1;
    private Parcelable mRestoredAdapterState = null;
    private ClassLoader mRestoredClassLoader = null;
    private final Scroller mScroller;
    private PagerObserver mObserver;
    private int mPageMargin;
    private Drawable mMarginDrawable;
    private int mTopPageBounds;
    private int mBottomPageBounds;
    private int mLeftIncr = -1;
    private float mFirstOffset = -3.4028235E38f;
    private float mLastOffset = Float.MAX_VALUE;
    private int mChildWidthMeasureSpec;
    private int mChildHeightMeasureSpec;
    private boolean mInLayout;
    private boolean mScrollingCacheEnabled;
    private boolean mPopulatePending;
    private int mOffscreenPageLimit = 1;
    private boolean mIsBeingDragged;
    private boolean mIsUnableToDrag;
    private final int mDefaultGutterSize;
    private int mGutterSize;
    private final int mTouchSlop;
    private float mLastMotionX;
    private float mLastMotionY;
    private float mInitialMotionX;
    private float mInitialMotionY;
    private int mActivePointerId = -1;
    private static final int INVALID_POINTER = -1;
    private VelocityTracker mVelocityTracker;
    private final int mMinimumVelocity;
    private final int mMaximumVelocity;
    private final int mFlingDistance;
    private final int mCloseEnough;
    private static final int CLOSE_ENOUGH = 2;
    private final EdgeEffect mLeftEdge;
    private final EdgeEffect mRightEdge;
    private boolean mFirstLayout = true;
    private boolean mCalledSuper;
    private int mDecorChildCount;
    private OnPageChangeListener mOnPageChangeListener;
    private OnPageChangeListener mInternalPageChangeListener;
    private OnAdapterChangeListener mAdapterChangeListener;
    private PageTransformer mPageTransformer;
    private static final int DRAW_ORDER_DEFAULT = 0;
    private static final int DRAW_ORDER_FORWARD = 1;
    private static final int DRAW_ORDER_REVERSE = 2;
    private int mDrawingOrder;
    private ArrayList<View> mDrawingOrderedChildren;
    private static final ViewPositionComparator sPositionComparator = new ViewPositionComparator();
    public static final int SCROLL_STATE_IDLE = 0;
    public static final int SCROLL_STATE_DRAGGING = 1;
    public static final int SCROLL_STATE_SETTLING = 2;
    private final Runnable mEndScrollRunnable = new Runnable(){

        @Override
        public void run() {
            ViewPager.this.setScrollState(0);
            ViewPager.this.populate();
        }
    };
    private int mScrollState = 0;

    public ViewPager(Context context) {
        this(context, null);
    }

    public ViewPager(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ViewPager(Context context, AttributeSet attrs, int defStyleAttr) {
        this(context, attrs, defStyleAttr, 0);
    }

    public ViewPager(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.setWillNotDraw(false);
        this.setDescendantFocusability(262144);
        this.setFocusable(true);
        this.mScroller = new Scroller(context, sInterpolator);
        ViewConfiguration configuration = ViewConfiguration.get(context);
        float density = context.getResources().getDisplayMetrics().density;
        this.mTouchSlop = configuration.getScaledPagingTouchSlop();
        this.mMinimumVelocity = (int)(400.0f * density);
        this.mMaximumVelocity = configuration.getScaledMaximumFlingVelocity();
        this.mLeftEdge = new EdgeEffect(context);
        this.mRightEdge = new EdgeEffect(context);
        this.mFlingDistance = (int)(25.0f * density);
        this.mCloseEnough = (int)(2.0f * density);
        this.mDefaultGutterSize = (int)(16.0f * density);
        if (this.getImportantForAccessibility() == 0) {
            this.setImportantForAccessibility(1);
        }
    }

    @Override
    protected void onDetachedFromWindow() {
        this.removeCallbacks(this.mEndScrollRunnable);
        super.onDetachedFromWindow();
    }

    private void setScrollState(int newState) {
        if (this.mScrollState == newState) {
            return;
        }
        this.mScrollState = newState;
        if (this.mPageTransformer != null) {
            this.enableLayers(newState != 0);
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrollStateChanged(newState);
        }
    }

    public void setAdapter(PagerAdapter adapter) {
        if (this.mAdapter != null) {
            this.mAdapter.unregisterDataSetObserver(this.mObserver);
            this.mAdapter.startUpdate(this);
            for (int i = 0; i < this.mItems.size(); ++i) {
                ItemInfo ii = this.mItems.get(i);
                this.mAdapter.destroyItem(this, ii.position, ii.object);
            }
            this.mAdapter.finishUpdate(this);
            this.mItems.clear();
            this.removeNonDecorViews();
            this.mCurItem = 0;
            this.scrollTo(0, 0);
        }
        PagerAdapter oldAdapter = this.mAdapter;
        this.mAdapter = adapter;
        this.mExpectedAdapterCount = 0;
        if (this.mAdapter != null) {
            if (this.mObserver == null) {
                this.mObserver = new PagerObserver();
            }
            this.mAdapter.registerDataSetObserver(this.mObserver);
            this.mPopulatePending = false;
            boolean wasFirstLayout = this.mFirstLayout;
            this.mFirstLayout = true;
            this.mExpectedAdapterCount = this.mAdapter.getCount();
            if (this.mRestoredCurItem >= 0) {
                this.mAdapter.restoreState(this.mRestoredAdapterState, this.mRestoredClassLoader);
                this.setCurrentItemInternal(this.mRestoredCurItem, false, true);
                this.mRestoredCurItem = -1;
                this.mRestoredAdapterState = null;
                this.mRestoredClassLoader = null;
            } else if (!wasFirstLayout) {
                this.populate();
            } else {
                this.requestLayout();
            }
        }
        if (this.mAdapterChangeListener != null && oldAdapter != adapter) {
            this.mAdapterChangeListener.onAdapterChanged(oldAdapter, adapter);
        }
    }

    private void removeNonDecorViews() {
        for (int i = 0; i < this.getChildCount(); ++i) {
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.isDecor) continue;
            this.removeViewAt(i);
            --i;
        }
    }

    public PagerAdapter getAdapter() {
        return this.mAdapter;
    }

    void setOnAdapterChangeListener(OnAdapterChangeListener listener) {
        this.mAdapterChangeListener = listener;
    }

    private int getPaddedWidth() {
        return this.getMeasuredWidth() - this.getPaddingLeft() - this.getPaddingRight();
    }

    public void setCurrentItem(int item) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, !this.mFirstLayout, false);
    }

    public void setCurrentItem(int item, boolean smoothScroll) {
        this.mPopulatePending = false;
        this.setCurrentItemInternal(item, smoothScroll, false);
    }

    public int getCurrentItem() {
        return this.mCurItem;
    }

    boolean setCurrentItemInternal(int item, boolean smoothScroll, boolean always) {
        return this.setCurrentItemInternal(item, smoothScroll, always, 0);
    }

    boolean setCurrentItemInternal(int item, boolean smoothScroll, boolean always, int velocity) {
        boolean dispatchSelected;
        if (this.mAdapter == null || this.mAdapter.getCount() <= 0) {
            this.setScrollingCacheEnabled(false);
            return false;
        }
        item = MathUtils.constrain(item, 0, this.mAdapter.getCount() - 1);
        if (!always && this.mCurItem == item && this.mItems.size() != 0) {
            this.setScrollingCacheEnabled(false);
            return false;
        }
        int pageLimit = this.mOffscreenPageLimit;
        if (item > this.mCurItem + pageLimit || item < this.mCurItem - pageLimit) {
            for (int i = 0; i < this.mItems.size(); ++i) {
                this.mItems.get((int)i).scrolling = true;
            }
        }
        boolean bl = dispatchSelected = this.mCurItem != item;
        if (this.mFirstLayout) {
            this.mCurItem = item;
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(item);
            }
            if (dispatchSelected && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.onPageSelected(item);
            }
            this.requestLayout();
        } else {
            this.populate(item);
            this.scrollToItem(item, smoothScroll, velocity, dispatchSelected);
        }
        return true;
    }

    private void scrollToItem(int position, boolean smoothScroll, int velocity, boolean dispatchSelected) {
        int destX = this.getLeftEdgeForItem(position);
        if (smoothScroll) {
            this.smoothScrollTo(destX, 0, velocity);
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(position);
            }
            if (dispatchSelected && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.onPageSelected(position);
            }
        } else {
            if (dispatchSelected && this.mOnPageChangeListener != null) {
                this.mOnPageChangeListener.onPageSelected(position);
            }
            if (dispatchSelected && this.mInternalPageChangeListener != null) {
                this.mInternalPageChangeListener.onPageSelected(position);
            }
            this.completeScroll(false);
            this.scrollTo(destX, 0);
            this.pageScrolled(destX);
        }
    }

    private int getLeftEdgeForItem(int position) {
        ItemInfo info = this.infoForPosition(position);
        if (info == null) {
            return 0;
        }
        int width = this.getPaddedWidth();
        int scaledOffset = (int)((float)width * MathUtils.constrain(info.offset, this.mFirstOffset, this.mLastOffset));
        if (this.isLayoutRtl()) {
            int itemWidth = (int)((float)width * info.widthFactor + 0.5f);
            return 0x1000000 - itemWidth - scaledOffset;
        }
        return scaledOffset;
    }

    public void setOnPageChangeListener(OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public void setPageTransformer(boolean reverseDrawingOrder, PageTransformer transformer) {
        boolean hasTransformer = transformer != null;
        boolean needsPopulate = hasTransformer != (this.mPageTransformer != null);
        this.mPageTransformer = transformer;
        this.setChildrenDrawingOrderEnabled(hasTransformer);
        this.mDrawingOrder = hasTransformer ? (reverseDrawingOrder ? 2 : 1) : 0;
        if (needsPopulate) {
            this.populate();
        }
    }

    @Override
    protected int getChildDrawingOrder(int childCount, int i) {
        int index = this.mDrawingOrder == 2 ? childCount - 1 - i : i;
        int result = ((LayoutParams)this.mDrawingOrderedChildren.get((int)index).getLayoutParams()).childIndex;
        return result;
    }

    OnPageChangeListener setInternalPageChangeListener(OnPageChangeListener listener) {
        OnPageChangeListener oldListener = this.mInternalPageChangeListener;
        this.mInternalPageChangeListener = listener;
        return oldListener;
    }

    public int getOffscreenPageLimit() {
        return this.mOffscreenPageLimit;
    }

    public void setOffscreenPageLimit(int limit) {
        if (limit < 1) {
            Log.w(TAG, "Requested offscreen page limit " + limit + " too small; defaulting to " + 1);
            limit = 1;
        }
        if (limit != this.mOffscreenPageLimit) {
            this.mOffscreenPageLimit = limit;
            this.populate();
        }
    }

    public void setPageMargin(int marginPixels) {
        int oldMargin = this.mPageMargin;
        this.mPageMargin = marginPixels;
        int width = this.getWidth();
        this.recomputeScrollPosition(width, width, marginPixels, oldMargin);
        this.requestLayout();
    }

    public int getPageMargin() {
        return this.mPageMargin;
    }

    public void setPageMarginDrawable(Drawable d) {
        this.mMarginDrawable = d;
        if (d != null) {
            this.refreshDrawableState();
        }
        this.setWillNotDraw(d == null);
        this.invalidate();
    }

    public void setPageMarginDrawable(int resId) {
        this.setPageMarginDrawable(this.getContext().getDrawable(resId));
    }

    @Override
    protected boolean verifyDrawable(Drawable who) {
        return super.verifyDrawable(who) || who == this.mMarginDrawable;
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        Drawable marginDrawable = this.mMarginDrawable;
        if (marginDrawable != null && marginDrawable.isStateful() && marginDrawable.setState(this.getDrawableState())) {
            this.invalidateDrawable(marginDrawable);
        }
    }

    float distanceInfluenceForSnapDuration(float f) {
        f -= 0.5f;
        f = (float)((double)f * 0.4712389167638204);
        return (float)Math.sin(f);
    }

    void smoothScrollTo(int x, int y) {
        this.smoothScrollTo(x, y, 0);
    }

    void smoothScrollTo(int x, int y, int velocity) {
        if (this.getChildCount() == 0) {
            this.setScrollingCacheEnabled(false);
            return;
        }
        int sx = this.getScrollX();
        int sy = this.getScrollY();
        int dx = x - sx;
        int dy = y - sy;
        if (dx == 0 && dy == 0) {
            this.completeScroll(false);
            this.populate();
            this.setScrollState(0);
            return;
        }
        this.setScrollingCacheEnabled(true);
        this.setScrollState(2);
        int width = this.getPaddedWidth();
        int halfWidth = width / 2;
        float distanceRatio = Math.min(1.0f, 1.0f * (float)Math.abs(dx) / (float)width);
        float distance = (float)halfWidth + (float)halfWidth * this.distanceInfluenceForSnapDuration(distanceRatio);
        int duration = 0;
        velocity = Math.abs(velocity);
        if (velocity > 0) {
            duration = 4 * Math.round(1000.0f * Math.abs(distance / (float)velocity));
        } else {
            float pageWidth = (float)width * this.mAdapter.getPageWidth(this.mCurItem);
            float pageDelta = (float)Math.abs(dx) / (pageWidth + (float)this.mPageMargin);
            duration = (int)((pageDelta + 1.0f) * 100.0f);
        }
        duration = Math.min(duration, 600);
        this.mScroller.startScroll(sx, sy, dx, dy, duration);
        this.postInvalidateOnAnimation();
    }

    ItemInfo addNewItem(int position, int index) {
        ItemInfo ii = new ItemInfo();
        ii.position = position;
        ii.object = this.mAdapter.instantiateItem(this, position);
        ii.widthFactor = this.mAdapter.getPageWidth(position);
        if (index < 0 || index >= this.mItems.size()) {
            this.mItems.add(ii);
        } else {
            this.mItems.add(index, ii);
        }
        return ii;
    }

    void dataSetChanged() {
        int adapterCount;
        this.mExpectedAdapterCount = adapterCount = this.mAdapter.getCount();
        boolean needPopulate = this.mItems.size() < this.mOffscreenPageLimit * 2 + 1 && this.mItems.size() < adapterCount;
        int newCurrItem = this.mCurItem;
        boolean isUpdating = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            int newPos = this.mAdapter.getItemPosition(ii.object);
            if (newPos == -1) continue;
            if (newPos == -2) {
                this.mItems.remove(i);
                --i;
                if (!isUpdating) {
                    this.mAdapter.startUpdate(this);
                    isUpdating = true;
                }
                this.mAdapter.destroyItem(this, ii.position, ii.object);
                needPopulate = true;
                if (this.mCurItem != ii.position) continue;
                newCurrItem = Math.max(0, Math.min(this.mCurItem, adapterCount - 1));
                needPopulate = true;
                continue;
            }
            if (ii.position == newPos) continue;
            if (ii.position == this.mCurItem) {
                newCurrItem = newPos;
            }
            ii.position = newPos;
            needPopulate = true;
        }
        if (isUpdating) {
            this.mAdapter.finishUpdate(this);
        }
        Collections.sort(this.mItems, COMPARATOR);
        if (needPopulate) {
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.isDecor) continue;
                lp.widthFactor = 0.0f;
            }
            this.setCurrentItemInternal(newCurrItem, false, true);
            this.requestLayout();
        }
    }

    public void populate() {
        this.populate(this.mCurItem);
    }

    void populate(int newCurrentItem) {
        ItemInfo ii;
        ItemInfo oldCurInfo = null;
        int focusDirection = 2;
        if (this.mCurItem != newCurrentItem) {
            focusDirection = this.mCurItem < newCurrentItem ? 66 : 17;
            oldCurInfo = this.infoForPosition(this.mCurItem);
            this.mCurItem = newCurrentItem;
        }
        if (this.mAdapter == null) {
            this.sortChildDrawingOrder();
            return;
        }
        if (this.mPopulatePending) {
            this.sortChildDrawingOrder();
            return;
        }
        if (this.getWindowToken() == null) {
            return;
        }
        this.mAdapter.startUpdate(this);
        int pageLimit = this.mOffscreenPageLimit;
        int startPos = Math.max(0, this.mCurItem - pageLimit);
        int N = this.mAdapter.getCount();
        int endPos = Math.min(N - 1, this.mCurItem + pageLimit);
        if (N != this.mExpectedAdapterCount) {
            String resName;
            try {
                resName = this.getResources().getResourceName(this.getId());
            }
            catch (Resources.NotFoundException e) {
                resName = Integer.toHexString(this.getId());
            }
            throw new IllegalStateException("The application's PagerAdapter changed the adapter's contents without calling PagerAdapter#notifyDataSetChanged! Expected adapter item count: " + this.mExpectedAdapterCount + ", found: " + N + " Pager id: " + resName + " Pager class: " + this.getClass() + " Problematic adapter: " + this.mAdapter.getClass());
        }
        int curIndex = -1;
        ItemInfo curItem = null;
        for (curIndex = 0; curIndex < this.mItems.size(); ++curIndex) {
            ItemInfo ii2 = this.mItems.get(curIndex);
            if (ii2.position < this.mCurItem) continue;
            if (ii2.position != this.mCurItem) break;
            curItem = ii2;
            break;
        }
        if (curItem == null && N > 0) {
            curItem = this.addNewItem(this.mCurItem, curIndex);
        }
        if (curItem != null) {
            float extraWidthLeft = 0.0f;
            int itemIndex = curIndex - 1;
            ii = itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
            int clientWidth = this.getPaddedWidth();
            float leftWidthNeeded = clientWidth <= 0 ? 0.0f : 2.0f - curItem.widthFactor + (float)this.getPaddingLeft() / (float)clientWidth;
            for (int pos = this.mCurItem - 1; pos >= 0; --pos) {
                if (extraWidthLeft >= leftWidthNeeded && pos < startPos) {
                    if (ii == null) break;
                    if (pos != ii.position || ii.scrolling) continue;
                    this.mItems.remove(itemIndex);
                    this.mAdapter.destroyItem(this, pos, ii.object);
                    --curIndex;
                    ii = --itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
                    continue;
                }
                if (ii != null && pos == ii.position) {
                    extraWidthLeft += ii.widthFactor;
                    ii = --itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
                    continue;
                }
                ii = this.addNewItem(pos, itemIndex + 1);
                extraWidthLeft += ii.widthFactor;
                ++curIndex;
                ii = itemIndex >= 0 ? this.mItems.get(itemIndex) : null;
            }
            float extraWidthRight = curItem.widthFactor;
            itemIndex = curIndex + 1;
            if (extraWidthRight < 2.0f) {
                ii = itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                float rightWidthNeeded = clientWidth <= 0 ? 0.0f : (float)this.getPaddingRight() / (float)clientWidth + 2.0f;
                for (int pos = this.mCurItem + 1; pos < N; ++pos) {
                    if (extraWidthRight >= rightWidthNeeded && pos > endPos) {
                        if (ii == null) break;
                        if (pos != ii.position || ii.scrolling) continue;
                        this.mItems.remove(itemIndex);
                        this.mAdapter.destroyItem(this, pos, ii.object);
                        ii = itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                        continue;
                    }
                    if (ii != null && pos == ii.position) {
                        extraWidthRight += ii.widthFactor;
                        ii = ++itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                        continue;
                    }
                    ii = this.addNewItem(pos, itemIndex);
                    extraWidthRight += ii.widthFactor;
                    ii = ++itemIndex < this.mItems.size() ? this.mItems.get(itemIndex) : null;
                }
            }
            this.calculatePageOffsets(curItem, curIndex, oldCurInfo);
        }
        this.mAdapter.setPrimaryItem(this, this.mCurItem, curItem != null ? curItem.object : null);
        this.mAdapter.finishUpdate(this);
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            ItemInfo ii3;
            View child = this.getChildAt(i);
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            lp.childIndex = i;
            if (lp.isDecor || lp.widthFactor != 0.0f || (ii3 = this.infoForChild(child)) == null) continue;
            lp.widthFactor = ii3.widthFactor;
            lp.position = ii3.position;
        }
        this.sortChildDrawingOrder();
        if (this.hasFocus()) {
            View currentFocused = this.findFocus();
            ItemInfo itemInfo = ii = currentFocused != null ? this.infoForAnyChild(currentFocused) : null;
            if (ii == null || ii.position != this.mCurItem) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    Rect focusRect;
                    View child = this.getChildAt(i);
                    ii = this.infoForChild(child);
                    if (ii == null || ii.position != this.mCurItem) continue;
                    if (currentFocused == null) {
                        focusRect = null;
                    } else {
                        focusRect = this.mTempRect;
                        currentFocused.getFocusedRect(this.mTempRect);
                        this.offsetDescendantRectToMyCoords(currentFocused, this.mTempRect);
                        this.offsetRectIntoDescendantCoords(child, this.mTempRect);
                    }
                    if (child.requestFocus(focusDirection, focusRect)) break;
                }
            }
        }
    }

    private void sortChildDrawingOrder() {
        if (this.mDrawingOrder != 0) {
            if (this.mDrawingOrderedChildren == null) {
                this.mDrawingOrderedChildren = new ArrayList();
            } else {
                this.mDrawingOrderedChildren.clear();
            }
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                this.mDrawingOrderedChildren.add(child);
            }
            Collections.sort(this.mDrawingOrderedChildren, sPositionComparator);
        }
    }

    private void calculatePageOffsets(ItemInfo curItem, int curIndex, ItemInfo oldCurInfo) {
        ItemInfo ii;
        float marginOffset;
        int N = this.mAdapter.getCount();
        int width = this.getPaddedWidth();
        float f = marginOffset = width > 0 ? (float)this.mPageMargin / (float)width : 0.0f;
        if (oldCurInfo != null) {
            int pos;
            float offset;
            int itemIndex;
            int oldCurPosition = oldCurInfo.position;
            if (oldCurPosition < curItem.position) {
                itemIndex = 0;
                offset = oldCurInfo.offset + oldCurInfo.widthFactor + marginOffset;
                for (pos = oldCurPosition + 1; pos <= curItem.position && itemIndex < this.mItems.size(); ++pos) {
                    ii = this.mItems.get(itemIndex);
                    while (pos > ii.position && itemIndex < this.mItems.size() - 1) {
                        ii = this.mItems.get(++itemIndex);
                    }
                    while (pos < ii.position) {
                        offset += this.mAdapter.getPageWidth(pos) + marginOffset;
                        ++pos;
                    }
                    ii.offset = offset;
                    offset += ii.widthFactor + marginOffset;
                }
            } else if (oldCurPosition > curItem.position) {
                itemIndex = this.mItems.size() - 1;
                offset = oldCurInfo.offset;
                for (pos = oldCurPosition - 1; pos >= curItem.position && itemIndex >= 0; --pos) {
                    ii = this.mItems.get(itemIndex);
                    while (pos < ii.position && itemIndex > 0) {
                        ii = this.mItems.get(--itemIndex);
                    }
                    while (pos > ii.position) {
                        offset -= this.mAdapter.getPageWidth(pos) + marginOffset;
                        --pos;
                    }
                    ii.offset = offset -= ii.widthFactor + marginOffset;
                }
            }
        }
        int itemCount = this.mItems.size();
        float offset = curItem.offset;
        int pos = curItem.position - 1;
        this.mFirstOffset = curItem.position == 0 ? curItem.offset : -3.4028235E38f;
        this.mLastOffset = curItem.position == N - 1 ? curItem.offset + curItem.widthFactor - 1.0f : Float.MAX_VALUE;
        int i = curIndex - 1;
        while (i >= 0) {
            ii = this.mItems.get(i);
            while (pos > ii.position) {
                offset -= this.mAdapter.getPageWidth(pos--) + marginOffset;
            }
            ii.offset = offset -= ii.widthFactor + marginOffset;
            if (ii.position == 0) {
                this.mFirstOffset = offset;
            }
            --i;
            --pos;
        }
        offset = curItem.offset + curItem.widthFactor + marginOffset;
        pos = curItem.position + 1;
        i = curIndex + 1;
        while (i < itemCount) {
            ii = this.mItems.get(i);
            while (pos < ii.position) {
                offset += this.mAdapter.getPageWidth(pos++) + marginOffset;
            }
            if (ii.position == N - 1) {
                this.mLastOffset = offset + ii.widthFactor - 1.0f;
            }
            ii.offset = offset;
            offset += ii.widthFactor + marginOffset;
            ++i;
            ++pos;
        }
    }

    @Override
    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.position = this.mCurItem;
        if (this.mAdapter != null) {
            ss.adapterState = this.mAdapter.saveState();
        }
        return ss;
    }

    @Override
    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        if (this.mAdapter != null) {
            this.mAdapter.restoreState(ss.adapterState, ss.loader);
            this.setCurrentItemInternal(ss.position, false, true);
        } else {
            this.mRestoredCurItem = ss.position;
            this.mRestoredAdapterState = ss.adapterState;
            this.mRestoredClassLoader = ss.loader;
        }
    }

    @Override
    public void addView(View child, int index, ViewGroup.LayoutParams params) {
        if (!this.checkLayoutParams(params)) {
            params = this.generateLayoutParams(params);
        }
        LayoutParams lp = (LayoutParams)params;
        lp.isDecor |= child instanceof Decor;
        if (this.mInLayout) {
            if (lp != null && lp.isDecor) {
                throw new IllegalStateException("Cannot add pager decor view during layout");
            }
            lp.needsMeasure = true;
            this.addViewInLayout(child, index, params);
        } else {
            super.addView(child, index, params);
        }
    }

    public Object getCurrent() {
        ItemInfo itemInfo = this.infoForPosition(this.getCurrentItem());
        return itemInfo == null ? null : itemInfo.object;
    }

    @Override
    public void removeView(View view) {
        if (this.mInLayout) {
            this.removeViewInLayout(view);
        } else {
            super.removeView(view);
        }
    }

    ItemInfo infoForChild(View child) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!this.mAdapter.isViewFromObject(child, ii.object)) continue;
            return ii;
        }
        return null;
    }

    ItemInfo infoForAnyChild(View child) {
        ViewParent parent;
        while ((parent = child.getParent()) != this) {
            if (parent == null || !(parent instanceof View)) {
                return null;
            }
            child = (View)((Object)parent);
        }
        return this.infoForChild(child);
    }

    ItemInfo infoForPosition(int position) {
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (ii.position != position) continue;
            return ii;
        }
        return null;
    }

    @Override
    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mFirstLayout = true;
    }

    @Override
    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        LayoutParams lp;
        View child;
        int i;
        this.setMeasuredDimension(ViewPager.getDefaultSize(0, widthMeasureSpec), ViewPager.getDefaultSize(0, heightMeasureSpec));
        int measuredWidth = this.getMeasuredWidth();
        int maxGutterSize = measuredWidth / 10;
        this.mGutterSize = Math.min(maxGutterSize, this.mDefaultGutterSize);
        int childWidthSize = measuredWidth - this.getPaddingLeft() - this.getPaddingRight();
        int childHeightSize = this.getMeasuredHeight() - this.getPaddingTop() - this.getPaddingBottom();
        int size = this.getChildCount();
        for (i = 0; i < size; ++i) {
            boolean consumeHorizontal;
            child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) == null || !lp.isDecor) continue;
            int hgrav = lp.gravity & 7;
            int vgrav = lp.gravity & 0x70;
            int widthMode = Integer.MIN_VALUE;
            int heightMode = Integer.MIN_VALUE;
            boolean consumeVertical = vgrav == 48 || vgrav == 80;
            boolean bl = consumeHorizontal = hgrav == 3 || hgrav == 5;
            if (consumeVertical) {
                widthMode = 0x40000000;
            } else if (consumeHorizontal) {
                heightMode = 0x40000000;
            }
            int widthSize = childWidthSize;
            int heightSize = childHeightSize;
            if (lp.width != -2) {
                widthMode = 0x40000000;
                if (lp.width != -1) {
                    widthSize = lp.width;
                }
            }
            if (lp.height != -2) {
                heightMode = 0x40000000;
                if (lp.height != -1) {
                    heightSize = lp.height;
                }
            }
            int widthSpec = View.MeasureSpec.makeMeasureSpec(widthSize, widthMode);
            int heightSpec = View.MeasureSpec.makeMeasureSpec(heightSize, heightMode);
            child.measure(widthSpec, heightSpec);
            if (consumeVertical) {
                childHeightSize -= child.getMeasuredHeight();
                continue;
            }
            if (!consumeHorizontal) continue;
            childWidthSize -= child.getMeasuredWidth();
        }
        this.mChildWidthMeasureSpec = View.MeasureSpec.makeMeasureSpec(childWidthSize, 0x40000000);
        this.mChildHeightMeasureSpec = View.MeasureSpec.makeMeasureSpec(childHeightSize, 0x40000000);
        this.mInLayout = true;
        this.populate();
        this.mInLayout = false;
        size = this.getChildCount();
        for (i = 0; i < size; ++i) {
            child = this.getChildAt(i);
            if (child.getVisibility() == 8 || (lp = (LayoutParams)child.getLayoutParams()) != null && lp.isDecor) continue;
            int widthSpec = View.MeasureSpec.makeMeasureSpec((int)((float)childWidthSize * lp.widthFactor), 0x40000000);
            child.measure(widthSpec, this.mChildHeightMeasureSpec);
        }
    }

    @Override
    protected void onSizeChanged(int w, int h, int oldw, int oldh) {
        super.onSizeChanged(w, h, oldw, oldh);
        if (w != oldw) {
            this.recomputeScrollPosition(w, oldw, this.mPageMargin, this.mPageMargin);
        }
    }

    private void recomputeScrollPosition(int width, int oldWidth, int margin, int oldMargin) {
        if (oldWidth > 0 && !this.mItems.isEmpty()) {
            int widthWithMargin = width - this.getPaddingLeft() - this.getPaddingRight() + margin;
            int oldWidthWithMargin = oldWidth - this.getPaddingLeft() - this.getPaddingRight() + oldMargin;
            int xpos = this.getScrollX();
            float pageOffset = (float)xpos / (float)oldWidthWithMargin;
            int newOffsetPixels = (int)(pageOffset * (float)widthWithMargin);
            this.scrollTo(newOffsetPixels, this.getScrollY());
            if (!this.mScroller.isFinished()) {
                int newDuration = this.mScroller.getDuration() - this.mScroller.timePassed();
                ItemInfo targetInfo = this.infoForPosition(this.mCurItem);
                this.mScroller.startScroll(newOffsetPixels, 0, (int)(targetInfo.offset * (float)width), 0, newDuration);
            }
        } else {
            ItemInfo ii = this.infoForPosition(this.mCurItem);
            float scrollOffset = ii != null ? Math.min(ii.offset, this.mLastOffset) : 0.0f;
            int scrollPos = (int)(scrollOffset * (float)(width - this.getPaddingLeft() - this.getPaddingRight()));
            if (scrollPos != this.getScrollX()) {
                this.completeScroll(false);
                this.scrollTo(scrollPos, this.getScrollY());
            }
        }
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int count = this.getChildCount();
        int width = r - l;
        int height = b - t;
        int paddingLeft = this.getPaddingLeft();
        int paddingTop = this.getPaddingTop();
        int paddingRight = this.getPaddingRight();
        int paddingBottom = this.getPaddingBottom();
        int scrollX = this.getScrollX();
        int decorCount = 0;
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            int childLeft = 0;
            int childTop = 0;
            if (!lp.isDecor) continue;
            int hgrav = lp.gravity & 7;
            int vgrav = lp.gravity & 0x70;
            switch (hgrav) {
                default: {
                    childLeft = paddingLeft;
                    break;
                }
                case 3: {
                    childLeft = paddingLeft;
                    paddingLeft += child.getMeasuredWidth();
                    break;
                }
                case 1: {
                    childLeft = Math.max((width - child.getMeasuredWidth()) / 2, paddingLeft);
                    break;
                }
                case 5: {
                    childLeft = width - paddingRight - child.getMeasuredWidth();
                    paddingRight += child.getMeasuredWidth();
                }
            }
            switch (vgrav) {
                default: {
                    childTop = paddingTop;
                    break;
                }
                case 48: {
                    childTop = paddingTop;
                    paddingTop += child.getMeasuredHeight();
                    break;
                }
                case 16: {
                    childTop = Math.max((height - child.getMeasuredHeight()) / 2, paddingTop);
                    break;
                }
                case 80: {
                    childTop = height - paddingBottom - child.getMeasuredHeight();
                    paddingBottom += child.getMeasuredHeight();
                }
            }
            child.layout(childLeft += scrollX, childTop, childLeft + child.getMeasuredWidth(), childTop + child.getMeasuredHeight());
            ++decorCount;
        }
        int childWidth = width - paddingLeft - paddingRight;
        for (int i = 0; i < count; ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() == 8) continue;
            LayoutParams lp = (LayoutParams)child.getLayoutParams();
            if (lp.isDecor || (ii = this.infoForChild(child)) == null) continue;
            if (lp.needsMeasure) {
                lp.needsMeasure = false;
                int widthSpec = View.MeasureSpec.makeMeasureSpec((int)((float)childWidth * lp.widthFactor), 0x40000000);
                int heightSpec = View.MeasureSpec.makeMeasureSpec(height - paddingTop - paddingBottom, 0x40000000);
                child.measure(widthSpec, heightSpec);
            }
            int childMeasuredWidth = child.getMeasuredWidth();
            int startOffset = (int)((float)childWidth * ii.offset);
            int childLeft = this.isLayoutRtl() ? 0x1000000 - paddingRight - startOffset - childMeasuredWidth : paddingLeft + startOffset;
            int childTop = paddingTop;
            child.layout(childLeft, childTop, childLeft + childMeasuredWidth, childTop + child.getMeasuredHeight());
        }
        this.mTopPageBounds = paddingTop;
        this.mBottomPageBounds = height - paddingBottom;
        this.mDecorChildCount = decorCount;
        if (this.mFirstLayout) {
            this.scrollToItem(this.mCurItem, false, 0, false);
        }
        this.mFirstLayout = false;
    }

    @Override
    public void computeScroll() {
        if (!this.mScroller.isFinished() && this.mScroller.computeScrollOffset()) {
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
                if (!this.pageScrolled(x)) {
                    this.mScroller.abortAnimation();
                    this.scrollTo(0, y);
                }
            }
            this.postInvalidateOnAnimation();
            return;
        }
        this.completeScroll(true);
    }

    private boolean pageScrolled(int scrollX) {
        if (this.mItems.size() == 0) {
            this.mCalledSuper = false;
            this.onPageScrolled(0, 0.0f, 0);
            if (!this.mCalledSuper) {
                throw new IllegalStateException("onPageScrolled did not call superclass implementation");
            }
            return false;
        }
        int scrollStart = this.isLayoutRtl() ? 0x1000000 - scrollX : scrollX;
        ItemInfo ii = this.infoForFirstVisiblePage();
        int width = this.getPaddedWidth();
        int widthWithMargin = width + this.mPageMargin;
        float marginOffset = (float)this.mPageMargin / (float)width;
        int currentPage = ii.position;
        float pageOffset = ((float)scrollStart / (float)width - ii.offset) / (ii.widthFactor + marginOffset);
        int offsetPixels = (int)(pageOffset * (float)widthWithMargin);
        this.mCalledSuper = false;
        this.onPageScrolled(currentPage, pageOffset, offsetPixels);
        if (!this.mCalledSuper) {
            throw new IllegalStateException("onPageScrolled did not call superclass implementation");
        }
        return true;
    }

    protected void onPageScrolled(int position, float offset, int offsetPixels) {
        int scrollX;
        if (this.mDecorChildCount > 0) {
            scrollX = this.getScrollX();
            int paddingLeft = this.getPaddingLeft();
            int paddingRight = this.getPaddingRight();
            int width = this.getWidth();
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (!lp.isDecor) continue;
                int hgrav = lp.gravity & 7;
                int childLeft = 0;
                switch (hgrav) {
                    default: {
                        childLeft = paddingLeft;
                        break;
                    }
                    case 3: {
                        childLeft = paddingLeft;
                        paddingLeft += child.getWidth();
                        break;
                    }
                    case 1: {
                        childLeft = Math.max((width - child.getMeasuredWidth()) / 2, paddingLeft);
                        break;
                    }
                    case 5: {
                        childLeft = width - paddingRight - child.getMeasuredWidth();
                        paddingRight += child.getMeasuredWidth();
                    }
                }
                int childOffset = (childLeft += scrollX) - child.getLeft();
                if (childOffset == 0) continue;
                child.offsetLeftAndRight(childOffset);
            }
        }
        if (this.mOnPageChangeListener != null) {
            this.mOnPageChangeListener.onPageScrolled(position, offset, offsetPixels);
        }
        if (this.mInternalPageChangeListener != null) {
            this.mInternalPageChangeListener.onPageScrolled(position, offset, offsetPixels);
        }
        if (this.mPageTransformer != null) {
            scrollX = this.getScrollX();
            int childCount = this.getChildCount();
            for (int i = 0; i < childCount; ++i) {
                View child = this.getChildAt(i);
                LayoutParams lp = (LayoutParams)child.getLayoutParams();
                if (lp.isDecor) continue;
                float transformPos = (float)(child.getLeft() - scrollX) / (float)this.getPaddedWidth();
                this.mPageTransformer.transformPage(child, transformPos);
            }
        }
        this.mCalledSuper = true;
    }

    private void completeScroll(boolean postEvents) {
        boolean needPopulate;
        boolean bl = needPopulate = this.mScrollState == 2;
        if (needPopulate) {
            this.setScrollingCacheEnabled(false);
            this.mScroller.abortAnimation();
            int oldX = this.getScrollX();
            int oldY = this.getScrollY();
            int x = this.mScroller.getCurrX();
            int y = this.mScroller.getCurrY();
            if (oldX != x || oldY != y) {
                this.scrollTo(x, y);
            }
        }
        this.mPopulatePending = false;
        for (int i = 0; i < this.mItems.size(); ++i) {
            ItemInfo ii = this.mItems.get(i);
            if (!ii.scrolling) continue;
            needPopulate = true;
            ii.scrolling = false;
        }
        if (needPopulate) {
            if (postEvents) {
                this.postOnAnimation(this.mEndScrollRunnable);
            } else {
                this.mEndScrollRunnable.run();
            }
        }
    }

    private boolean isGutterDrag(float x, float dx) {
        return x < (float)this.mGutterSize && dx > 0.0f || x > (float)(this.getWidth() - this.mGutterSize) && dx < 0.0f;
    }

    private void enableLayers(boolean enable) {
        int childCount = this.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            int layerType = enable ? 2 : 0;
            this.getChildAt(i).setLayerType(layerType, null);
        }
    }

    @Override
    public boolean onInterceptTouchEvent(MotionEvent ev) {
        int action = ev.getAction() & 0xFF;
        if (action == 3 || action == 1) {
            this.mIsBeingDragged = false;
            this.mIsUnableToDrag = false;
            this.mActivePointerId = -1;
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.recycle();
                this.mVelocityTracker = null;
            }
            return false;
        }
        if (action != 0) {
            if (this.mIsBeingDragged) {
                return true;
            }
            if (this.mIsUnableToDrag) {
                return false;
            }
        }
        switch (action) {
            case 2: {
                int activePointerId = this.mActivePointerId;
                if (activePointerId == -1) break;
                int pointerIndex = ev.findPointerIndex(activePointerId);
                float x = ev.getX(pointerIndex);
                float dx = x - this.mLastMotionX;
                float xDiff = Math.abs(dx);
                float y = ev.getY(pointerIndex);
                float yDiff = Math.abs(y - this.mInitialMotionY);
                if (dx != 0.0f && !this.isGutterDrag(this.mLastMotionX, dx) && this.canScroll(this, false, (int)dx, (int)x, (int)y)) {
                    this.mLastMotionX = x;
                    this.mLastMotionY = y;
                    this.mIsUnableToDrag = true;
                    return false;
                }
                if (xDiff > (float)this.mTouchSlop && xDiff * 0.5f > yDiff) {
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    this.mLastMotionX = dx > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                    this.mLastMotionY = y;
                    this.setScrollingCacheEnabled(true);
                } else if (yDiff > (float)this.mTouchSlop) {
                    this.mIsUnableToDrag = true;
                }
                if (!this.mIsBeingDragged || !this.performDrag(x)) break;
                this.postInvalidateOnAnimation();
                break;
            }
            case 0: {
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                this.mIsUnableToDrag = false;
                this.mScroller.computeScrollOffset();
                if (this.mScrollState == 2 && Math.abs(this.mScroller.getFinalX() - this.mScroller.getCurrX()) > this.mCloseEnough) {
                    this.mScroller.abortAnimation();
                    this.mPopulatePending = false;
                    this.populate();
                    this.mIsBeingDragged = true;
                    this.requestParentDisallowInterceptTouchEvent(true);
                    this.setScrollState(1);
                    break;
                }
                this.completeScroll(false);
                this.mIsBeingDragged = false;
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
            }
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        return this.mIsBeingDragged;
    }

    @Override
    public boolean onTouchEvent(MotionEvent ev) {
        if (ev.getAction() == 0 && ev.getEdgeFlags() != 0) {
            return false;
        }
        if (this.mAdapter == null || this.mAdapter.getCount() == 0) {
            return false;
        }
        if (this.mVelocityTracker == null) {
            this.mVelocityTracker = VelocityTracker.obtain();
        }
        this.mVelocityTracker.addMovement(ev);
        int action = ev.getAction();
        boolean needsInvalidate = false;
        switch (action & 0xFF) {
            case 0: {
                this.mScroller.abortAnimation();
                this.mPopulatePending = false;
                this.populate();
                this.mLastMotionX = this.mInitialMotionX = ev.getX();
                this.mLastMotionY = this.mInitialMotionY = ev.getY();
                this.mActivePointerId = ev.getPointerId(0);
                break;
            }
            case 2: {
                float x;
                if (!this.mIsBeingDragged) {
                    int pointerIndex = ev.findPointerIndex(this.mActivePointerId);
                    x = ev.getX(pointerIndex);
                    float xDiff = Math.abs(x - this.mLastMotionX);
                    float y = ev.getY(pointerIndex);
                    float yDiff = Math.abs(y - this.mLastMotionY);
                    if (xDiff > (float)this.mTouchSlop && xDiff > yDiff) {
                        this.mIsBeingDragged = true;
                        this.requestParentDisallowInterceptTouchEvent(true);
                        this.mLastMotionX = x - this.mInitialMotionX > 0.0f ? this.mInitialMotionX + (float)this.mTouchSlop : this.mInitialMotionX - (float)this.mTouchSlop;
                        this.mLastMotionY = y;
                        this.setScrollState(1);
                        this.setScrollingCacheEnabled(true);
                        ViewParent parent = this.getParent();
                        if (parent != null) {
                            parent.requestDisallowInterceptTouchEvent(true);
                        }
                    }
                }
                if (!this.mIsBeingDragged) break;
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                x = ev.getX(activePointerIndex);
                needsInvalidate |= this.performDrag(x);
                break;
            }
            case 1: {
                if (!this.mIsBeingDragged) break;
                VelocityTracker velocityTracker = this.mVelocityTracker;
                velocityTracker.computeCurrentVelocity(1000, this.mMaximumVelocity);
                int initialVelocity = (int)velocityTracker.getXVelocity(this.mActivePointerId);
                this.mPopulatePending = true;
                float scrollStart = this.getScrollStart();
                float scrolledPages = scrollStart / (float)this.getPaddedWidth();
                ItemInfo ii = this.infoForFirstVisiblePage();
                int currentPage = ii.position;
                float nextPageOffset = this.isLayoutRtl() ? (ii.offset - scrolledPages) / ii.widthFactor : (scrolledPages - ii.offset) / ii.widthFactor;
                int activePointerIndex = ev.findPointerIndex(this.mActivePointerId);
                float x = ev.getX(activePointerIndex);
                int totalDelta = (int)(x - this.mInitialMotionX);
                int nextPage = this.determineTargetPage(currentPage, nextPageOffset, initialVelocity, totalDelta);
                this.setCurrentItemInternal(nextPage, true, true, initialVelocity);
                this.mActivePointerId = -1;
                this.endDrag();
                this.mLeftEdge.onRelease();
                this.mRightEdge.onRelease();
                needsInvalidate = true;
                break;
            }
            case 3: {
                if (!this.mIsBeingDragged) break;
                this.scrollToItem(this.mCurItem, true, 0, false);
                this.mActivePointerId = -1;
                this.endDrag();
                this.mLeftEdge.onRelease();
                this.mRightEdge.onRelease();
                needsInvalidate = true;
                break;
            }
            case 5: {
                float x;
                int index = ev.getActionIndex();
                this.mLastMotionX = x = ev.getX(index);
                this.mActivePointerId = ev.getPointerId(index);
                break;
            }
            case 6: {
                this.onSecondaryPointerUp(ev);
                this.mLastMotionX = ev.getX(ev.findPointerIndex(this.mActivePointerId));
            }
        }
        if (needsInvalidate) {
            this.postInvalidateOnAnimation();
        }
        return true;
    }

    private void requestParentDisallowInterceptTouchEvent(boolean disallowIntercept) {
        ViewParent parent = this.getParent();
        if (parent != null) {
            parent.requestDisallowInterceptTouchEvent(disallowIntercept);
        }
    }

    private boolean performDrag(float x) {
        float clampedScrollStart;
        float over;
        EdgeEffect endEdge;
        EdgeEffect startEdge;
        boolean needsInvalidate = false;
        int width = this.getPaddedWidth();
        float deltaX = this.mLastMotionX - x;
        this.mLastMotionX = x;
        if (this.isLayoutRtl()) {
            startEdge = this.mRightEdge;
            endEdge = this.mLeftEdge;
        } else {
            startEdge = this.mLeftEdge;
            endEdge = this.mRightEdge;
        }
        float nextScrollX = (float)this.getScrollX() + deltaX;
        float scrollStart = this.isLayoutRtl() ? 1.6777216E7f - nextScrollX : nextScrollX;
        ItemInfo startItem = this.mItems.get(0);
        boolean startAbsolute = startItem.position == 0;
        float startBound = startAbsolute ? startItem.offset * (float)width : (float)width * this.mFirstOffset;
        ItemInfo endItem = this.mItems.get(this.mItems.size() - 1);
        boolean endAbsolute = endItem.position == this.mAdapter.getCount() - 1;
        float endBound = endAbsolute ? endItem.offset * (float)width : (float)width * this.mLastOffset;
        if (scrollStart < startBound) {
            if (startAbsolute) {
                over = startBound - scrollStart;
                startEdge.onPull(Math.abs(over) / (float)width);
                needsInvalidate = true;
            }
            clampedScrollStart = startBound;
        } else if (scrollStart > endBound) {
            if (endAbsolute) {
                over = scrollStart - endBound;
                endEdge.onPull(Math.abs(over) / (float)width);
                needsInvalidate = true;
            }
            clampedScrollStart = endBound;
        } else {
            clampedScrollStart = scrollStart;
        }
        float targetScrollX = this.isLayoutRtl() ? 1.6777216E7f - clampedScrollStart : clampedScrollStart;
        this.mLastMotionX += targetScrollX - (float)((int)targetScrollX);
        this.scrollTo((int)targetScrollX, this.getScrollY());
        this.pageScrolled((int)targetScrollX);
        return needsInvalidate;
    }

    private ItemInfo infoForFirstVisiblePage() {
        int startOffset = this.getScrollStart();
        int width = this.getPaddedWidth();
        float scrollOffset = width > 0 ? (float)startOffset / (float)width : 0.0f;
        float marginOffset = width > 0 ? (float)this.mPageMargin / (float)width : 0.0f;
        int lastPos = -1;
        float lastOffset = 0.0f;
        float lastWidth = 0.0f;
        boolean first = true;
        ItemInfo lastItem = null;
        int N = this.mItems.size();
        for (int i = 0; i < N; ++i) {
            float offset;
            ItemInfo ii = this.mItems.get(i);
            if (!first && ii.position != lastPos + 1) {
                ii = this.mTempItem;
                ii.offset = lastOffset + lastWidth + marginOffset;
                ii.position = lastPos + 1;
                ii.widthFactor = this.mAdapter.getPageWidth(ii.position);
                --i;
            }
            float startBound = offset = ii.offset;
            if (first || scrollOffset >= startBound) {
                float endBound = offset + ii.widthFactor + marginOffset;
                if (scrollOffset < endBound || i == this.mItems.size() - 1) {
                    return ii;
                }
            } else {
                return lastItem;
            }
            first = false;
            lastPos = ii.position;
            lastOffset = offset;
            lastWidth = ii.widthFactor;
            lastItem = ii;
        }
        return lastItem;
    }

    private int getScrollStart() {
        if (this.isLayoutRtl()) {
            return 0x1000000 - this.getScrollX();
        }
        return this.getScrollX();
    }

    private int determineTargetPage(int currentPage, float pageOffset, int velocity, int deltaX) {
        int targetPage;
        if (Math.abs(deltaX) > this.mFlingDistance && Math.abs(velocity) > this.mMinimumVelocity) {
            targetPage = currentPage - (velocity < 0 ? this.mLeftIncr : 0);
        } else {
            float truncator = currentPage >= this.mCurItem ? 0.4f : 0.6f;
            targetPage = (int)((float)currentPage - (float)this.mLeftIncr * (pageOffset + truncator));
        }
        if (this.mItems.size() > 0) {
            ItemInfo firstItem = this.mItems.get(0);
            ItemInfo lastItem = this.mItems.get(this.mItems.size() - 1);
            targetPage = MathUtils.constrain(targetPage, firstItem.position, lastItem.position);
        }
        return targetPage;
    }

    @Override
    public void draw(Canvas canvas) {
        super.draw(canvas);
        boolean needsInvalidate = false;
        int overScrollMode = this.getOverScrollMode();
        if (overScrollMode == 0 || overScrollMode == 1 && this.mAdapter != null && this.mAdapter.getCount() > 1) {
            int restoreCount;
            if (!this.mLeftEdge.isFinished()) {
                restoreCount = canvas.save();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                int width = this.getWidth();
                canvas.rotate(270.0f);
                canvas.translate(-height + this.getPaddingTop(), this.mFirstOffset * (float)width);
                this.mLeftEdge.setSize(height, width);
                needsInvalidate |= this.mLeftEdge.draw(canvas);
                canvas.restoreToCount(restoreCount);
            }
            if (!this.mRightEdge.isFinished()) {
                restoreCount = canvas.save();
                int width = this.getWidth();
                int height = this.getHeight() - this.getPaddingTop() - this.getPaddingBottom();
                canvas.rotate(90.0f);
                canvas.translate(-this.getPaddingTop(), -(this.mLastOffset + 1.0f) * (float)width);
                this.mRightEdge.setSize(height, width);
                needsInvalidate |= this.mRightEdge.draw(canvas);
                canvas.restoreToCount(restoreCount);
            }
        } else {
            this.mLeftEdge.finish();
            this.mRightEdge.finish();
        }
        if (needsInvalidate) {
            this.postInvalidateOnAnimation();
        }
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mPageMargin > 0 && this.mMarginDrawable != null && this.mItems.size() > 0 && this.mAdapter != null) {
            int scrollX = this.getScrollX();
            int width = this.getWidth();
            float marginOffset = (float)this.mPageMargin / (float)width;
            int itemIndex = 0;
            ItemInfo ii = this.mItems.get(0);
            float offset = ii.offset;
            int itemCount = this.mItems.size();
            int firstPos = ii.position;
            int lastPos = this.mItems.get((int)(itemCount - 1)).position;
            for (int pos = firstPos; pos < lastPos; ++pos) {
                float widthFactor;
                float itemOffset;
                while (pos > ii.position && itemIndex < itemCount) {
                    ii = this.mItems.get(++itemIndex);
                }
                if (pos == ii.position) {
                    itemOffset = ii.offset;
                    widthFactor = ii.widthFactor;
                } else {
                    itemOffset = offset;
                    widthFactor = this.mAdapter.getPageWidth(pos);
                }
                float scaledOffset = itemOffset * (float)width;
                float left = this.isLayoutRtl() ? 1.6777216E7f - scaledOffset : scaledOffset + widthFactor * (float)width;
                offset = itemOffset + widthFactor + marginOffset;
                if (left + (float)this.mPageMargin > (float)scrollX) {
                    this.mMarginDrawable.setBounds((int)left, this.mTopPageBounds, (int)(left + (float)this.mPageMargin + 0.5f), this.mBottomPageBounds);
                    this.mMarginDrawable.draw(canvas);
                }
                if (left > (float)(scrollX + width)) break;
            }
        }
    }

    private void onSecondaryPointerUp(MotionEvent ev) {
        int pointerIndex = ev.getActionIndex();
        int pointerId = ev.getPointerId(pointerIndex);
        if (pointerId == this.mActivePointerId) {
            int newPointerIndex = pointerIndex == 0 ? 1 : 0;
            this.mLastMotionX = ev.getX(newPointerIndex);
            this.mActivePointerId = ev.getPointerId(newPointerIndex);
            if (this.mVelocityTracker != null) {
                this.mVelocityTracker.clear();
            }
        }
    }

    private void endDrag() {
        this.mIsBeingDragged = false;
        this.mIsUnableToDrag = false;
        if (this.mVelocityTracker != null) {
            this.mVelocityTracker.recycle();
            this.mVelocityTracker = null;
        }
    }

    private void setScrollingCacheEnabled(boolean enabled) {
        if (this.mScrollingCacheEnabled != enabled) {
            this.mScrollingCacheEnabled = enabled;
        }
    }

    @Override
    public boolean canScrollHorizontally(int direction) {
        if (this.mAdapter == null) {
            return false;
        }
        int width = this.getPaddedWidth();
        int scrollX = this.getScrollX();
        if (direction < 0) {
            return scrollX > (int)((float)width * this.mFirstOffset);
        }
        if (direction > 0) {
            return scrollX < (int)((float)width * this.mLastOffset);
        }
        return false;
    }

    protected boolean canScroll(View v, boolean checkV, int dx, int x, int y) {
        if (v instanceof ViewGroup) {
            ViewGroup group = (ViewGroup)v;
            int scrollX = v.getScrollX();
            int scrollY = v.getScrollY();
            int count = group.getChildCount();
            for (int i = count - 1; i >= 0; --i) {
                View child = group.getChildAt(i);
                if (x + scrollX < child.getLeft() || x + scrollX >= child.getRight() || y + scrollY < child.getTop() || y + scrollY >= child.getBottom() || !this.canScroll(child, true, dx, x + scrollX - child.getLeft(), y + scrollY - child.getTop())) continue;
                return true;
            }
        }
        return checkV && v.canScrollHorizontally(-dx);
    }

    @Override
    public boolean dispatchKeyEvent(KeyEvent event) {
        return super.dispatchKeyEvent(event) || this.executeKeyEvent(event);
    }

    public boolean executeKeyEvent(KeyEvent event) {
        boolean handled = false;
        if (event.getAction() == 0) {
            switch (event.getKeyCode()) {
                case 21: {
                    handled = this.arrowScroll(17);
                    break;
                }
                case 22: {
                    handled = this.arrowScroll(66);
                    break;
                }
                case 61: {
                    if (event.hasNoModifiers()) {
                        handled = this.arrowScroll(2);
                        break;
                    }
                    if (!event.hasModifiers(1)) break;
                    handled = this.arrowScroll(1);
                }
            }
        }
        return handled;
    }

    public boolean arrowScroll(int direction) {
        View currentFocused = this.findFocus();
        if (currentFocused == this) {
            currentFocused = null;
        } else if (currentFocused != null) {
            boolean isChild = false;
            ViewParent parent = currentFocused.getParent();
            while (parent instanceof ViewGroup) {
                if (parent == this) {
                    isChild = true;
                    break;
                }
                parent = parent.getParent();
            }
            if (!isChild) {
                StringBuilder sb = new StringBuilder();
                sb.append(currentFocused.getClass().getSimpleName());
                ViewParent parent2 = currentFocused.getParent();
                while (parent2 instanceof ViewGroup) {
                    sb.append(" => ").append(parent2.getClass().getSimpleName());
                    parent2 = parent2.getParent();
                }
                Log.e(TAG, "arrowScroll tried to find focus based on non-child current focused view " + sb.toString());
                currentFocused = null;
            }
        }
        boolean handled = false;
        View nextFocused = FocusFinder.getInstance().findNextFocus(this, currentFocused, direction);
        if (nextFocused != null && nextFocused != currentFocused) {
            if (direction == 17) {
                int nextLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)nextFocused).left;
                int currLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)currentFocused).left;
                handled = currentFocused != null && nextLeft >= currLeft ? this.pageLeft() : nextFocused.requestFocus();
            } else if (direction == 66) {
                int nextLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)nextFocused).left;
                int currLeft = this.getChildRectInPagerCoordinates((Rect)this.mTempRect, (View)currentFocused).left;
                handled = currentFocused != null && nextLeft <= currLeft ? this.pageRight() : nextFocused.requestFocus();
            }
        } else if (direction == 17 || direction == 1) {
            handled = this.pageLeft();
        } else if (direction == 66 || direction == 2) {
            handled = this.pageRight();
        }
        if (handled) {
            this.playSoundEffect(SoundEffectConstants.getContantForFocusDirection(direction));
        }
        return handled;
    }

    private Rect getChildRectInPagerCoordinates(Rect outRect, View child) {
        if (outRect == null) {
            outRect = new Rect();
        }
        if (child == null) {
            outRect.set(0, 0, 0, 0);
            return outRect;
        }
        outRect.left = child.getLeft();
        outRect.right = child.getRight();
        outRect.top = child.getTop();
        outRect.bottom = child.getBottom();
        ViewParent parent = child.getParent();
        while (parent instanceof ViewGroup && parent != this) {
            ViewGroup group = (ViewGroup)parent;
            outRect.left += group.getLeft();
            outRect.right += group.getRight();
            outRect.top += group.getTop();
            outRect.bottom += group.getBottom();
            parent = group.getParent();
        }
        return outRect;
    }

    boolean pageLeft() {
        return this.setCurrentItemInternal(this.mCurItem + this.mLeftIncr, true, false);
    }

    boolean pageRight() {
        return this.setCurrentItemInternal(this.mCurItem - this.mLeftIncr, true, false);
    }

    @Override
    public void onRtlPropertiesChanged(int layoutDirection) {
        super.onRtlPropertiesChanged(layoutDirection);
        this.mLeftIncr = layoutDirection == 0 ? -1 : 1;
    }

    @Override
    public void addFocusables(ArrayList<View> views, int direction, int focusableMode) {
        int focusableCount = views.size();
        int descendantFocusability = this.getDescendantFocusability();
        if (descendantFocusability != 393216) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                ItemInfo ii;
                View child = this.getChildAt(i);
                if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
                child.addFocusables(views, direction, focusableMode);
            }
        }
        if (descendantFocusability != 262144 || focusableCount == views.size()) {
            if (!this.isFocusable()) {
                return;
            }
            if ((focusableMode & 1) == 1 && this.isInTouchMode() && !this.isFocusableInTouchMode()) {
                return;
            }
            if (views != null) {
                views.add(this);
            }
        }
    }

    @Override
    public void addTouchables(ArrayList<View> views) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem) continue;
            child.addTouchables(views);
        }
    }

    @Override
    protected boolean onRequestFocusInDescendants(int direction, Rect previouslyFocusedRect) {
        int end;
        int increment;
        int index;
        int count = this.getChildCount();
        if ((direction & 2) != 0) {
            index = 0;
            increment = 1;
            end = count;
        } else {
            index = count - 1;
            increment = -1;
            end = -1;
        }
        for (int i = index; i != end; i += increment) {
            ItemInfo ii;
            View child = this.getChildAt(i);
            if (child.getVisibility() != 0 || (ii = this.infoForChild(child)) == null || ii.position != this.mCurItem || !child.requestFocus(direction, previouslyFocusedRect)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams();
    }

    @Override
    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return this.generateDefaultLayoutParams();
    }

    @Override
    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams && super.checkLayoutParams(p);
    }

    @Override
    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    @Override
    public void onInitializeAccessibilityEvent(AccessibilityEvent event) {
        super.onInitializeAccessibilityEvent(event);
        event.setClassName(ViewPager.class.getName());
        event.setScrollable(this.canScroll());
        if (event.getEventType() == 4096 && this.mAdapter != null) {
            event.setItemCount(this.mAdapter.getCount());
            event.setFromIndex(this.mCurItem);
            event.setToIndex(this.mCurItem);
        }
    }

    @Override
    public void onInitializeAccessibilityNodeInfo(AccessibilityNodeInfo info) {
        super.onInitializeAccessibilityNodeInfo(info);
        info.setClassName(ViewPager.class.getName());
        info.setScrollable(this.canScroll());
        if (this.canScrollHorizontally(1)) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_FORWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_RIGHT);
        }
        if (this.canScrollHorizontally(-1)) {
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_BACKWARD);
            info.addAction(AccessibilityNodeInfo.AccessibilityAction.ACTION_SCROLL_LEFT);
        }
    }

    @Override
    public boolean performAccessibilityAction(int action, Bundle args) {
        if (super.performAccessibilityAction(action, args)) {
            return true;
        }
        switch (action) {
            case 4096: 
            case 16908347: {
                if (this.canScrollHorizontally(1)) {
                    this.setCurrentItem(this.mCurItem + 1);
                    return true;
                }
                return false;
            }
            case 8192: 
            case 16908345: {
                if (this.canScrollHorizontally(-1)) {
                    this.setCurrentItem(this.mCurItem - 1);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private boolean canScroll() {
        return this.mAdapter != null && this.mAdapter.getCount() > 1;
    }

    static class ViewPositionComparator
    implements Comparator<View> {
        ViewPositionComparator() {
        }

        @Override
        public int compare(View lhs, View rhs) {
            LayoutParams llp = (LayoutParams)lhs.getLayoutParams();
            LayoutParams rlp = (LayoutParams)rhs.getLayoutParams();
            if (llp.isDecor != rlp.isDecor) {
                return llp.isDecor ? 1 : -1;
            }
            return llp.position - rlp.position;
        }
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public boolean isDecor;
        public int gravity;
        float widthFactor = 0.0f;
        boolean needsMeasure;
        int position;
        int childIndex;

        public LayoutParams() {
            super(-1, -1);
        }

        public LayoutParams(Context context, AttributeSet attrs) {
            super(context, attrs);
            TypedArray a = context.obtainStyledAttributes(attrs, LAYOUT_ATTRS);
            this.gravity = a.getInteger(0, 48);
            a.recycle();
        }
    }

    private class PagerObserver
    extends DataSetObserver {
        private PagerObserver() {
        }

        @Override
        public void onChanged() {
            ViewPager.this.dataSetChanged();
        }

        @Override
        public void onInvalidated() {
            ViewPager.this.dataSetChanged();
        }
    }

    public static class SavedState
    extends AbsSavedState {
        int position;
        Parcelable adapterState;
        ClassLoader loader;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.ClassLoaderCreator<SavedState>(){

            @Override
            public SavedState createFromParcel(Parcel in, ClassLoader loader) {
                return new SavedState(in, loader);
            }

            @Override
            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in, null);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        public SavedState(Parcelable superState) {
            super(superState);
        }

        @Override
        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeInt(this.position);
            out.writeParcelable(this.adapterState, flags);
        }

        public String toString() {
            return "FragmentPager.SavedState{" + Integer.toHexString(System.identityHashCode(this)) + " position=" + this.position + "}";
        }

        SavedState(Parcel in, ClassLoader loader) {
            super(in, loader);
            if (loader == null) {
                loader = this.getClass().getClassLoader();
            }
            this.position = in.readInt();
            this.adapterState = in.readParcelable(loader);
            this.loader = loader;
        }
    }

    static interface Decor {
    }

    static interface OnAdapterChangeListener {
        public void onAdapterChanged(PagerAdapter var1, PagerAdapter var2);
    }

    public static interface PageTransformer {
        public void transformPage(View var1, float var2);
    }

    public static class SimpleOnPageChangeListener
    implements OnPageChangeListener {
        @Override
        public void onPageScrolled(int position, float positionOffset, int positionOffsetPixels) {
        }

        @Override
        public void onPageSelected(int position) {
        }

        @Override
        public void onPageScrollStateChanged(int state) {
        }
    }

    public static interface OnPageChangeListener {
        public void onPageScrolled(int var1, float var2, int var3);

        public void onPageSelected(int var1);

        public void onPageScrollStateChanged(int var1);
    }

    static class ItemInfo {
        Object object;
        boolean scrolling;
        float widthFactor;
        int position;
        float offset;

        ItemInfo() {
        }
    }
}

