/*
 * Decompiled with CFR 0.152.
 */
package com.android.layoutlib.bridge.android;

import android.icu.util.ULocale;
import com.android.layoutlib.bridge.android.BridgeContext;
import com.android.layoutlib.bridge.impl.RenderAction;
import java.util.Locale;

public class AndroidLocale {
    public static String toLanguageTag(Locale locale) {
        return ULocale.forLocale(locale).toLanguageTag();
    }

    public static String adjustLanguageCode(String languageCode) {
        String adjusted = languageCode.toLowerCase(Locale.US);
        if (languageCode.equals("he")) {
            adjusted = "iw";
        } else if (languageCode.equals("id")) {
            adjusted = "in";
        } else if (languageCode.equals("yi")) {
            adjusted = "ji";
        }
        return adjusted;
    }

    public static Locale forLanguageTag(String tag) {
        return ULocale.forLanguageTag(tag).toLocale();
    }

    public static String getScript(Locale locale) {
        return ULocale.forLocale(locale).getScript();
    }

    public static Locale getDefault() {
        Locale locale;
        BridgeContext context = RenderAction.getCurrentContext();
        if (context != null && (locale = context.getConfiguration().locale) != null) {
            return locale;
        }
        return Locale.getDefault();
    }
}

