/*
 * Decompiled with CFR 0.152.
 */
package dalvik.system;

import com.android.tools.layoutlib.annotations.LayoutlibDelegate;
import com.android.tools.layoutlib.create.OverrideMethod;
import dalvik.annotation.optimization.FastNative;
import dalvik.system.VMRuntime_Delegate;
import java.lang.ref.FinalizerReference;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;

public class VMRuntime {
    private static final VMRuntime THE_ONE = new VMRuntime();
    private static final Map<String, String> ABI_TO_INSTRUCTION_SET_MAP = new HashMap<String, String>(16);
    public static final int SDK_VERSION_CUR_DEVELOPMENT = 10000;
    private static Consumer<String> nonSdkApiUsageConsumer;
    private int targetSdkVersion = 10000;

    private VMRuntime() {
    }

    public static VMRuntime getRuntime() {
        return THE_ONE;
    }

    public String[] properties() {
        return (String[])OverrideMethod.invokeA("dalvik.system.VMRuntime#properties()[Ljava/lang/String;", true, this);
    }

    public String bootClassPath() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#bootClassPath()Ljava/lang/String;", true, this);
    }

    public String classPath() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#classPath()Ljava/lang/String;", true, this);
    }

    public String vmVersion() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmVersion()Ljava/lang/String;", true, this);
    }

    public String vmLibrary() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmLibrary()Ljava/lang/String;", true, this);
    }

    public String vmInstructionSet() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#vmInstructionSet()Ljava/lang/String;", true, this);
    }

    @FastNative
    public boolean is64Bit() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#is64Bit()Z", true, this) != 0;
    }

    @FastNative
    public boolean isCheckJniEnabled() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isCheckJniEnabled()Z", true, this) != 0;
    }

    public float getTargetHeapUtilization() {
        return OverrideMethod.invokeF("dalvik.system.VMRuntime#getTargetHeapUtilization()F", true, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public float setTargetHeapUtilization(float newTarget) {
        if (newTarget <= 0.0f || newTarget >= 1.0f) {
            throw new IllegalArgumentException(newTarget + " out of range (0,1)");
        }
        VMRuntime vMRuntime = this;
        synchronized (vMRuntime) {
            float oldTarget = this.getTargetHeapUtilization();
            this.nativeSetTargetHeapUtilization(newTarget);
            return oldTarget;
        }
    }

    public synchronized void setTargetSdkVersion(int targetSdkVersion) {
        this.targetSdkVersion = targetSdkVersion;
        this.setTargetSdkVersionNative(this.targetSdkVersion);
    }

    public synchronized int getTargetSdkVersion() {
        return this.targetSdkVersion;
    }

    private void setTargetSdkVersionNative(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setTargetSdkVersionNative(I)V", true, this);
    }

    @Deprecated
    public long getMinimumHeapSize() {
        return 0L;
    }

    @Deprecated
    public long setMinimumHeapSize(long size) {
        return 0L;
    }

    @Deprecated
    public void gcSoftReferences() {
    }

    @Deprecated
    public void runFinalizationSync() {
        System.runFinalization();
    }

    private void nativeSetTargetHeapUtilization(float f) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#nativeSetTargetHeapUtilization(F)V", true, this);
    }

    @Deprecated
    public boolean trackExternalAllocation(long size) {
        return true;
    }

    @Deprecated
    public void trackExternalFree(long size) {
    }

    @Deprecated
    public long getExternalBytesAllocated() {
        return 0L;
    }

    public void startJitCompilation() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#startJitCompilation()V", true, this);
    }

    public void disableJitCompilation() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#disableJitCompilation()V", true, this);
    }

    public boolean hasUsedHiddenApi() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#hasUsedHiddenApi()Z", true, this) != 0;
    }

    public void setHiddenApiExemptions(String[] stringArray) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setHiddenApiExemptions([Ljava/lang/String;)V", true, this);
    }

    public void setHiddenApiAccessLogSamplingRate(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setHiddenApiAccessLogSamplingRate(I)V", true, this);
    }

    @FastNative
    public Object newNonMovableArray(Class<?> clazz, int n) {
        return OverrideMethod.invokeA("dalvik.system.VMRuntime#newNonMovableArray(Ljava/lang/Class;I)Ljava/lang/Object;", true, this);
    }

    @LayoutlibDelegate
    @FastNative
    public Object newUnpaddedArray(Class<?> clazz, int n) {
        return VMRuntime_Delegate.newUnpaddedArray(this, clazz, n);
    }

    @FastNative
    public long addressOf(Object object) {
        return OverrideMethod.invokeL("dalvik.system.VMRuntime#addressOf(Ljava/lang/Object;)J", true, this);
    }

    public void clearGrowthLimit() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#clearGrowthLimit()V", true, this);
    }

    public void clampGrowthLimit() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#clampGrowthLimit()V", true, this);
    }

    @FastNative
    public boolean isDebuggerActive() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isDebuggerActive()Z", true, this) != 0;
    }

    @FastNative
    public boolean isNativeDebuggable() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isNativeDebuggable()Z", true, this) != 0;
    }

    public boolean isJavaDebuggable() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isJavaDebuggable()Z", true, this) != 0;
    }

    public void registerNativeAllocation(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerNativeAllocation(I)V", true, this);
    }

    public void registerNativeFree(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerNativeFree(I)V", true, this);
    }

    public static void runFinalization(long timeout) {
        try {
            FinalizerReference.finalizeAllEnqueued((long)timeout);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void requestConcurrentGC() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#requestConcurrentGC()V", true, this);
    }

    public void concurrentGC() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#concurrentGC()V", true, this);
    }

    public void requestHeapTrim() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#requestHeapTrim()V", true, this);
    }

    public void trimHeap() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#trimHeap()V", true, this);
    }

    public void startHeapTaskProcessor() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#startHeapTaskProcessor()V", true, this);
    }

    public void stopHeapTaskProcessor() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#stopHeapTaskProcessor()V", true, this);
    }

    public void runHeapTasks() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#runHeapTasks()V", true, this);
    }

    public void updateProcessState(int n) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#updateProcessState(I)V", true, this);
    }

    public void preloadDexCaches() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#preloadDexCaches()V", true, this);
    }

    public static void registerAppInfo(String string2, String[] stringArray) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerAppInfo(Ljava/lang/String;[Ljava/lang/String;)V", true, null);
    }

    public static String getInstructionSet(String abi) {
        String instructionSet = ABI_TO_INSTRUCTION_SET_MAP.get(abi);
        if (instructionSet == null) {
            throw new IllegalArgumentException("Unsupported ABI: " + abi);
        }
        return instructionSet;
    }

    public static boolean is64BitInstructionSet(String instructionSet) {
        return "arm64".equals(instructionSet) || "x86_64".equals(instructionSet) || "mips64".equals(instructionSet);
    }

    public static boolean is64BitAbi(String abi) {
        return VMRuntime.is64BitInstructionSet(VMRuntime.getInstructionSet(abi));
    }

    public static boolean isBootClassPathOnDisk(String string2) {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#isBootClassPathOnDisk(Ljava/lang/String;)Z", true, null) != 0;
    }

    public static String getCurrentInstructionSet() {
        return (String)OverrideMethod.invokeA("dalvik.system.VMRuntime#getCurrentInstructionSet()Ljava/lang/String;", true, null);
    }

    public static boolean didPruneDalvikCache() {
        return OverrideMethod.invokeI("dalvik.system.VMRuntime#didPruneDalvikCache()Z", true, null) != 0;
    }

    public static void registerSensitiveThread() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#registerSensitiveThread()V", true, null);
    }

    public static void setSystemDaemonThreadPriority() {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setSystemDaemonThreadPriority()V", true, null);
    }

    public static void setNonSdkApiUsageConsumer(Consumer<String> consumer) {
        nonSdkApiUsageConsumer = consumer;
    }

    public static void setDedupeHiddenApiWarnings(boolean bl) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setDedupeHiddenApiWarnings(Z)V", true, null);
    }

    public static void setProcessPackageName(String string2) {
        OverrideMethod.invokeV("dalvik.system.VMRuntime#setProcessPackageName(Ljava/lang/String;)V", true, null);
    }

    static {
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("armeabi-v7a", "arm");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips", "mips");
        ABI_TO_INSTRUCTION_SET_MAP.put("mips64", "mips64");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86", "x86");
        ABI_TO_INSTRUCTION_SET_MAP.put("x86_64", "x86_64");
        ABI_TO_INSTRUCTION_SET_MAP.put("arm64-v8a", "arm64");
        nonSdkApiUsageConsumer = null;
    }
}

