/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.com.amazonaws.http.apache.client.impl;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gradle.internal.impldep.com.amazonaws.http.AmazonHttpClient;
import org.gradle.internal.impldep.com.amazonaws.http.IdleConnectionReaper;
import org.gradle.internal.impldep.com.amazonaws.http.apache.SdkProxyRoutePlanner;
import org.gradle.internal.impldep.com.amazonaws.http.apache.client.impl.ApacheConnectionManagerFactory;
import org.gradle.internal.impldep.com.amazonaws.http.apache.client.impl.CRC32ChecksumResponseInterceptor;
import org.gradle.internal.impldep.com.amazonaws.http.apache.client.impl.ConnectionManagerAwareHttpClient;
import org.gradle.internal.impldep.com.amazonaws.http.apache.client.impl.SdkHttpClient;
import org.gradle.internal.impldep.com.amazonaws.http.apache.utils.ApacheUtils;
import org.gradle.internal.impldep.com.amazonaws.http.client.ConnectionManagerFactory;
import org.gradle.internal.impldep.com.amazonaws.http.client.HttpClientFactory;
import org.gradle.internal.impldep.com.amazonaws.http.conn.ClientConnectionManagerFactory;
import org.gradle.internal.impldep.com.amazonaws.http.conn.SdkConnectionKeepAliveStrategy;
import org.gradle.internal.impldep.com.amazonaws.http.protocol.SdkHttpRequestExecutor;
import org.gradle.internal.impldep.com.amazonaws.http.settings.HttpClientSettings;
import org.gradle.internal.impldep.org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.gradle.internal.impldep.org.apache.http.conn.HttpClientConnectionManager;
import org.gradle.internal.impldep.org.apache.http.impl.client.HttpClientBuilder;
import org.gradle.internal.impldep.org.apache.http.impl.client.HttpClients;

public class ApacheHttpClientFactory
implements HttpClientFactory<ConnectionManagerAwareHttpClient> {
    private static final Log LOG = LogFactory.getLog(AmazonHttpClient.class);
    private final ConnectionManagerFactory<HttpClientConnectionManager> cmFactory = new ApacheConnectionManagerFactory();

    @Override
    public ConnectionManagerAwareHttpClient create(HttpClientSettings settings) {
        HttpClientBuilder builder = HttpClients.custom();
        HttpClientConnectionManager cm = this.cmFactory.create(settings);
        builder.setRequestExecutor(new SdkHttpRequestExecutor()).setKeepAliveStrategy(this.buildKeepAliveStrategy(settings)).disableRedirectHandling().disableAutomaticRetries().setConnectionManager(ClientConnectionManagerFactory.wrap(cm));
        if (!settings.useGzip()) {
            builder.disableContentCompression();
        }
        CRC32ChecksumResponseInterceptor itcp = new CRC32ChecksumResponseInterceptor();
        if (settings.calculateCRC32FromCompressedData()) {
            builder.addInterceptorFirst(itcp);
        } else {
            builder.addInterceptorLast(itcp);
        }
        this.addProxyConfig(builder, settings);
        SdkHttpClient httpClient = new SdkHttpClient(builder.build(), cm);
        if (settings.useReaper()) {
            IdleConnectionReaper.registerConnectionManager(cm, settings.getMaxIdleConnectionTime());
        }
        return httpClient;
    }

    private void addProxyConfig(HttpClientBuilder builder, HttpClientSettings settings) {
        if (settings.isProxyEnabled()) {
            LOG.info((Object)("Configuring Proxy. Proxy Host: " + settings.getProxyHost() + " Proxy Port: " + settings.getProxyPort()));
            builder.setRoutePlanner(new SdkProxyRoutePlanner(settings.getProxyHost(), settings.getProxyPort(), settings.getNonProxyHosts()));
            if (settings.isAuthenticatedProxy()) {
                builder.setDefaultCredentialsProvider(ApacheUtils.newProxyCredentialsProvider(settings));
            }
        }
    }

    private ConnectionKeepAliveStrategy buildKeepAliveStrategy(HttpClientSettings settings) {
        return settings.getMaxIdleConnectionTime() > 0L ? new SdkConnectionKeepAliveStrategy(settings.getMaxIdleConnectionTime()) : null;
    }
}

