/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.configuration.internal;

import java.io.File;
import org.gradle.internal.impldep.org.apache.maven.configuration.BeanConfigurationException;
import org.gradle.internal.impldep.org.apache.maven.configuration.BeanConfigurationPathTranslator;
import org.gradle.internal.impldep.org.apache.maven.configuration.BeanConfigurationRequest;
import org.gradle.internal.impldep.org.apache.maven.configuration.BeanConfigurationValuePreprocessor;
import org.gradle.internal.impldep.org.apache.maven.configuration.BeanConfigurator;
import org.gradle.internal.impldep.org.codehaus.plexus.component.annotations.Component;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.composite.ObjectWithFieldsConverter;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.converters.lookup.DefaultConverterLookup;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.gradle.internal.impldep.org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.PlexusConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.configuration.xml.XmlPlexusConfiguration;
import org.gradle.internal.impldep.org.codehaus.plexus.util.xml.Xpp3Dom;

@Component(role=BeanConfigurator.class)
public class DefaultBeanConfigurator
implements BeanConfigurator {
    private final ConverterLookup converterLookup = new DefaultConverterLookup();

    public void configureBean(BeanConfigurationRequest request) throws BeanConfigurationException {
        ClassLoader classLoader;
        if (request == null) {
            throw new IllegalArgumentException("bean configuration request not specified");
        }
        if (request.getBean() == null) {
            throw new IllegalArgumentException("bean to be configured not specified");
        }
        Object configuration = request.getConfiguration();
        if (configuration == null) {
            return;
        }
        PlexusConfiguration plexusConfig = null;
        if (configuration instanceof PlexusConfiguration) {
            plexusConfig = (PlexusConfiguration)configuration;
        } else if (configuration instanceof Xpp3Dom) {
            plexusConfig = new XmlPlexusConfiguration((Xpp3Dom)configuration);
        } else {
            throw new BeanConfigurationException("unsupported bean configuration source (" + configuration.getClass().getName() + ")");
        }
        if (request.getConfigurationElement() != null) {
            plexusConfig = plexusConfig.getChild(request.getConfigurationElement());
        }
        if ((classLoader = request.getClassLoader()) == null) {
            classLoader = request.getBean().getClass().getClassLoader();
        }
        BeanExpressionEvaluator evaluator = new BeanExpressionEvaluator(request);
        ObjectWithFieldsConverter converter = new ObjectWithFieldsConverter();
        try {
            converter.processConfiguration(this.converterLookup, request.getBean(), classLoader, plexusConfig, evaluator);
        }
        catch (ComponentConfigurationException e) {
            throw new BeanConfigurationException(e.getMessage(), e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class BeanExpressionEvaluator
    implements TypeAwareExpressionEvaluator {
        private final BeanConfigurationValuePreprocessor preprocessor;
        private final BeanConfigurationPathTranslator translator;

        public BeanExpressionEvaluator(BeanConfigurationRequest request) {
            this.preprocessor = request.getValuePreprocessor();
            this.translator = request.getPathTranslator();
        }

        @Override
        public Object evaluate(String expression, Class<?> type) throws ExpressionEvaluationException {
            if (this.preprocessor != null) {
                try {
                    return this.preprocessor.preprocessValue(expression, type);
                }
                catch (BeanConfigurationException e) {
                    throw new ExpressionEvaluationException(e.getMessage(), e);
                }
            }
            return expression;
        }

        @Override
        public Object evaluate(String expression) throws ExpressionEvaluationException {
            return this.evaluate(expression, null);
        }

        @Override
        public File alignToBaseDirectory(File file) {
            if (this.translator != null) {
                return this.translator.translatePath(file);
            }
            return file;
        }
    }
}

