/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Metadata;
import org.gradle.internal.impldep.org.apache.maven.artifact.repository.metadata.Versioning;
import org.gradle.internal.impldep.org.apache.maven.repository.internal.MavenMetadata;
import org.gradle.internal.impldep.org.sonatype.aether.artifact.Artifact;
import org.gradle.internal.impldep.org.sonatype.aether.metadata.Metadata;

final class VersionsMetadata
extends MavenMetadata {
    private final Artifact artifact;

    public VersionsMetadata(Artifact artifact) {
        super(VersionsMetadata.createMetadata(artifact), null);
        this.artifact = artifact;
    }

    public VersionsMetadata(Artifact artifact, File file) {
        super(VersionsMetadata.createMetadata(artifact), file);
        this.artifact = artifact;
    }

    private static Metadata createMetadata(Artifact artifact) {
        Versioning versioning = new Versioning();
        versioning.addVersion(artifact.getBaseVersion());
        if (!artifact.isSnapshot()) {
            versioning.setRelease(artifact.getBaseVersion());
        }
        if ("maven-plugin".equals(artifact.getProperty("type", ""))) {
            versioning.setLatest(artifact.getBaseVersion());
        }
        Metadata metadata = new Metadata();
        metadata.setVersioning(versioning);
        metadata.setGroupId(artifact.getGroupId());
        metadata.setArtifactId(artifact.getArtifactId());
        return metadata;
    }

    protected void merge(Metadata recessive) {
        Versioning versioning = this.metadata.getVersioning();
        versioning.updateTimestamp();
        if (recessive.getVersioning() != null) {
            if (versioning.getLatest() == null) {
                versioning.setLatest(recessive.getVersioning().getLatest());
            }
            if (versioning.getRelease() == null) {
                versioning.setRelease(recessive.getVersioning().getRelease());
            }
            LinkedHashSet<String> versions = new LinkedHashSet<String>(recessive.getVersioning().getVersions());
            versions.addAll(versioning.getVersions());
            versioning.setVersions(new ArrayList<String>(versions));
        }
    }

    public Object getKey() {
        return this.getGroupId() + ':' + this.getArtifactId();
    }

    public static Object getKey(Artifact artifact) {
        return artifact.getGroupId() + ':' + artifact.getArtifactId();
    }

    public MavenMetadata setFile(File file) {
        return new VersionsMetadata(this.artifact, file);
    }

    public String getGroupId() {
        return this.artifact.getGroupId();
    }

    public String getArtifactId() {
        return this.artifact.getArtifactId();
    }

    public String getVersion() {
        return "";
    }

    public Metadata.Nature getNature() {
        return this.artifact.isSnapshot() ? Metadata.Nature.RELEASE_OR_SNAPSHOT : Metadata.Nature.RELEASE;
    }
}

