/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.apache.maven.wagon.observers;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.gradle.internal.impldep.org.apache.maven.wagon.events.TransferEvent;
import org.gradle.internal.impldep.org.apache.maven.wagon.events.TransferListener;

public class ChecksumObserver
implements TransferListener {
    private MessageDigest digester = null;
    private String actualChecksum;

    public ChecksumObserver() throws NoSuchAlgorithmException {
        this("MD5");
    }

    public ChecksumObserver(String algorithm) throws NoSuchAlgorithmException {
        this.digester = MessageDigest.getInstance(algorithm);
    }

    public void transferInitiated(TransferEvent transferEvent) {
    }

    public void transferStarted(TransferEvent transferEvent) {
        this.actualChecksum = null;
        this.digester.reset();
    }

    public void transferProgress(TransferEvent transferEvent, byte[] buffer, int length) {
        this.digester.update(buffer, 0, length);
    }

    public void transferCompleted(TransferEvent transferEvent) {
        this.actualChecksum = this.encode(this.digester.digest());
    }

    public void transferError(TransferEvent transferEvent) {
        this.digester.reset();
        this.actualChecksum = null;
    }

    public void debug(String message) {
    }

    public String getActualChecksum() {
        return this.actualChecksum;
    }

    protected String encode(byte[] binaryData) {
        if (binaryData.length != 16 && binaryData.length != 20) {
            int bitLength = binaryData.length * 8;
            throw new IllegalArgumentException("Unrecognised length for binary data: " + bitLength + " bits");
        }
        StringBuilder retValue = new StringBuilder();
        for (int i = 0; i < binaryData.length; ++i) {
            String t = Integer.toHexString(binaryData[i] & 0xFF);
            if (t.length() == 1) {
                retValue.append('0').append(t);
                continue;
            }
            retValue.append(t);
        }
        return retValue.toString().trim();
    }
}

