/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.hooks;

import java.io.IOException;
import java.io.PrintStream;
import java.util.Collection;
import org.gradle.internal.impldep.org.eclipse.jgit.api.errors.AbortedByHookException;
import org.gradle.internal.impldep.org.eclipse.jgit.hooks.GitHook;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Repository;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.RemoteRefUpdate;

public class PrePushHook
extends GitHook<String> {
    public static final String NAME = "pre-push";
    private String remoteName;
    private String remoteLocation;
    private String refs;

    protected PrePushHook(Repository repo, PrintStream outputStream) {
        super(repo, outputStream);
    }

    @Override
    protected String getStdinArgs() {
        return this.refs;
    }

    @Override
    public String call() throws IOException, AbortedByHookException {
        if (this.canRun()) {
            this.doRun();
        }
        return "";
    }

    private boolean canRun() {
        return true;
    }

    @Override
    public String getHookName() {
        return NAME;
    }

    @Override
    protected String[] getParameters() {
        if (this.remoteName == null) {
            this.remoteName = this.remoteLocation;
        }
        return new String[]{this.remoteName, this.remoteLocation};
    }

    public void setRemoteName(String name) {
        this.remoteName = name;
    }

    public void setRemoteLocation(String location) {
        this.remoteLocation = location;
    }

    public void setRefs(Collection<RemoteRefUpdate> toRefs) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (RemoteRefUpdate u : toRefs) {
            if (!first) {
                b.append("\n");
            } else {
                first = false;
            }
            b.append(u.getSrcRef());
            b.append(" ");
            b.append(u.getNewObjectId().getName());
            b.append(" ");
            b.append(u.getRemoteName());
            b.append(" ");
            ObjectId ooid = u.getExpectedOldObjectId();
            b.append(ooid == null ? ObjectId.zeroId().getName() : ooid.getName());
        }
        this.refs = b.toString();
    }
}

