/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.lib;

import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.ProgressMonitor;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.WorkQueue;

public abstract class BatchingProgressMonitor
implements ProgressMonitor {
    private long delayStartTime;
    private TimeUnit delayStartUnit = TimeUnit.MILLISECONDS;
    private Task task;

    public void setDelayStart(long time, TimeUnit unit) {
        this.delayStartTime = time;
        this.delayStartUnit = unit;
    }

    @Override
    public void start(int totalTasks) {
    }

    @Override
    public void beginTask(String title, int work) {
        this.endTask();
        this.task = new Task(title, work);
        if (this.delayStartTime != 0L) {
            this.task.delay(this.delayStartTime, this.delayStartUnit);
        }
    }

    @Override
    public void update(int completed) {
        if (this.task != null) {
            this.task.update(this, completed);
        }
    }

    @Override
    public void endTask() {
        if (this.task != null) {
            this.task.end(this);
            this.task = null;
        }
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    protected abstract void onUpdate(String var1, int var2);

    protected abstract void onEndTask(String var1, int var2);

    protected abstract void onUpdate(String var1, int var2, int var3, int var4);

    protected abstract void onEndTask(String var1, int var2, int var3, int var4);

    private static class Task
    implements Runnable {
        private final String taskName;
        private final int totalWork;
        private volatile boolean display;
        private Future<?> timerFuture;
        private boolean output;
        private int lastWork;
        private int lastPercent;

        Task(String taskName, int totalWork) {
            this.taskName = taskName;
            this.totalWork = totalWork;
            this.display = true;
        }

        void delay(long time, TimeUnit unit) {
            this.display = false;
            this.timerFuture = WorkQueue.getExecutor().schedule(this, time, unit);
        }

        @Override
        public void run() {
            this.display = true;
        }

        void update(BatchingProgressMonitor pm, int completed) {
            this.lastWork += completed;
            if (this.totalWork == 0) {
                if (this.display) {
                    pm.onUpdate(this.taskName, this.lastWork);
                    this.output = true;
                    this.restartTimer();
                }
            } else {
                int currPercent = this.lastWork * 100 / this.totalWork;
                if (this.display) {
                    pm.onUpdate(this.taskName, this.lastWork, this.totalWork, currPercent);
                    this.output = true;
                    this.restartTimer();
                    this.lastPercent = currPercent;
                } else if (currPercent != this.lastPercent) {
                    pm.onUpdate(this.taskName, this.lastWork, this.totalWork, currPercent);
                    this.output = true;
                    this.lastPercent = currPercent;
                }
            }
        }

        private void restartTimer() {
            this.display = false;
            this.timerFuture = WorkQueue.getExecutor().schedule(this, 1L, TimeUnit.SECONDS);
        }

        void end(BatchingProgressMonitor pm) {
            if (this.output) {
                if (this.totalWork == 0) {
                    pm.onEndTask(this.taskName, this.lastWork);
                } else {
                    int pDone = this.lastWork * 100 / this.totalWork;
                    pm.onEndTask(this.taskName, this.lastWork, this.totalWork, pDone);
                }
            }
            if (this.timerFuture != null) {
                this.timerFuture.cancel(false);
            }
        }
    }
}

