/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.nls;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.gradle.internal.impldep.org.eclipse.jgit.nls.TranslationBundle;

class GlobalBundleCache {
    private static final Map<Locale, Map<Class, TranslationBundle>> cachedBundles = new HashMap<Locale, Map<Class, TranslationBundle>>();

    GlobalBundleCache() {
    }

    static synchronized <T extends TranslationBundle> T lookupBundle(Locale locale, Class<T> type) {
        try {
            TranslationBundle bundle;
            Map<Class, TranslationBundle> bundles = cachedBundles.get(locale);
            if (bundles == null) {
                bundles = new HashMap<Class, TranslationBundle>();
                cachedBundles.put(locale, bundles);
            }
            if ((bundle = bundles.get(type)) == null) {
                bundle = (TranslationBundle)type.newInstance();
                bundle.load(locale);
                bundles.put(type, bundle);
            }
            return (T)bundle;
        }
        catch (InstantiationException e) {
            throw new Error(e);
        }
        catch (IllegalAccessException e) {
            throw new Error(e);
        }
    }
}

