/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.patch;

import java.io.IOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.AbbreviatedObjectId;
import org.gradle.internal.impldep.org.eclipse.jgit.patch.CombinedFileHeader;
import org.gradle.internal.impldep.org.eclipse.jgit.patch.HunkHeader;
import org.gradle.internal.impldep.org.eclipse.jgit.patch.Patch;
import org.gradle.internal.impldep.org.eclipse.jgit.util.MutableInteger;
import org.gradle.internal.impldep.org.eclipse.jgit.util.RawParseUtils;

public class CombinedHunkHeader
extends HunkHeader {
    private CombinedOldImage[] old;

    CombinedHunkHeader(final CombinedFileHeader fh, int offset) {
        super(fh, offset, null);
        this.old = new CombinedOldImage[fh.getParentCount()];
        for (int i = 0; i < this.old.length; ++i) {
            final int imagePos = i;
            this.old[i] = new CombinedOldImage(){

                @Override
                public AbbreviatedObjectId getId() {
                    return fh.getOldId(imagePos);
                }
            };
        }
    }

    @Override
    public CombinedFileHeader getFileHeader() {
        return (CombinedFileHeader)super.getFileHeader();
    }

    @Override
    public HunkHeader.OldImage getOldImage() {
        return this.getOldImage(0);
    }

    public HunkHeader.OldImage getOldImage(int nthParent) {
        return this.old[nthParent];
    }

    @Override
    void parseHeader() {
        byte[] buf = this.file.buf;
        MutableInteger ptr = new MutableInteger();
        ptr.value = RawParseUtils.nextLF(buf, this.startOffset, ' ');
        for (int n = 0; n < this.old.length; ++n) {
            this.old[n].startLine = -RawParseUtils.parseBase10(buf, ptr.value, ptr);
            this.old[n].lineCount = buf[ptr.value] == 44 ? RawParseUtils.parseBase10(buf, ptr.value + 1, ptr) : 1;
        }
        this.newStartLine = RawParseUtils.parseBase10(buf, ptr.value + 1, ptr);
        this.newLineCount = buf[ptr.value] == 44 ? RawParseUtils.parseBase10(buf, ptr.value + 1, ptr) : 1;
    }

    @Override
    int parseBody(Patch script, int end) {
        int eol;
        byte[] buf = this.file.buf;
        int c = RawParseUtils.nextLF(buf, this.startOffset);
        for (CombinedOldImage o : this.old) {
            o.nDeleted = 0;
            o.nAdded = 0;
            o.nContext = 0;
        }
        this.nContext = 0;
        int nAdded = 0;
        block9: while (c < end && (eol = RawParseUtils.nextLF(buf, c)) - c >= this.old.length + 1) {
            switch (buf[c]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block9;
                }
            }
            int localcontext = 0;
            block10: for (int ancestor = 0; ancestor < this.old.length; ++ancestor) {
                switch (buf[c + ancestor]) {
                    case 32: {
                        ++localcontext;
                        ++this.old[ancestor].nContext;
                        continue block10;
                    }
                    case 45: {
                        ++this.old[ancestor].nDeleted;
                        continue block10;
                    }
                    case 43: {
                        ++this.old[ancestor].nAdded;
                        ++nAdded;
                        continue block10;
                    }
                    default: {
                        break block9;
                    }
                }
            }
            if (localcontext == this.old.length) {
                ++this.nContext;
            }
            c = eol;
        }
        for (int ancestor = 0; ancestor < this.old.length; ++ancestor) {
            CombinedOldImage o = this.old[ancestor];
            int cmp = o.nContext + o.nDeleted;
            if (cmp >= o.lineCount) continue;
            int missingCnt = o.lineCount - cmp;
            script.error(buf, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkLinesMissingForAncestor, missingCnt, ancestor + 1));
        }
        if (this.nContext + nAdded < this.newLineCount) {
            int missingCount = this.newLineCount - (this.nContext + nAdded);
            script.error(buf, this.startOffset, MessageFormat.format(JGitText.get().truncatedHunkNewLinesMissing, missingCount));
        }
        return c;
    }

    @Override
    void extractFileLines(OutputStream[] out) throws IOException {
        byte[] buf = this.file.buf;
        int ptr = this.startOffset;
        int eol = RawParseUtils.nextLF(buf, ptr);
        if (this.endOffset <= eol) {
            return;
        }
        out[0].write(buf, ptr, eol - ptr);
        ptr = eol;
        block8: while (ptr < this.endOffset && (eol = RawParseUtils.nextLF(buf, ptr)) - ptr >= this.old.length + 1) {
            switch (buf[ptr]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block8;
                }
            }
            int delcnt = 0;
            block9: for (int ancestor = 0; ancestor < this.old.length; ++ancestor) {
                switch (buf[ptr + ancestor]) {
                    case 45: {
                        ++delcnt;
                        out[ancestor].write(buf, ptr, eol - ptr);
                        continue block9;
                    }
                    case 32: {
                        out[ancestor].write(buf, ptr, eol - ptr);
                        continue block9;
                    }
                    case 43: {
                        continue block9;
                    }
                    default: {
                        break block8;
                    }
                }
            }
            if (delcnt < this.old.length) {
                out[this.old.length].write(buf, ptr, eol - ptr);
            }
            ptr = eol;
        }
    }

    @Override
    void extractFileLines(StringBuilder sb, String[] text, int[] offsets) {
        byte[] buf = this.file.buf;
        int ptr = this.startOffset;
        int eol = RawParseUtils.nextLF(buf, ptr);
        if (this.endOffset <= eol) {
            return;
        }
        this.copyLine(sb, text, offsets, 0);
        ptr = eol;
        block7: while (ptr < this.endOffset && (eol = RawParseUtils.nextLF(buf, ptr)) - ptr >= this.old.length + 1) {
            switch (buf[ptr]) {
                case 32: 
                case 43: 
                case 45: {
                    break;
                }
                default: {
                    break block7;
                }
            }
            boolean copied = false;
            block8: for (int ancestor = 0; ancestor < this.old.length; ++ancestor) {
                switch (buf[ptr + ancestor]) {
                    case 32: 
                    case 45: {
                        if (copied) {
                            this.skipLine(text, offsets, ancestor);
                            continue block8;
                        }
                        this.copyLine(sb, text, offsets, ancestor);
                        copied = true;
                        continue block8;
                    }
                    case 43: {
                        continue block8;
                    }
                    default: {
                        break block7;
                    }
                }
            }
            if (!copied) {
                this.copyLine(sb, text, offsets, this.old.length);
            }
            ptr = eol;
        }
    }

    private static abstract class CombinedOldImage
    extends HunkHeader.OldImage {
        int nContext;

        private CombinedOldImage() {
        }
    }
}

