/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.transport;

import org.gradle.internal.impldep.org.eclipse.jgit.errors.UnsupportedCredentialItem;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.CredentialItem;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.CredentialsProvider;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.NetRC;
import org.gradle.internal.impldep.org.eclipse.jgit.transport.URIish;

public class NetRCCredentialsProvider
extends CredentialsProvider {
    NetRC netrc = new NetRC();

    public static void install() {
        CredentialsProvider.setDefault(new NetRCCredentialsProvider());
    }

    @Override
    public boolean supports(CredentialItem ... items) {
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username || i instanceof CredentialItem.Password) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean get(URIish uri, CredentialItem ... items) throws UnsupportedCredentialItem {
        NetRC.NetRCEntry cc = this.netrc.getEntry(uri.getHost());
        if (cc == null) {
            return false;
        }
        for (CredentialItem i : items) {
            if (i instanceof CredentialItem.Username) {
                ((CredentialItem.Username)i).setValue(cc.login);
                continue;
            }
            if (i instanceof CredentialItem.Password) {
                ((CredentialItem.Password)i).setValue(cc.password);
                continue;
            }
            if (i instanceof CredentialItem.StringType && i.getPromptText().equals("Password: ")) {
                ((CredentialItem.StringType)i).setValue(new String(cc.password));
                continue;
            }
            throw new UnsupportedCredentialItem(uri, i.getClass().getName() + ":" + i.getPromptText());
        }
        return !NetRCCredentialsProvider.isAnyNull(items);
    }

    @Override
    public boolean isInteractive() {
        return false;
    }
}

