/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter;

import org.gradle.internal.impldep.org.eclipse.jgit.internal.JGitText;
import org.gradle.internal.impldep.org.eclipse.jgit.lib.Constants;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.TreeWalk;
import org.gradle.internal.impldep.org.eclipse.jgit.treewalk.filter.TreeFilter;

public class PathFilter
extends TreeFilter {
    final String pathStr;
    final byte[] pathRaw;

    public static PathFilter create(String path) {
        while (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (path.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().emptyPathNotPermitted);
        }
        return new PathFilter(path);
    }

    private PathFilter(String s) {
        this.pathStr = s;
        this.pathRaw = Constants.encode(this.pathStr);
    }

    public String getPath() {
        return this.pathStr;
    }

    @Override
    public boolean include(TreeWalk walker) {
        return walker.isPathPrefix(this.pathRaw, this.pathRaw.length) == 0;
    }

    @Override
    public boolean shouldBeRecursive() {
        for (byte b : this.pathRaw) {
            if (b != 47) continue;
            return true;
        }
        return false;
    }

    @Override
    public PathFilter clone() {
        return this;
    }

    @Override
    public String toString() {
        return "PATH(\"" + this.pathStr + "\")";
    }

    public boolean isDone(TreeWalk walker) {
        return this.pathRaw.length == walker.getPathLength();
    }
}

