/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.junit.platform.commons.util;

import java.io.File;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.gradle.internal.impldep.org.apiguardian.api.API;
import org.gradle.internal.impldep.org.junit.platform.commons.JUnitException;
import org.gradle.internal.impldep.org.junit.platform.commons.util.BlacklistedExceptions;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ClassLoaderUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ClassUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ClasspathScanner;
import org.gradle.internal.impldep.org.junit.platform.commons.util.CollectionUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.ExceptionUtils;
import org.gradle.internal.impldep.org.junit.platform.commons.util.Preconditions;
import org.gradle.internal.impldep.org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class ReflectionUtils {
    private static final Pattern FULLY_QUALIFIED_METHOD_NAME_PATTERN = Pattern.compile("(.+)#([^()]+?)(\\((.*)\\))?");
    private static final Pattern VM_INTERNAL_OBJECT_ARRAY_PATTERN = Pattern.compile("^(\\[+)L(.+);$");
    private static final Pattern VM_INTERNAL_PRIMITIVE_ARRAY_PATTERN = Pattern.compile("^(\\[+)(\\[[ZBCDFIJS])$");
    private static final Pattern SOURCE_CODE_SYNTAX_ARRAY_PATTERN = Pattern.compile("^([^\\[\\]]+)((\\[\\])+)+$");
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ClasspathScanner classpathScanner = new ClasspathScanner(ClassLoaderUtils::getDefaultClassLoader, ReflectionUtils::loadClass);
    private static final Map<String, Class<?>> classNameToTypeMap;
    private static final Map<Class<?>, Class<?>> primitiveToWrapperMap;

    private ReflectionUtils() {
    }

    public static boolean isPublic(Class<?> clazz) {
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Member member) {
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        return Modifier.isPrivate(member.getModifiers());
    }

    public static boolean isAbstract(Class<?> clazz) {
        return Modifier.isAbstract(clazz.getModifiers());
    }

    public static boolean isAbstract(Member member) {
        return Modifier.isAbstract(member.getModifiers());
    }

    public static boolean isStatic(Class<?> clazz) {
        return Modifier.isStatic(clazz.getModifiers());
    }

    public static boolean isStatic(Member member) {
        return Modifier.isStatic(member.getModifiers());
    }

    public static boolean isInnerClass(Class<?> clazz) {
        return clazz.isMemberClass() && !ReflectionUtils.isStatic(clazz);
    }

    public static boolean returnsVoid(Method method) {
        return method.getReturnType().equals(Void.TYPE);
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    public static boolean isAssignableTo(Object obj, Class<?> type) {
        Preconditions.notNull(type, "type must not be null");
        if (obj == null) {
            return !type.isPrimitive();
        }
        if (type.isInstance(obj)) {
            return true;
        }
        if (type.isPrimitive()) {
            return primitiveToWrapperMap.get(type) == obj.getClass();
        }
        return false;
    }

    public static Class<?> getWrapperType(Class<?> type) {
        return primitiveToWrapperMap.get(type);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(args, "Argument array must not be null");
        Preconditions.containsNoNullElements(args, "Individual arguments must not be null");
        try {
            Class[] parameterTypes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
            return ReflectionUtils.newInstance(clazz.getDeclaredConstructor(parameterTypes), args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        Preconditions.notNull(constructor, "Constructor must not be null");
        try {
            return ReflectionUtils.makeAccessible(constructor).newInstance(args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static <T> Optional<Object> readFieldValue(Class<T> clazz, String fieldName, T instance) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(fieldName, "Field name must not be null or blank");
        try {
            Field field = ReflectionUtils.makeAccessible(clazz.getDeclaredField(fieldName));
            return Optional.ofNullable(field.get(instance));
        }
        catch (Throwable t) {
            BlacklistedExceptions.rethrowIfBlacklisted(t);
            return Optional.empty();
        }
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        Preconditions.notNull(method, "Method must not be null");
        Preconditions.condition(target != null || ReflectionUtils.isStatic(method), () -> String.format("Cannot invoke non-static method [%s] on a null target.", method.toGenericString()));
        try {
            return ReflectionUtils.makeAccessible(method).invoke(target, args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static Optional<Class<?>> loadClass(String name) {
        return ReflectionUtils.loadClass(name, ClassLoaderUtils.getDefaultClassLoader());
    }

    public static Optional<Class<?>> loadClass(String name, ClassLoader classLoader) {
        Preconditions.notBlank(name, "Class name must not be null or blank");
        Preconditions.notNull(classLoader, "ClassLoader must not be null");
        name = name.trim();
        if (classNameToTypeMap.containsKey(name)) {
            return Optional.of(classNameToTypeMap.get(name));
        }
        try {
            Matcher matcher = VM_INTERNAL_PRIMITIVE_ARRAY_PATTERN.matcher(name);
            if (matcher.matches()) {
                String brackets = matcher.group(1);
                String componentTypeName = matcher.group(2);
                int dimensions = brackets.length();
                return ReflectionUtils.loadArrayType(classLoader, componentTypeName, dimensions);
            }
            matcher = VM_INTERNAL_OBJECT_ARRAY_PATTERN.matcher(name);
            if (matcher.matches()) {
                String brackets = matcher.group(1);
                String componentTypeName = matcher.group(2);
                int dimensions = brackets.length();
                return ReflectionUtils.loadArrayType(classLoader, componentTypeName, dimensions);
            }
            matcher = SOURCE_CODE_SYNTAX_ARRAY_PATTERN.matcher(name);
            if (matcher.matches()) {
                String componentTypeName = matcher.group(1);
                String bracketPairs = matcher.group(2);
                int dimensions = bracketPairs.length() / 2;
                return ReflectionUtils.loadArrayType(classLoader, componentTypeName, dimensions);
            }
            return Optional.of(classLoader.loadClass(name));
        }
        catch (ClassNotFoundException ex) {
            return Optional.empty();
        }
    }

    private static Optional<Class<?>> loadArrayType(ClassLoader classLoader, String componentTypeName, int dimensions) throws ClassNotFoundException {
        Class<?> componentType = classNameToTypeMap.containsKey(componentTypeName) ? classNameToTypeMap.get(componentTypeName) : classLoader.loadClass(componentTypeName);
        return Optional.of(Array.newInstance(componentType, new int[dimensions]).getClass());
    }

    public static Optional<Method> loadMethod(String fullyQualifiedMethodName) {
        Preconditions.notBlank(fullyQualifiedMethodName, "Fully qualified method name must not be null or blank");
        String fqmn = fullyQualifiedMethodName.trim();
        Matcher matcher = FULLY_QUALIFIED_METHOD_NAME_PATTERN.matcher(fqmn);
        Preconditions.condition(matcher.matches(), () -> String.format("Fully qualified method name [%s] does not match pattern [%s]", fqmn, FULLY_QUALIFIED_METHOD_NAME_PATTERN));
        String className = matcher.group(1);
        String methodName = matcher.group(2);
        String parameterTypeNames = matcher.group(4);
        Optional<Class<?>> classOptional = ReflectionUtils.loadClass(className);
        if (classOptional.isPresent()) {
            try {
                return ReflectionUtils.findMethod(classOptional.get(), methodName.trim(), parameterTypeNames);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public static String getFullyQualifiedMethodName(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return String.format("%s#%s(%s)", clazz.getName(), methodName, ClassUtils.nullSafeToString(parameterTypes));
    }

    public static Optional<Object> getOutermostInstance(Object inner, Class<?> requiredType) {
        Preconditions.notNull(inner, "inner object must not be null");
        Preconditions.notNull(requiredType, "requiredType must not be null");
        if (requiredType.isInstance(inner)) {
            return Optional.of(inner);
        }
        Optional<Object> candidate = ReflectionUtils.getOuterInstance(inner);
        if (candidate.isPresent()) {
            return ReflectionUtils.getOutermostInstance(candidate.get(), requiredType);
        }
        return Optional.empty();
    }

    private static Optional<Object> getOuterInstance(Object inner) {
        return Arrays.stream(inner.getClass().getDeclaredFields()).filter(field -> field.getName().startsWith("this$")).findFirst().map(field -> {
            try {
                return ReflectionUtils.makeAccessible(field).get(inner);
            }
            catch (Throwable t) {
                throw ExceptionUtils.throwAsUncheckedException(t);
            }
        });
    }

    public static Set<Path> getAllClasspathRootDirectories() {
        String fullClassPath = System.getProperty("java.class.path");
        return Arrays.stream(fullClassPath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classTester, Predicate<String> classNameFilter) {
        return Collections.unmodifiableList(classpathScanner.scanForClassesInClasspathRoot(root, classTester, classNameFilter));
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, Predicate<Class<?>> classTester, Predicate<String> classNameFilter) {
        return Collections.unmodifiableList(classpathScanner.scanForClassesInPackage(basePackageName, classTester, classNameFilter));
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        LinkedHashSet candidates = new LinkedHashSet();
        ReflectionUtils.findNestedClasses(clazz, candidates);
        return candidates.stream().filter(predicate).collect(CollectionUtils.toUnmodifiableList());
    }

    private static void findNestedClasses(Class<?> clazz, Set<Class<?>> candidates) {
        if (clazz == Object.class || clazz == null) {
            return;
        }
        candidates.addAll(Arrays.asList(clazz.getDeclaredClasses()));
        ReflectionUtils.findNestedClasses(clazz.getSuperclass(), candidates);
        for (Class<?> ifc : clazz.getInterfaces()) {
            ReflectionUtils.findNestedClasses(ifc, candidates);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        try {
            Constructor<?>[] constructors = clazz.getDeclaredConstructors();
            Preconditions.condition(constructors.length == 1, () -> String.format("Class [%s] must declare a single constructor", clazz.getName()));
            return constructors[0];
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static boolean isMethodPresent(Class<?> clazz, Predicate<Method> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        return ReflectionUtils.findMethod(clazz, predicate).isPresent();
    }

    static Optional<Method> getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        try {
            return Optional.ofNullable(clazz.getMethod(methodName, parameterTypes));
        }
        catch (NoSuchMethodException ex) {
            return Optional.empty();
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(t);
        }
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, String parameterTypeNames) {
        return ReflectionUtils.findMethod(clazz, methodName, ReflectionUtils.resolveParameterTypes(clazz, methodName, parameterTypeNames));
    }

    private static Class<?>[] resolveParameterTypes(Class<?> clazz, String methodName, String parameterTypeNames) {
        if (StringUtils.isBlank(parameterTypeNames)) {
            return EMPTY_CLASS_ARRAY;
        }
        return (Class[])Arrays.stream(parameterTypeNames.split(",")).map(typeName -> ReflectionUtils.loadRequiredParameterType(clazz, methodName, typeName)).toArray(Class[]::new);
    }

    private static Class<?> loadRequiredParameterType(Class<?> clazz, String methodName, String typeName) {
        return ReflectionUtils.loadClass(typeName).orElseThrow(() -> new JUnitException(String.format("Failed to load parameter type [%s] for method [%s] in class [%s].", typeName, methodName, clazz.getName())));
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypes, "Parameter types array must not be null");
        Preconditions.containsNoNullElements(parameterTypes, "Individual parameter types must not be null");
        return ReflectionUtils.findMethod(clazz, method -> ReflectionUtils.hasCompatibleSignature(method, methodName, parameterTypes));
    }

    private static Optional<Method> findMethod(Class<?> clazz, Predicate<Method> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        for (Class<?> current = clazz; current != null && current != Object.class; current = current.getSuperclass()) {
            List<Method> methods = current.isInterface() ? ReflectionUtils.getMethods(current) : ReflectionUtils.getDeclaredMethods(current, HierarchyTraversalMode.BOTTOM_UP);
            for (Method method : methods) {
                if (!predicate.test(method)) continue;
                return Optional.of(method);
            }
            for (Class<?> ifc : current.getInterfaces()) {
                Optional<Method> optional = ReflectionUtils.findMethod(ifc, predicate);
                if (!optional.isPresent()) continue;
                return optional;
            }
        }
        return Optional.empty();
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate) {
        return ReflectionUtils.findMethods(clazz, predicate, HierarchyTraversalMode.TOP_DOWN);
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findAllMethodsInHierarchy(clazz, traversalMode).stream().filter(predicate).collect(CollectionUtils.toUnmodifiableList());
    }

    private static List<Method> findAllMethodsInHierarchy(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        List localMethods = ReflectionUtils.getDeclaredMethods(clazz, traversalMode).stream().filter(method -> !method.isSynthetic()).collect(Collectors.toList());
        List superclassMethods = ReflectionUtils.getSuperclassMethods(clazz, traversalMode).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
        List interfaceMethods = ReflectionUtils.getInterfaceMethods(clazz, traversalMode).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localMethods)).collect(Collectors.toList());
        ArrayList<Method> methods = new ArrayList<Method>();
        if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
            methods.addAll(superclassMethods);
            methods.addAll(interfaceMethods);
        }
        methods.addAll(localMethods);
        if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            methods.addAll(interfaceMethods);
            methods.addAll(superclassMethods);
        }
        return methods;
    }

    private static List<Method> getMethods(Class<?> clazz) {
        return ReflectionUtils.toSortedMutableList(clazz.getMethods());
    }

    private static List<Method> getDeclaredMethods(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        List<Method> defaultMethods = ReflectionUtils.getDefaultMethods(clazz);
        List<Method> declaredMethods = ReflectionUtils.toSortedMutableList(clazz.getDeclaredMethods());
        if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            declaredMethods.addAll(defaultMethods);
            return declaredMethods;
        }
        defaultMethods.addAll(declaredMethods);
        return defaultMethods;
    }

    private static List<Method> getDefaultMethods(Class<?> clazz) {
        List visibleDefaultMethods = Arrays.stream(clazz.getMethods()).filter(Method::isDefault).collect(Collectors.toCollection(ArrayList::new));
        if (visibleDefaultMethods.isEmpty()) {
            return visibleDefaultMethods;
        }
        return Arrays.stream(clazz.getInterfaces()).map(ReflectionUtils::getMethods).flatMap(Collection::stream).filter(visibleDefaultMethods::contains).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Method> toSortedMutableList(Method[] methods) {
        return Arrays.stream(methods).sorted(ReflectionUtils::defaultMethodSorter).collect(Collectors.toCollection(ArrayList::new));
    }

    private static int defaultMethodSorter(Method method1, Method method2) {
        String name1 = method1.getName();
        String name2 = method2.getName();
        int comparison = Integer.compare(name1.hashCode(), name2.hashCode());
        if (comparison == 0 && (comparison = name1.compareTo(name2)) == 0) {
            comparison = method1.toString().compareTo(method2.toString());
        }
        return comparison;
    }

    private static List<Method> getInterfaceMethods(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        ArrayList<Method> allInterfaceMethods = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            List localInterfaceMethods = ReflectionUtils.getMethods(ifc).stream().filter(m -> !ReflectionUtils.isAbstract(m)).collect(Collectors.toList());
            List superinterfaceMethods = ReflectionUtils.getInterfaceMethods(ifc, traversalMode).stream().filter(method -> !ReflectionUtils.isMethodShadowedByLocalMethods(method, localInterfaceMethods)).collect(Collectors.toList());
            if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
                allInterfaceMethods.addAll(superinterfaceMethods);
            }
            allInterfaceMethods.addAll(localInterfaceMethods);
            if (traversalMode != HierarchyTraversalMode.BOTTOM_UP) continue;
            allInterfaceMethods.addAll(superinterfaceMethods);
        }
        return allInterfaceMethods;
    }

    private static List<Method> getSuperclassMethods(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        Class<?> superclass = clazz.getSuperclass();
        if (superclass == null || superclass == Object.class) {
            return Collections.emptyList();
        }
        return ReflectionUtils.findAllMethodsInHierarchy(superclass, traversalMode);
    }

    private static boolean isMethodShadowedByLocalMethods(Method method, List<Method> localMethods) {
        return localMethods.stream().anyMatch(local -> ReflectionUtils.isMethodShadowedBy(method, local));
    }

    private static boolean isMethodShadowedBy(Method upper, Method lower) {
        return ReflectionUtils.hasCompatibleSignature(upper, lower.getName(), lower.getParameterTypes());
    }

    private static boolean hasCompatibleSignature(Method candidate, String methodName, Class<?>[] parameterTypes) {
        if (!methodName.equals(candidate.getName())) {
            return false;
        }
        if (parameterTypes.length != candidate.getParameterCount()) {
            return false;
        }
        if (Arrays.equals(parameterTypes, candidate.getParameterTypes())) {
            return true;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Class<?> lowerType = parameterTypes[i];
            Class<?> upperType = candidate.getParameterTypes()[i];
            if (upperType.isAssignableFrom(lowerType)) continue;
            return false;
        }
        return ReflectionUtils.isGeneric(candidate);
    }

    static boolean isGeneric(Method method) {
        return ReflectionUtils.isGeneric(method.getGenericReturnType()) || Arrays.stream(method.getGenericParameterTypes()).anyMatch(ReflectionUtils::isGeneric);
    }

    private static boolean isGeneric(Type type) {
        return type instanceof TypeVariable || type instanceof GenericArrayType;
    }

    public static <T extends AccessibleObject> T makeAccessible(T object) {
        if (!object.isAccessible()) {
            object.setAccessible(true);
        }
        return object;
    }

    public static Set<Class<?>> getAllAssignmentCompatibleClasses(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        LinkedHashSet result = new LinkedHashSet();
        ReflectionUtils.getAllAssignmentCompatibleClasses(clazz, result);
        return result;
    }

    private static void getAllAssignmentCompatibleClasses(Class<?> clazz, Set<Class<?>> result) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            result.add(current);
            for (Class<?> interfaceClass : current.getInterfaces()) {
                if (result.contains(interfaceClass)) continue;
                ReflectionUtils.getAllAssignmentCompatibleClasses(interfaceClass, result);
            }
        }
    }

    private static Throwable getUnderlyingCause(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ReflectionUtils.getUnderlyingCause(((InvocationTargetException)t).getTargetException());
        }
        return t;
    }

    static {
        List<Class> commonTypes = Arrays.asList(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, boolean[].class, byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[][].class, byte[][].class, char[][].class, short[][].class, int[][].class, long[][].class, float[][].class, double[][].class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, String.class, Boolean[].class, Byte[].class, Character[].class, Short[].class, Integer[].class, Long[].class, Float[].class, Double[].class, String[].class, Boolean[][].class, Byte[][].class, Character[][].class, Short[][].class, Integer[][].class, Long[][].class, Float[][].class, Double[][].class, String[][].class);
        HashMap classNamesToTypes = new HashMap(64);
        commonTypes.forEach(type -> {
            classNamesToTypes.put(type.getName(), type);
            classNamesToTypes.put(type.getCanonicalName(), type);
        });
        classNameToTypeMap = Collections.unmodifiableMap(classNamesToTypes);
        HashMap<Class<Comparable<Boolean>>, Class> primitivesToWrappers = new HashMap<Class<Comparable<Boolean>>, Class>(8);
        primitivesToWrappers.put(Boolean.TYPE, Boolean.class);
        primitivesToWrappers.put(Byte.TYPE, Byte.class);
        primitivesToWrappers.put(Character.TYPE, Character.class);
        primitivesToWrappers.put(Short.TYPE, Short.class);
        primitivesToWrappers.put(Integer.TYPE, Integer.class);
        primitivesToWrappers.put(Long.TYPE, Long.class);
        primitivesToWrappers.put(Float.TYPE, Float.class);
        primitivesToWrappers.put(Double.TYPE, Double.class);
        primitiveToWrapperMap = Collections.unmodifiableMap(primitivesToWrappers);
    }

    public static enum HierarchyTraversalMode {
        TOP_DOWN,
        BOTTOM_UP;

    }
}

