/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.mozilla.javascript.json;

import java.util.ArrayList;
import org.gradle.internal.impldep.org.mozilla.javascript.Context;
import org.gradle.internal.impldep.org.mozilla.javascript.ScriptRuntime;
import org.gradle.internal.impldep.org.mozilla.javascript.Scriptable;

public class JsonParser {
    private Context cx;
    private Scriptable scope;
    private int pos;
    private int length;
    private String src;

    public JsonParser(Context cx, Scriptable scope) {
        this.cx = cx;
        this.scope = scope;
    }

    public synchronized Object parseValue(String json) throws ParseException {
        if (json == null) {
            throw new ParseException("Input string may not be null");
        }
        this.pos = 0;
        this.length = json.length();
        this.src = json;
        Object value = this.readValue();
        this.consumeWhitespace();
        if (this.pos < this.length) {
            throw new ParseException("Expected end of stream at char " + this.pos);
        }
        return value;
    }

    private Object readValue() throws ParseException {
        this.consumeWhitespace();
        if (this.pos < this.length) {
            char c = this.src.charAt(this.pos++);
            switch (c) {
                case '{': {
                    return this.readObject();
                }
                case '[': {
                    return this.readArray();
                }
                case 't': {
                    return this.readTrue();
                }
                case 'f': {
                    return this.readFalse();
                }
                case '\"': {
                    return this.readString();
                }
                case 'n': {
                    return this.readNull();
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    return this.readNumber(c);
                }
            }
            throw new ParseException("Unexpected token: " + c);
        }
        throw new ParseException("Empty JSON string");
    }

    private Object readObject() throws ParseException {
        Scriptable object = this.cx.newObject(this.scope);
        boolean needsComma = false;
        this.consumeWhitespace();
        while (this.pos < this.length) {
            char c = this.src.charAt(this.pos++);
            switch (c) {
                case '}': {
                    return object;
                }
                case ',': {
                    if (!needsComma) {
                        throw new ParseException("Unexpected comma in object literal");
                    }
                    needsComma = false;
                    break;
                }
                case '\"': {
                    if (needsComma) {
                        throw new ParseException("Missing comma in object literal");
                    }
                    String id = this.readString();
                    this.consume(':');
                    Object value = this.readValue();
                    long index = ScriptRuntime.indexFromString(id);
                    if (index < 0L) {
                        object.put(id, object, value);
                    } else {
                        object.put((int)index, object, value);
                    }
                    needsComma = true;
                    break;
                }
                default: {
                    throw new ParseException("Unexpected token in object literal");
                }
            }
            this.consumeWhitespace();
        }
        throw new ParseException("Unterminated object literal");
    }

    private Object readArray() throws ParseException {
        ArrayList<Object> list = new ArrayList<Object>();
        boolean needsComma = false;
        this.consumeWhitespace();
        while (this.pos < this.length) {
            char c = this.src.charAt(this.pos);
            switch (c) {
                case ']': {
                    ++this.pos;
                    return this.cx.newArray(this.scope, list.toArray());
                }
                case ',': {
                    if (!needsComma) {
                        throw new ParseException("Unexpected comma in array literal");
                    }
                    needsComma = false;
                    ++this.pos;
                    break;
                }
                default: {
                    if (needsComma) {
                        throw new ParseException("Missing comma in array literal");
                    }
                    list.add(this.readValue());
                    needsComma = true;
                }
            }
            this.consumeWhitespace();
        }
        throw new ParseException("Unterminated array literal");
    }

    private String readString() throws ParseException {
        StringBuilder b = new StringBuilder();
        block17: while (this.pos < this.length) {
            char c;
            if ((c = this.src.charAt(this.pos++)) <= '\u001f') {
                throw new ParseException("String contains control character");
            }
            switch (c) {
                case '\\': {
                    if (this.pos >= this.length) {
                        throw new ParseException("Unterminated string");
                    }
                    c = this.src.charAt(this.pos++);
                    switch (c) {
                        case '\"': {
                            b.append('\"');
                            continue block17;
                        }
                        case '\\': {
                            b.append('\\');
                            continue block17;
                        }
                        case '/': {
                            b.append('/');
                            continue block17;
                        }
                        case 'b': {
                            b.append('\b');
                            continue block17;
                        }
                        case 'f': {
                            b.append('\f');
                            continue block17;
                        }
                        case 'n': {
                            b.append('\n');
                            continue block17;
                        }
                        case 'r': {
                            b.append('\r');
                            continue block17;
                        }
                        case 't': {
                            b.append('\t');
                            continue block17;
                        }
                        case 'u': {
                            if (this.length - this.pos < 5) {
                                throw new ParseException("Invalid character code: \\u" + this.src.substring(this.pos));
                            }
                            try {
                                b.append((char)Integer.parseInt(this.src.substring(this.pos, this.pos + 4), 16));
                                this.pos += 4;
                                continue block17;
                            }
                            catch (NumberFormatException nfx) {
                                throw new ParseException("Invalid character code: " + this.src.substring(this.pos, this.pos + 4));
                            }
                        }
                    }
                    throw new ParseException("Unexcpected character in string: '\\" + c + "'");
                }
                case '\"': {
                    return b.toString();
                }
            }
            b.append(c);
        }
        throw new ParseException("Unterminated string literal");
    }

    private Number readNumber(char first) throws ParseException {
        char c;
        StringBuilder b = new StringBuilder();
        b.append(first);
        while (this.pos < this.length && (Character.isDigit(c = this.src.charAt(this.pos)) || c == '-' || c == '+' || c == '.' || c == 'e' || c == 'E')) {
            ++this.pos;
            b.append(c);
        }
        String num = b.toString();
        int numLength = num.length();
        try {
            double dval;
            int ival;
            for (int i = 0; i < numLength; ++i) {
                char c2 = num.charAt(i);
                if (!Character.isDigit(c2)) continue;
                if (c2 != '0' || numLength <= i + 1 || !Character.isDigit(num.charAt(i + 1))) break;
                throw new ParseException("Unsupported number format: " + num);
            }
            if ((double)(ival = (int)(dval = Double.parseDouble(num))) == dval) {
                return ival;
            }
            return dval;
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Unsupported number format: " + num);
        }
    }

    private Boolean readTrue() throws ParseException {
        if (this.length - this.pos < 3 || this.src.charAt(this.pos) != 'r' || this.src.charAt(this.pos + 1) != 'u' || this.src.charAt(this.pos + 2) != 'e') {
            throw new ParseException("Unexpected token: t");
        }
        this.pos += 3;
        return Boolean.TRUE;
    }

    private Boolean readFalse() throws ParseException {
        if (this.length - this.pos < 4 || this.src.charAt(this.pos) != 'a' || this.src.charAt(this.pos + 1) != 'l' || this.src.charAt(this.pos + 2) != 's' || this.src.charAt(this.pos + 3) != 'e') {
            throw new ParseException("Unexpected token: f");
        }
        this.pos += 4;
        return Boolean.FALSE;
    }

    private Object readNull() throws ParseException {
        if (this.length - this.pos < 3 || this.src.charAt(this.pos) != 'u' || this.src.charAt(this.pos + 1) != 'l' || this.src.charAt(this.pos + 2) != 'l') {
            throw new ParseException("Unexpected token: n");
        }
        this.pos += 3;
        return null;
    }

    private void consumeWhitespace() {
        block3: while (this.pos < this.length) {
            char c = this.src.charAt(this.pos);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    ++this.pos;
                    continue block3;
                }
            }
            return;
        }
    }

    private void consume(char token) throws ParseException {
        char c;
        this.consumeWhitespace();
        if (this.pos >= this.length) {
            throw new ParseException("Expected " + token + " but reached end of stream");
        }
        if ((c = this.src.charAt(this.pos++)) == token) {
            return;
        }
        throw new ParseException("Expected " + token + " found " + c);
    }

    public static class ParseException
    extends Exception {
        ParseException(String message) {
            super(message);
        }

        ParseException(Exception cause) {
            super(cause);
        }
    }
}

