/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.simpleframework.http.session;

import java.util.concurrent.TimeUnit;
import org.gradle.internal.impldep.org.simpleframework.http.session.Controller;
import org.gradle.internal.impldep.org.simpleframework.http.session.SessionException;
import org.gradle.internal.impldep.org.simpleframework.util.lease.Lease;
import org.gradle.internal.impldep.org.simpleframework.util.lease.LeaseException;
import org.gradle.internal.impldep.org.simpleframework.util.lease.LeaseManager;
import org.gradle.internal.impldep.org.simpleframework.util.lease.LeaseMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Maintainer<T>
implements Controller<T> {
    private final LeaseManager<T> manager;
    private final LeaseMap<T> map = new LeaseMap();
    private final TimeUnit unit;
    private final long duration;

    public Maintainer(LeaseManager<T> manager, long duration, TimeUnit unit) {
        this.manager = manager;
        this.duration = duration;
        this.unit = unit;
    }

    @Override
    public Lease<T> start(T key) throws LeaseException {
        Lease<T> lease = this.manager.lease(key, this.duration, this.unit);
        if (lease != null) {
            this.map.put(key, lease);
        }
        return lease;
    }

    @Override
    public void renew(T key) throws LeaseException {
        Object lease = this.map.get(key);
        if (lease == null) {
            throw new SessionException("Session does not exist", new Object[0]);
        }
        lease.renew(this.duration, this.unit);
    }

    @Override
    public void cancel(T key) throws LeaseException {
        Object lease = this.map.remove(key);
        if (lease == null) {
            throw new SessionException("Session does not exist", new Object[0]);
        }
    }
}

