/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.sonatype.aether.resolution;

import java.util.Collections;
import java.util.List;
import org.gradle.internal.impldep.org.sonatype.aether.RepositoryException;
import org.gradle.internal.impldep.org.sonatype.aether.resolution.ArtifactResult;
import org.gradle.internal.impldep.org.sonatype.aether.transfer.ArtifactNotFoundException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactResolutionException
extends RepositoryException {
    private final List<ArtifactResult> results;

    public ArtifactResolutionException(List<ArtifactResult> results) {
        super(ArtifactResolutionException.getMessage(results), ArtifactResolutionException.getCause(results));
        this.results = results != null ? results : Collections.emptyList();
    }

    public List<ArtifactResult> getResults() {
        return this.results;
    }

    public ArtifactResult getResult() {
        return !this.results.isEmpty() ? this.results.get(0) : null;
    }

    private static String getMessage(List<? extends ArtifactResult> results) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append("The following artifacts could not be resolved: ");
        int unresolved = 0;
        String sep = "";
        for (ArtifactResult artifactResult : results) {
            if (artifactResult.isResolved()) continue;
            ++unresolved;
            buffer.append(sep);
            buffer.append(artifactResult.getRequest().getArtifact());
            sep = ", ";
        }
        Throwable cause = ArtifactResolutionException.getCause(results);
        if (cause != null) {
            if (unresolved == 1) {
                buffer.setLength(0);
                buffer.append(cause.getMessage());
            } else {
                buffer.append(": ").append(cause.getMessage());
            }
        }
        return buffer.toString();
    }

    private static Throwable getCause(List<? extends ArtifactResult> results) {
        for (ArtifactResult artifactResult : results) {
            if (artifactResult.isResolved()) continue;
            Exception nf = null;
            for (Exception t : artifactResult.getExceptions()) {
                if (t instanceof ArtifactNotFoundException) {
                    if (nf != null) continue;
                    nf = t;
                    continue;
                }
                return t;
            }
            if (nf == null) continue;
            return nf;
        }
        return null;
    }
}

