/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.impldep.org.yaml.snakeyaml.representer;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.gradle.internal.impldep.org.yaml.snakeyaml.error.YAMLException;
import org.gradle.internal.impldep.org.yaml.snakeyaml.introspector.FieldProperty;
import org.gradle.internal.impldep.org.yaml.snakeyaml.introspector.MethodProperty;
import org.gradle.internal.impldep.org.yaml.snakeyaml.introspector.Property;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.MappingNode;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.Node;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.NodeId;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.NodeTuple;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.ScalarNode;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.SequenceNode;
import org.gradle.internal.impldep.org.yaml.snakeyaml.nodes.Tag;
import org.gradle.internal.impldep.org.yaml.snakeyaml.representer.Represent;
import org.gradle.internal.impldep.org.yaml.snakeyaml.representer.SafeRepresenter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Representer
extends SafeRepresenter {
    private boolean allowReadOnlyProperties = true;

    public Representer() {
        this.representers.put(null, new RepresentJavaBean());
    }

    protected MappingNode representJavaBean(Set<Property> properties, Object javaBean) {
        ArrayList<NodeTuple> value = new ArrayList<NodeTuple>(properties.size());
        Tag customTag = (Tag)this.classTags.get(javaBean.getClass());
        Tag tag = customTag != null ? customTag : new Tag(javaBean.getClass());
        MappingNode node = new MappingNode(tag, value, null);
        this.representedObjects.put(this.objectToRepresent, node);
        boolean bestStyle = true;
        for (Property property : properties) {
            Node nodeValue;
            Object memberValue;
            NodeTuple tuple = this.representJavaBeanProperty(javaBean, property, memberValue = property.get(javaBean), customTag);
            if (tuple == null) continue;
            if (((ScalarNode)tuple.getKeyNode()).getStyle() != null) {
                bestStyle = false;
            }
            if (!((nodeValue = tuple.getValueNode()) instanceof ScalarNode) || ((ScalarNode)nodeValue).getStyle() != null) {
                bestStyle = false;
            }
            value.add(tuple);
        }
        if (this.defaultFlowStyle != null) {
            node.setFlowStyle(this.defaultFlowStyle);
        } else {
            node.setFlowStyle(bestStyle);
        }
        return node;
    }

    protected NodeTuple representJavaBeanProperty(Object javaBean, Property property, Object propertyValue, Tag customTag) {
        Node nodeValue;
        ScalarNode nodeKey = (ScalarNode)this.representData(property.getName());
        boolean hasAlias = false;
        if (this.representedObjects.containsKey(propertyValue)) {
            hasAlias = true;
        }
        if ((nodeValue = this.representData(propertyValue)) instanceof MappingNode && !hasAlias) {
            if (!Map.class.isAssignableFrom(propertyValue.getClass()) && customTag == null && property.getType() == propertyValue.getClass()) {
                nodeValue.setTag(Tag.MAP);
            }
        } else if (propertyValue != null && Enum.class.isAssignableFrom(propertyValue.getClass())) {
            nodeValue.setTag(Tag.STR);
        }
        if (nodeValue.getNodeId() != NodeId.scalar && !hasAlias) {
            this.checkGlobalTag(property, nodeValue, propertyValue);
        }
        return new NodeTuple(nodeKey, nodeValue);
    }

    protected void checkGlobalTag(Property property, Node node, Object object) {
        block3: {
            Type[] arguments;
            block5: {
                block4: {
                    arguments = property.getActualTypeArguments();
                    if (arguments == null) break block3;
                    if (node.getNodeId() != NodeId.sequence) break block4;
                    Class t = (Class)arguments[0];
                    SequenceNode snode = (SequenceNode)node;
                    List memberList = (List)object;
                    Iterator iter = memberList.iterator();
                    for (Node childNode : snode.getValue()) {
                        Object member = iter.next();
                        if (!t.equals(member.getClass()) || childNode.getNodeId() != NodeId.mapping) continue;
                        childNode.setTag(Tag.MAP);
                    }
                    break block3;
                }
                if (!(object instanceof Set)) break block5;
                Class t = (Class)arguments[0];
                MappingNode mnode = (MappingNode)node;
                Iterator<NodeTuple> iter = mnode.getValue().iterator();
                Set set = (Set)object;
                for (Object member : set) {
                    NodeTuple tuple = iter.next();
                    if (!t.equals(member.getClass()) || tuple.getKeyNode().getNodeId() != NodeId.mapping) continue;
                    tuple.getKeyNode().setTag(Tag.MAP);
                }
                break block3;
            }
            if (node.getNodeId() != NodeId.mapping) break block3;
            Class keyType = (Class)arguments[0];
            Class valueType = (Class)arguments[1];
            MappingNode mnode = (MappingNode)node;
            for (NodeTuple tuple : mnode.getValue()) {
                this.resetTag(keyType, tuple.getKeyNode());
                this.resetTag(valueType, tuple.getValueNode());
            }
        }
    }

    private void resetTag(Class<? extends Object> type, Node node) {
        Tag tag = node.getTag();
        if (tag.matches(type)) {
            if (Enum.class.isAssignableFrom(type)) {
                node.setTag(Tag.STR);
            } else {
                node.setTag(Tag.MAP);
            }
        }
    }

    protected Set<Property> getProperties(Class<? extends Object> type) throws IntrospectionException {
        TreeSet<Property> properties = new TreeSet<Property>();
        for (PropertyDescriptor property : Introspector.getBeanInfo(type).getPropertyDescriptors()) {
            if (property.getReadMethod() == null || !this.allowReadOnlyProperties && property.getWriteMethod() == null || property.getReadMethod().getName().equals("getClass")) continue;
            properties.add(new MethodProperty(property));
        }
        for (Field field : type.getFields()) {
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers)) continue;
            properties.add(new FieldProperty(field));
        }
        if (properties.isEmpty()) {
            throw new YAMLException("No JavaBean properties found in " + type.getName());
        }
        return properties;
    }

    public void setAllowReadOnlyProperties(boolean allowReadOnlyProperties) {
        this.allowReadOnlyProperties = allowReadOnlyProperties;
    }

    protected class RepresentJavaBean
    implements Represent {
        private final Map<Class<? extends Object>, Set<Property>> propertiesCache = new HashMap<Class<? extends Object>, Set<Property>>();

        protected RepresentJavaBean() {
        }

        public Node representData(Object data) {
            Class<?> clazz = data.getClass();
            Set<Property> properties = this.propertiesCache.get(clazz);
            if (properties == null) {
                try {
                    properties = Representer.this.getProperties(clazz);
                    this.propertiesCache.put(clazz, properties);
                }
                catch (IntrospectionException e) {
                    throw new YAMLException(e);
                }
            }
            MappingNode node = Representer.this.representJavaBean(properties, data);
            return node;
        }
    }
}

