/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInspection.InspectionSuppressor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.PropertiesList;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class PropertiesInspectionSuppressor
implements InspectionSuppressor {
    private static final Logger LOG = Logger.getInstance(PropertiesInspectionSuppressor.class);

    @NotNull
    public SuppressQuickFix[] getSuppressActions(PsiElement element, @NotNull String toolId) {
        return new SuppressQuickFix[]{new SuppressSinglePropertyFix(toolId), new SuppressForFile(toolId)};
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isSuppressedFor(@NotNull PsiElement element, @NotNull String toolId) {
        String text;
        PropertiesFile file;
        Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class, (boolean)false);
        if (property == null) {
            PsiFile containingFile = element.getContainingFile();
            if (!(containingFile instanceof PropertiesFile)) return false;
            file = (PropertiesFile)containingFile;
        } else {
            PsiElement prev = property.getPrevSibling();
            while (prev instanceof PsiWhiteSpace || prev instanceof PsiComment) {
                if (prev instanceof PsiComment && (text = prev.getText()).contains("suppress") && text.contains("\"" + toolId + "\"")) {
                    return true;
                }
                prev = prev.getPrevSibling();
            }
            file = property.getPropertiesFile();
        }
        PsiElement leaf = file.getContainingFile().findElementAt(0);
        while (leaf instanceof PsiWhiteSpace) {
            leaf = leaf.getNextSibling();
        }
        while (leaf instanceof PsiComment) {
            text = leaf.getText();
            if (text.contains("suppress") && text.contains("\"" + toolId + "\"") && text.contains("file")) {
                return true;
            }
            if ((leaf = leaf.getNextSibling()) instanceof PsiWhiteSpace) {
                leaf = leaf.getNextSibling();
            }
            if (!(leaf instanceof PropertiesList) || leaf.getFirstChild() != property || !text.contains("suppress") || !text.contains("\"" + toolId + "\"")) continue;
            return true;
        }
        return false;
    }

    private static class SuppressForFile
    implements SuppressQuickFix {
        private final String shortName;

        private SuppressForFile(String shortName) {
            this.shortName = shortName;
        }

        @NotNull
        public String getFamilyName() {
            return PropertiesBundle.message("unused.property.suppress.for.file", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            PsiFile file = element.getContainingFile();
            Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            LOG.assertTrue(doc != null, (Object)file);
            doc.insertString(0, (CharSequence)("# suppress inspection \"" + this.shortName + "\" for whole file\n"));
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            return context.isValid() && context.getContainingFile() instanceof PropertiesFile;
        }

        public boolean isSuppressAll() {
            return false;
        }
    }

    private static class SuppressSinglePropertyFix
    implements SuppressQuickFix {
        private final String shortName;

        private SuppressSinglePropertyFix(String shortName) {
            this.shortName = shortName;
        }

        @NotNull
        public String getFamilyName() {
            return PropertiesBundle.message("unused.property.suppress.for.property", new Object[0]);
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            PsiElement element = descriptor.getStartElement();
            PsiFile file = element.getContainingFile();
            Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)element, Property.class);
            LOG.assertTrue(property != null);
            int start = property.getTextRange().getStartOffset();
            Document doc = PsiDocumentManager.getInstance((Project)project).getDocument(file);
            LOG.assertTrue(doc != null);
            int line = doc.getLineNumber(start);
            int lineStart = doc.getLineStartOffset(line);
            doc.insertString(lineStart, (CharSequence)("# suppress inspection \"" + this.shortName + "\"\n"));
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiElement context) {
            Property property = (Property)PsiTreeUtil.getParentOfType((PsiElement)context, Property.class);
            return property != null && property.isValid();
        }

        public boolean isSuppressAll() {
            return false;
        }
    }
}

