/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.codeInspection.CleanupLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertiesInspectionBase;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;

public class WrongPropertyKeyValueDelimiterInspection
extends PropertiesInspectionBase
implements CleanupLocalInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (!(holder.getFile() instanceof PropertiesFileImpl)) {
            return PsiElementVisitor.EMPTY_VISITOR;
        }
        PropertiesCodeStyleSettings codeStyleSettings = PropertiesCodeStyleSettings.getInstance(holder.getProject());
        final char codeStyleKeyValueDelimiter = codeStyleSettings.getDelimiter();
        return new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                char delimiter;
                if (element instanceof PropertyImpl && (delimiter = ((PropertyImpl)element).getKeyValueDelimiter()) != codeStyleKeyValueDelimiter) {
                    holder.registerProblem(element, PropertiesBundle.message("wrong.property.key.value.delimiter.inspection.display.name", new Object[0]), new LocalQuickFix[]{new ReplaceKeyValueDelimiterQuickFix(element)});
                }
            }
        };
    }

    private static final class ReplaceKeyValueDelimiterQuickFix
    extends LocalQuickFixOnPsiElement
    implements HighPriorityAction {
        ReplaceKeyValueDelimiterQuickFix(@NotNull PsiElement element) {
            super(element);
        }

        @NotNull
        public String getText() {
            return this.getFamilyName();
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement element, @NotNull PsiElement endElement) {
            ((PropertyImpl)element).replaceKeyValueDelimiterWithDefault();
        }

        @NotNull
        public String getFamilyName() {
            return "Replace property key/value delimiter according code style";
        }
    }
}

