/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class Native2AsciiListenerStartupActivity
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        EncodingManager.getInstance().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("native2ascii".equals(propertyName) || "propertiesFilesEncoding".equals(propertyName)) {
                    DumbService.getInstance((Project)project).smartInvokeLater(() -> ApplicationManager.getApplication().runWriteAction(() -> {
                        Collection filesToRefresh = FileTypeIndex.getFiles((FileType)PropertiesFileType.INSTANCE, (GlobalSearchScope)GlobalSearchScope.allScope((Project)project));
                        VirtualFile[] virtualFiles = VfsUtilCore.toVirtualFileArray((Collection)filesToRefresh);
                        FileDocumentManager.getInstance().saveAllDocuments();
                        for (VirtualFile virtualFile : virtualFiles) {
                            virtualFile.setCharset(null);
                        }
                        FileDocumentManager.getInstance().reloadFiles(virtualFiles);
                    }));
                }
            }
        }, (Disposable)project);
    }
}

