/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.BundleNameEvaluator;
import com.intellij.lang.properties.PropertiesFileProcessor;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.indexing.FileBasedIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesReferenceManager {
    private final PsiManager myPsiManager;
    private final DumbService myDumbService;

    public static PropertiesReferenceManager getInstance(@NotNull Project project) {
        return (PropertiesReferenceManager)ServiceManager.getService((Project)project, PropertiesReferenceManager.class);
    }

    public PropertiesReferenceManager(PsiManager psiManager, DumbService dumbService) {
        this.myPsiManager = psiManager;
        this.myDumbService = dumbService;
    }

    @NotNull
    public List<PropertiesFile> findPropertiesFiles(@NotNull Module module, @NotNull String bundleName) {
        ConcurrentMap map = (ConcurrentMap)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ConcurrentMap factoryMap = ConcurrentFactoryMap.createMap(bundleName1 -> this.findPropertiesFiles(GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module), (String)bundleName1, BundleNameEvaluator.DEFAULT));
            return CachedValueProvider.Result.create((Object)factoryMap, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
        return (List)map.get(bundleName);
    }

    @NotNull
    public List<PropertiesFile> findPropertiesFiles(@NotNull GlobalSearchScope searchScope, @NotNull String bundleName, @NotNull BundleNameEvaluator bundleNameEvaluator) {
        ArrayList<PropertiesFile> result = new ArrayList<PropertiesFile>();
        this.processPropertiesFiles(searchScope, (baseName, propertiesFile) -> {
            if (baseName.equals(bundleName)) {
                result.add(propertiesFile);
            }
            return true;
        }, bundleNameEvaluator);
        return result;
    }

    @Nullable
    public PropertiesFile findPropertiesFile(@NotNull Module module, @NotNull String bundleName, @Nullable Locale locale) {
        List<PropertiesFile> propFiles = this.findPropertiesFiles(module, bundleName);
        if (locale != null) {
            for (PropertiesFile propFile : propFiles) {
                if (!propFile.getLocale().equals(locale)) continue;
                return propFile;
            }
        }
        for (PropertiesFile propFile : propFiles) {
            if (propFile.getLocale().getLanguage().length() != 0 && !propFile.getLocale().equals(Locale.getDefault())) continue;
            return propFile;
        }
        if (!propFiles.isEmpty()) {
            return propFiles.get(0);
        }
        return null;
    }

    public boolean processAllPropertiesFiles(@NotNull PropertiesFileProcessor processor) {
        return this.processPropertiesFiles(GlobalSearchScope.allScope((Project)this.myPsiManager.getProject()), processor, BundleNameEvaluator.DEFAULT);
    }

    public boolean processPropertiesFiles(@NotNull GlobalSearchScope searchScope, @NotNull PropertiesFileProcessor processor, @NotNull BundleNameEvaluator evaluator) {
        for (VirtualFile file : FileTypeIndex.getFiles((FileType)PropertiesFileType.INSTANCE, (GlobalSearchScope)searchScope)) {
            if (this.processFile(file, evaluator, processor)) continue;
            return false;
        }
        if (!this.myDumbService.isDumb()) {
            for (VirtualFile file : FileBasedIndex.getInstance().getContainingFiles(XmlPropertiesIndex.NAME, (Object)XmlPropertiesIndex.MARKER_KEY, searchScope)) {
                if (this.processFile(file, evaluator, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean processFile(@NotNull VirtualFile file, @NotNull BundleNameEvaluator evaluator, @NotNull PropertiesFileProcessor processor) {
        String qName;
        PsiFile psiFile = this.myPsiManager.findFile(file);
        PropertiesFile propertiesFile = PropertiesImplUtil.getPropertiesFile(psiFile);
        return propertiesFile == null || (qName = evaluator.evaluateBundleName(psiFile)) == null || processor.process(qName, propertiesFile);
    }
}

