/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reference.SoftLazyValue;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    private static final Pattern LOCALE_PATTERN = Pattern.compile("(_[a-zA-Z]{2,8}(_[a-zA-Z]{2}|[0-9]{3})?(_[\\w\\-]+)?)\\.[^_]+$");
    public static final Set<Character> BASE_NAME_BORDER_CHAR = ContainerUtil.newHashSet((Object[])new Character[]{Character.valueOf('-'), Character.valueOf('_'), Character.valueOf('.')});
    public static final Locale DEFAULT_LOCALE = new Locale("", "", "");
    private static final SoftLazyValue<Set<String>> LOCALES_LANGUAGE_CODES = new SoftLazyValue<Set<String>>(){

        @NotNull
        protected Set<String> compute() {
            HashSet<String> locales = new HashSet<String>(ContainerUtil.flatten((Iterable)ContainerUtil.map((Object[])Locale.getAvailableLocales(), locale -> {
                ArrayList languages = ContainerUtil.newArrayList((Object[])new String[]{locale.getLanguage()});
                try {
                    languages.add(locale.getISO3Language());
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
                return languages;
            })));
            locales.addAll(ContainerUtil.newArrayList((Object[])Locale.getISOLanguages()));
            return locales;
        }
    };

    public static boolean containsProperty(ResourceBundle resourceBundle, String propertyName) {
        for (PropertiesFile propertiesFile : resourceBundle.getPropertiesFiles()) {
            if (propertiesFile.findPropertyByKey(propertyName) == null) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static String getDefaultBaseName(Collection<? extends PropertiesFile> files) {
        String commonPrefix = null;
        for (PropertiesFile propertiesFile : files) {
            String baseName = propertiesFile.getVirtualFile().getNameWithoutExtension();
            if (commonPrefix == null) {
                commonPrefix = baseName;
                continue;
            }
            if (!(commonPrefix = StringUtil.commonPrefix((String)commonPrefix, (String)baseName)).isEmpty()) continue;
            break;
        }
        assert (commonPrefix != null);
        if (!commonPrefix.isEmpty() && BASE_NAME_BORDER_CHAR.contains(Character.valueOf(commonPrefix.charAt(commonPrefix.length() - 1)))) {
            commonPrefix = commonPrefix.substring(0, commonPrefix.length() - 1);
        }
        return commonPrefix;
    }

    @NotNull
    static String getDefaultBaseName(final @NotNull PsiFile file) {
        return (String)CachedValuesManager.getCachedValue((PsiElement)file, (CachedValueProvider)new CachedValueProvider<String>(){

            @NotNull
            public CachedValueProvider.Result<String> compute() {
                return CachedValueProvider.Result.create((Object)this.computeBaseName(), (Object[])new Object[]{file});
            }

            private String computeBaseName() {
                String name = file.getName();
                if (!StringUtil.containsChar((String)name, (char)'_')) {
                    return FileUtil.getNameWithoutExtension((String)name);
                }
                Matcher matcher = LOCALE_PATTERN.matcher(name);
                int matchIndex = 0;
                while (matcher.find(matchIndex)) {
                    MatchResult matchResult = matcher.toMatchResult();
                    String[] splitted = matchResult.group(1).split("_");
                    if (splitted.length <= 1) continue;
                    String langCode = splitted[1];
                    if (!((Set)LOCALES_LANGUAGE_CODES.getValue()).contains(langCode)) {
                        matchIndex = matchResult.start(1) + 1;
                        continue;
                    }
                    String baseNameWithExtension = name.substring(0, matchResult.start(1)) + name.substring(matchResult.end(1));
                    return FileUtil.getNameWithoutExtension((String)baseNameWithExtension);
                }
                String baseNameWithExtension = name;
                return FileUtil.getNameWithoutExtension((String)baseNameWithExtension);
            }
        });
    }

    @NotNull
    public static Locale getLocale(@NotNull PropertiesFile propertiesFile) {
        String name = propertiesFile.getName();
        if (!StringUtil.containsChar((String)name, (char)'_')) {
            return DEFAULT_LOCALE;
        }
        String containingResourceBundleBaseName = propertiesFile.getResourceBundle().getBaseName();
        if (!name.startsWith(containingResourceBundleBaseName)) {
            return DEFAULT_LOCALE;
        }
        return PropertiesUtil.getLocale(name.substring(containingResourceBundleBaseName.length()));
    }

    @NotNull
    public static Locale getLocale(String suffix) {
        return (Locale)PropertiesUtil.getLocaleAndTrimmedSuffix(suffix).getFirst();
    }

    @NotNull
    public static Pair<Locale, String> getLocaleAndTrimmedSuffix(String suffix) {
        String rawLocale;
        String[] splitRawLocale;
        Matcher matcher = LOCALE_PATTERN.matcher(suffix);
        if (matcher.find() && (splitRawLocale = (rawLocale = matcher.group(1)).split("_")).length > 1 && splitRawLocale[1].length() >= 2) {
            String language = splitRawLocale[1];
            String country = splitRawLocale.length > 2 ? splitRawLocale[2] : "";
            String variant = splitRawLocale.length > 3 ? splitRawLocale[3] : "";
            StringBuilder trimmedSuffix = new StringBuilder(language);
            if (!country.isEmpty()) {
                trimmedSuffix.append("_").append(country);
            }
            if (!variant.isEmpty()) {
                trimmedSuffix.append("_").append(variant);
            }
            return Pair.create((Object)new Locale(language, country, variant), (Object)trimmedSuffix.toString());
        }
        return Pair.create((Object)DEFAULT_LOCALE, (Object)"");
    }

    @Nullable
    public static PropertiesFile getParent(@NotNull PropertiesFile file, @NotNull Collection<? extends PropertiesFile> candidates) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String name = virtualFile.getNameWithoutExtension();
        String[] parts = name.split("_");
        if (parts.length == 1) {
            return null;
        }
        List<String> partsList = Arrays.asList(parts);
        for (int i = parts.length - 1; i >= 1; --i) {
            String parentName = StringUtil.join(partsList.subList(0, i), (String)"_") + "." + virtualFile.getExtension();
            for (PropertiesFile propertiesFile : candidates) {
                if (!parentName.equals(propertiesFile.getName())) continue;
                return propertiesFile;
            }
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static List<IProperty> findAllProperties(Project project, @NotNull ResourceBundle resourceBundle, String key) {
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        return result;
    }

    public static List<IProperty> findAllProperties(@NotNull ResourceBundle resourceBundle, String key) {
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        return result;
    }

    public static boolean isUnescapedBackSlashAtTheEnd(String text) {
        boolean result = false;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            result = !result;
        }
        return result;
    }

    @Nullable
    static String getPackageQualifiedName(@NotNull PsiDirectory directory) {
        return ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex().getPackageNameByDirectory(directory.getVirtualFile());
    }

    @NotNull
    public static String getPresentableLocale(@NotNull Locale locale) {
        ArrayList<String> names = new ArrayList<String>();
        if (!Comparing.strEqual((String)locale.getDisplayLanguage(), null)) {
            names.add(locale.getDisplayLanguage());
        }
        if (!Comparing.strEqual((String)locale.getDisplayCountry(), null)) {
            names.add(locale.getDisplayCountry());
        }
        if (!Comparing.strEqual((String)locale.getDisplayVariant(), null)) {
            names.add(locale.getDisplayVariant());
        }
        return names.isEmpty() ? "" : " (" + StringUtil.join(names, (String)"/") + ")";
    }

    public static boolean hasDefaultLanguage(Locale locale) {
        return ((Set)LOCALES_LANGUAGE_CODES.getValue()).contains(locale.getLanguage());
    }

    @NotNull
    public static String getSuffix(@NotNull PropertiesFile propertiesFile) {
        String propertiesFileName;
        String baseName = propertiesFile.getResourceBundle().getBaseName();
        if (baseName.equals(FileUtil.getNameWithoutExtension((String)(propertiesFileName = propertiesFile.getName())))) {
            return "";
        }
        return FileUtil.getNameWithoutExtension((String)propertiesFileName.substring(baseName.length() + 1));
    }
}

