/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.pom.PomTarget;
import com.intellij.pom.PomTargetPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.FactoryMap;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.graph.CachingSemiGraph;
import com.intellij.util.graph.DFSTBuilder;
import com.intellij.util.graph.Graph;
import com.intellij.util.graph.GraphGenerator;
import com.intellij.util.graph.InboundSemiGraph;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundlePropertiesUpdateManager {
    private static final Logger LOG = Logger.getInstance(ResourceBundlePropertiesUpdateManager.class);
    private final ResourceBundle myResourceBundle;
    private final CodeStyleManager myCodeStyleManager;
    private boolean myOrdered;
    private boolean myAlphaSorted;
    private List<String> myKeysOrder;

    public ResourceBundlePropertiesUpdateManager(ResourceBundle bundle) {
        this.myResourceBundle = bundle;
        this.myCodeStyleManager = CodeStyleManager.getInstance((Project)bundle.getProject());
        this.reload();
    }

    public void insertNewProperty(String key, String value) {
        if (ApplicationManager.getApplication().isUnitTestMode() && this.myKeysOrder != null) {
            LOG.assertTrue(!this.myKeysOrder.contains(key));
        }
        PropertiesFile propertiesFile = this.myResourceBundle.getDefaultPropertiesFile();
        if (this.myAlphaSorted) {
            this.myCodeStyleManager.reformat(propertiesFile.addProperty(key, value).getPsiElement());
        } else {
            this.insertPropertyLast(key, value, propertiesFile);
            if (this.myOrdered) {
                this.myKeysOrder.add(key);
            }
        }
    }

    public void insertAfter(@NotNull String key, @NotNull String value, @NotNull String anchor) {
        if (this.myAlphaSorted || !this.myOrdered) {
            throw new IllegalStateException("Can't insert new properties by anchor while resource bundle is alpha-sorted");
        }
        PropertiesFile file = this.myResourceBundle.getDefaultPropertiesFile();
        IProperty anchorProperty = file.findPropertyByKey(anchor);
        file.addPropertyAfter(key, value, anchorProperty);
        int anchorIndex = this.myKeysOrder.indexOf(anchor);
        this.myKeysOrder.add(anchorIndex + 1, key);
    }

    public void insertOrUpdateTranslation(String key, String value, PropertiesFile propertiesFile) throws IncorrectOperationException {
        IProperty property = propertiesFile.findPropertyByKey(key);
        if (property != null) {
            String oldValue = property.getValue();
            if (!Comparing.equal((String)oldValue, (String)value)) {
                property.setValue(value);
                this.myCodeStyleManager.reformat(property.getPsiElement());
            }
            return;
        }
        if (this.myOrdered) {
            if (this.myAlphaSorted) {
                this.myCodeStyleManager.reformat(propertiesFile.addProperty(key, value).getPsiElement());
                return;
            }
            Pair<IProperty, Integer> propertyAndPosition = this.findExistedPrevSiblingProperty(key, propertiesFile);
            this.myCodeStyleManager.reformat(propertiesFile.addPropertyAfter(key, value, propertyAndPosition == null ? null : (Property)propertyAndPosition.getFirst()).getPsiElement());
        } else {
            this.insertPropertyLast(key, value, propertiesFile);
        }
    }

    public void deletePropertyIfExist(String key, PropertiesFile file) {
        IProperty property = file.findPropertyByKey(key);
        if (property != null && this.myKeysOrder != null) {
            boolean keyExistInOtherPropertiesFiles = false;
            for (PropertiesFile propertiesFile : this.myResourceBundle.getPropertiesFiles()) {
                if (propertiesFile.equals(file) || propertiesFile.findPropertyByKey(key) == null) continue;
                keyExistInOtherPropertiesFiles = true;
                break;
            }
            if (!keyExistInOtherPropertiesFiles) {
                this.myKeysOrder.remove(key);
            }
        }
        if (property != null) {
            PsiElement anElement = property.getPsiElement();
            if (anElement instanceof PomTargetPsiElement) {
                PomTarget xmlProperty = ((PomTargetPsiElement)anElement).getTarget();
                LOG.assertTrue(xmlProperty instanceof XmlProperty);
                anElement = ((XmlProperty)xmlProperty).getNavigationElement();
            }
            anElement.delete();
        }
    }

    private Pair<IProperty, Integer> findExistedPrevSiblingProperty(String key, PropertiesFile file) {
        int prevPosition;
        if (this.myKeysOrder.isEmpty()) {
            return null;
        }
        for (int i = prevPosition = this.myKeysOrder.indexOf(key); i >= 0; --i) {
            String prevKey = this.myKeysOrder.get(i);
            IProperty property = file.findPropertyByKey(prevKey);
            if (property == null) continue;
            return Pair.create((Object)property, (Object)(prevPosition + 1));
        }
        return null;
    }

    private void insertPropertyLast(String key, String value, PropertiesFile propertiesFile) {
        List<IProperty> properties = propertiesFile.getProperties();
        IProperty lastProperty = properties.isEmpty() ? null : properties.get(properties.size() - 1);
        this.myCodeStyleManager.reformat(propertiesFile.addPropertyAfter(key, value, lastProperty).getPsiElement());
    }

    public void reload() {
        Pair<List<String>, Boolean> keysOrder = ResourceBundlePropertiesUpdateManager.keysOrder(this.myResourceBundle);
        boolean bl = this.myOrdered = keysOrder != null;
        if (this.myOrdered) {
            this.myAlphaSorted = (Boolean)keysOrder.getSecond();
            this.myKeysOrder = this.myAlphaSorted ? null : (List)keysOrder.getFirst();
        } else {
            this.myKeysOrder = null;
        }
    }

    @Nullable
    private static Pair<List<String>, Boolean> keysOrder(ResourceBundle resourceBundle) {
        final List propertiesOrders = ContainerUtil.map(resourceBundle.getPropertiesFiles(), PropertiesOrder::new);
        final boolean[] isAlphaSorted = new boolean[]{true};
        Graph generator = GraphGenerator.generate((InboundSemiGraph)CachingSemiGraph.cache((InboundSemiGraph)new InboundSemiGraph<String>(){

            @NotNull
            public Collection<String> getNodes() {
                LinkedHashSet<String> nodes = new LinkedHashSet<String>();
                for (PropertiesOrder order : propertiesOrders) {
                    nodes.addAll(order.myKeys);
                }
                return nodes;
            }

            @NotNull
            public Iterator<String> getIn(String n) {
                LinkedHashSet<String> siblings = new LinkedHashSet<String>();
                for (PropertiesOrder order : propertiesOrders) {
                    for (String nextKey : order.getNext(n)) {
                        if (isAlphaSorted[0] && String.CASE_INSENSITIVE_ORDER.compare(n, nextKey) > 0) {
                            isAlphaSorted[0] = false;
                        }
                        siblings.add(nextKey);
                    }
                }
                return siblings.iterator();
            }
        }));
        DFSTBuilder dfstBuilder = new DFSTBuilder(generator);
        boolean acyclic = dfstBuilder.isAcyclic();
        if (acyclic) {
            if (isAlphaSorted[0]) {
                ArrayList sortedNodes = new ArrayList(generator.getNodes());
                Collections.sort(sortedNodes, String.CASE_INSENSITIVE_ORDER);
                return Pair.create(sortedNodes, (Object)true);
            }
            List dfsNodes = dfstBuilder.getSortedNodes();
            Collections.reverse(dfsNodes);
            return Pair.create((Object)dfsNodes, (Object)false);
        }
        return null;
    }

    public boolean isAlphaSorted() {
        return this.myAlphaSorted;
    }

    public boolean isSorted() {
        return this.myOrdered;
    }

    private static class PropertiesOrder {
        List<String> myKeys;
        Map<String, IntArrayList> myKeyIndices;

        PropertiesOrder(@NotNull PropertiesFile file) {
            List<IProperty> properties = file.getProperties();
            this.myKeys = new ArrayList<String>(properties.size());
            this.myKeyIndices = FactoryMap.createMap(k -> new IntArrayList(1), () -> new THashMap(properties.size()));
            int index = 0;
            for (IProperty property : properties) {
                String key = property.getKey();
                if (key != null) {
                    this.myKeys.add(key);
                    this.myKeyIndices.get(key).add(index);
                }
                ++index;
            }
        }

        @NotNull
        public List<String> getNext(@NotNull String key) {
            List nextProperties = null;
            if (this.myKeyIndices.containsKey(key)) {
                IntArrayList indices = this.myKeyIndices.get(key);
                for (int i = 0; i < indices.size(); ++i) {
                    String nextProperty;
                    int searchIdx = indices.getQuick(i) + 1;
                    if (searchIdx >= this.myKeys.size() || (nextProperty = this.myKeys.get(searchIdx)) == null) continue;
                    if (nextProperties == null) {
                        nextProperties = new SmartList();
                    }
                    nextProperties.add(nextProperty);
                }
            }
            return nextProperties == null ? Collections.emptyList() : nextProperties;
        }
    }
}

