/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.formatting;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.PsiBasedStripTrailingSpacesFilter;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiRecursiveElementVisitor;
import org.jetbrains.annotations.NotNull;

public class PropertiesStripTrailingSpacesFilterFactory
extends PsiBasedStripTrailingSpacesFilter.Factory {
    @NotNull
    protected PsiBasedStripTrailingSpacesFilter createFilter(@NotNull Document document) {
        return new PsiBasedStripTrailingSpacesFilter(document){

            protected void process(@NotNull PsiFile psiFile) {
                new PsiRecursiveElementVisitor(){

                    public void visitElement(PsiElement element) {
                        ASTNode valueNode;
                        if (element instanceof PropertyImpl && (valueNode = ((PropertyImpl)element).getValueNode()) != null) {
                            this.disableRange(valueNode.getTextRange(), true);
                        }
                        super.visitElement(element);
                    }
                }.visitElement((PsiElement)psiFile);
            }
        };
    }

    protected boolean isApplicableTo(@NotNull Language language) {
        return language.is(StdLanguages.PROPERTIES);
    }
}

