/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.psi.codeStyle;

import com.intellij.lang.Language;
import com.intellij.lang.properties.PropertiesLanguage;
import com.intellij.lang.properties.psi.codeStyle.PropertiesCodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsCustomizable;
import com.intellij.psi.codeStyle.LanguageCodeStyleSettingsProvider;
import org.jetbrains.annotations.NotNull;

public class PropertiesLanguageCodeStyleSettingsProvider
extends LanguageCodeStyleSettingsProvider {
    @NotNull
    public Language getLanguage() {
        return PropertiesLanguage.INSTANCE;
    }

    public void customizeSettings(@NotNull CodeStyleSettingsCustomizable consumer, @NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        consumer.showStandardOptions(new String[]{"ALIGN_GROUP_FIELD_DECLARATIONS"});
        consumer.showCustomOption(PropertiesCodeStyleSettings.class, "SPACES_AROUND_KEY_VALUE_DELIMITER", "Insert space around key-value delimiter", null, new Object[0]);
        consumer.showCustomOption(PropertiesCodeStyleSettings.class, "KEY_VALUE_DELIMITER_CODE", "Key-value delimiter", null, new Object[]{new String[]{"=", ":", "whitespace symbol"}, new int[]{0, 1, 2}});
        consumer.showCustomOption(PropertiesCodeStyleSettings.class, "KEEP_BLANK_LINES", "Keep blank lines", null, new Object[0]);
    }

    public String getCodeSample(@NotNull LanguageCodeStyleSettingsProvider.SettingsType settingsType) {
        return "key1=value\nsome_key=some_value\n\n#commentaries\nlast.key=some text here";
    }
}

