/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.references;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class I18nUtil {
    @NotNull
    public static List<PropertiesFile> propertiesFilesByBundleName(@Nullable String resourceBundleName, @NotNull PsiElement context) {
        Project project;
        Module module;
        VirtualFile virtualFile;
        if (resourceBundleName == null) {
            return Collections.emptyList();
        }
        PsiFile containingFile = context.getContainingFile();
        PsiLanguageInjectionHost containingFileContext = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost((PsiElement)containingFile);
        if (containingFileContext != null) {
            containingFile = containingFileContext.getContainingFile();
        }
        if ((virtualFile = containingFile.getVirtualFile()) == null) {
            virtualFile = containingFile.getOriginalFile().getVirtualFile();
        }
        if (virtualFile != null && (module = ProjectRootManager.getInstance((Project)(project = containingFile.getProject())).getFileIndex().getModuleForFile(virtualFile)) != null) {
            PropertiesReferenceManager refManager = PropertiesReferenceManager.getInstance(project);
            return refManager.findPropertiesFiles(module, resourceBundleName);
        }
        return Collections.emptyList();
    }

    public static void createProperty(@NotNull Project project, @NotNull Collection<? extends PropertiesFile> propertiesFiles, @NotNull String key, @NotNull String value) throws IncorrectOperationException {
        I18nUtil.createProperty(project, propertiesFiles, key, value, false);
    }

    public static void createProperty(@NotNull Project project, @NotNull Collection<? extends PropertiesFile> propertiesFiles, @NotNull String key, @NotNull String value, boolean replaceIfExist) throws IncorrectOperationException {
        for (PropertiesFile propertiesFile : propertiesFiles) {
            IProperty existingProperty;
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
            Document document = documentManager.getDocument(propertiesFile.getContainingFile());
            if (document != null) {
                documentManager.commitDocument(document);
            }
            if ((existingProperty = propertiesFile.findPropertyByKey(key)) == null) {
                propertiesFile.addProperty(key, value);
                continue;
            }
            if (!replaceIfExist) continue;
            existingProperty.setValue(value);
        }
    }

    public static List<String> defaultSuggestPropertiesFiles(@NotNull Project project) {
        ArrayList<String> paths = new ArrayList<String>();
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        PropertiesReferenceManager.getInstance(project).processAllPropertiesFiles((baseName, propertiesFile) -> {
            if (propertiesFile instanceof XmlPropertiesFile) {
                return true;
            }
            VirtualFile virtualFile = propertiesFile.getVirtualFile();
            if (projectFileIndex.isInContent(virtualFile)) {
                String path = FileUtil.toSystemDependentName((String)virtualFile.getPath());
                paths.add(path);
            }
            return true;
        });
        return paths;
    }
}

