/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.xml;

import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesImplUtil;
import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesFile;
import com.intellij.lang.properties.xml.XmlPropertiesIndex;
import com.intellij.lang.properties.xml.XmlProperty;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MostlySingularMultiMap;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class XmlPropertiesFileImpl
extends XmlPropertiesFile {
    public static final String ENTRY_TAG_NAME = "entry";
    private static final Key<CachedValue<PropertiesFile>> KEY = Key.create((String)"xml properties file");
    private final XmlFile myFile;
    private List<IProperty> myProperties;
    private MostlySingularMultiMap<String, IProperty> myPropertiesMap;
    private boolean myAlphaSorted;
    private long myFileModificationStamp = -1L;
    private final Object myLock = new Object();

    private void ensurePropertiesLoaded() {
        while (this.myFileModificationStamp != this.myFile.getModificationStamp() || this.myPropertiesMap == null) {
            this.myFileModificationStamp = this.myFile.getModificationStamp();
            MostlySingularMultiMap propertiesMap = new MostlySingularMultiMap();
            XmlTag rootTag = this.myFile.getRootTag();
            ArrayList<IProperty> propertiesOrder = new ArrayList<IProperty>();
            if (rootTag != null) {
                XmlTag[] entries;
                for (XmlTag entry : entries = rootTag.findSubTags(ENTRY_TAG_NAME)) {
                    XmlProperty property = new XmlProperty(entry, this);
                    propertiesOrder.add(property);
                    String key = property.getKey();
                    if (key == null) continue;
                    propertiesMap.add((Object)key, (Object)property);
                }
            }
            this.myAlphaSorted = PropertiesImplUtil.isAlphaSorted(propertiesOrder);
            this.myProperties = propertiesOrder;
            this.myPropertiesMap = propertiesMap;
        }
    }

    private XmlPropertiesFileImpl(XmlFile file) {
        this.myFile = file;
    }

    @Override
    @NotNull
    public PsiFile getContainingFile() {
        return this.myFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<IProperty> getProperties() {
        Object object = this.myLock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            return this.myProperties;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IProperty findPropertyByKey(@NotNull @NonNls String key) {
        Object object = this.myLock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            Iterator properties = this.myPropertiesMap.get((Object)key).iterator();
            return properties.hasNext() ? (IProperty)properties.next() : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public List<IProperty> findPropertiesByKey(@NotNull @NonNls String key) {
        Object object = this.myLock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            return ContainerUtil.collect(this.myPropertiesMap.get((Object)key).iterator());
        }
    }

    @Override
    @NotNull
    public ResourceBundle getResourceBundle() {
        return PropertiesImplUtil.getResourceBundle(this);
    }

    @Override
    @NotNull
    public Locale getLocale() {
        return PropertiesUtil.getLocale(this);
    }

    @Override
    @NotNull
    public PsiElement addProperty(@NotNull IProperty property) throws IncorrectOperationException {
        return this.addProperty(property.getKey(), property.getValue()).getPsiElement().getNavigationElement();
    }

    @Override
    @NotNull
    public PsiElement addPropertyAfter(@NotNull IProperty property, @Nullable IProperty anchor) throws IncorrectOperationException {
        return this.addPropertyAfter(property.getKey(), property.getValue(), anchor).getPsiElement().getNavigationElement();
    }

    @Override
    public IProperty addPropertyAfter(String key, String value, IProperty anchor) {
        return this.addPropertyAfter(key, value, anchor, true);
    }

    @NotNull
    public IProperty addPropertyAfter(String key, String value, @Nullable IProperty anchor, boolean addToEnd) {
        XmlTag anchorTag = anchor == null ? null : (XmlTag)anchor.getPsiElement().getNavigationElement();
        XmlTag rootTag = this.myFile.getRootTag();
        XmlTag entry = this.createPropertyTag(key, value);
        XmlTag addedEntry = (XmlTag)(anchorTag == null ? this.myFile.getRootTag().addSubTag(entry, !addToEnd) : rootTag.addAfter((PsiElement)entry, (PsiElement)anchorTag));
        return new XmlProperty(addedEntry, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public IProperty addProperty(String key, String value) {
        XmlTag entry = this.createPropertyTag(key, value);
        Object object = this.myLock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            if (this.myAlphaSorted) {
                IProperty inserted;
                XmlProperty dummyProperty = new XmlProperty(entry, this);
                int insertIndex = Collections.binarySearch(this.myProperties, dummyProperty, (p1, p2) -> {
                    String k1 = p1.getKey();
                    String k2 = p2.getKey();
                    return k1.compareTo(k2);
                });
                if (insertIndex == -1) {
                    inserted = this.addPropertyAfter(key, value, null, false);
                    this.myProperties.add(0, inserted);
                } else {
                    int position = insertIndex < 0 ? -insertIndex - 2 : insertIndex;
                    IProperty insertPosition = this.myProperties.get(position);
                    inserted = this.addPropertyAfter(key, value, insertPosition, false);
                    this.myProperties.add(position + 1, inserted);
                }
                return inserted;
            }
            return this.addPropertyAfter(key, value, null, true);
        }
    }

    private XmlTag createPropertyTag(String key, String value) {
        XmlTag rootTag = this.myFile.getRootTag();
        XmlTag entry = rootTag.createChildTag(ENTRY_TAG_NAME, "", value, false);
        entry.setAttribute("key", key);
        return entry;
    }

    public static PropertiesFile getPropertiesFile(@NotNull PsiFile file) {
        CachedValuesManager manager = CachedValuesManager.getManager((Project)file.getProject());
        if (file instanceof XmlFile) {
            return (PropertiesFile)manager.getCachedValue((UserDataHolder)file, KEY, () -> {
                XmlPropertiesFileImpl value = XmlPropertiesIndex.isPropertiesFile((XmlFile)file) ? new XmlPropertiesFileImpl((XmlFile)file) : null;
                return CachedValueProvider.Result.create((Object)value, (Object[])new Object[]{file});
            }, false);
        }
        return null;
    }

    @Override
    @NotNull
    public Map<String, String> getNamesMap() {
        THashMap result = new THashMap();
        for (IProperty property : this.getProperties()) {
            result.put(property.getUnescapedKey(), property.getValue());
        }
        return result;
    }

    @Override
    public String getName() {
        return this.getContainingFile().getName();
    }

    @Override
    public VirtualFile getVirtualFile() {
        return this.getContainingFile().getVirtualFile();
    }

    @Override
    public PsiDirectory getParent() {
        return this.getContainingFile().getParent();
    }

    @Override
    public Project getProject() {
        return this.getContainingFile().getProject();
    }

    @Override
    public String getText() {
        return this.getContainingFile().getText();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isAlphaSorted() {
        Object object = this.myLock;
        synchronized (object) {
            this.ensurePropertiesLoaded();
            return this.myAlphaSorted;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlPropertiesFileImpl that = (XmlPropertiesFileImpl)o;
        return this.myFile.equals(that.myFile);
    }

    public int hashCode() {
        return this.myFile.hashCode();
    }

    public String toString() {
        return "XmlPropertiesFileImpl:" + this.getName();
    }
}

