/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.HasConvention;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.plugins.DefaultConvention;
import org.gradle.api.plugins.Convention;
import org.gradle.internal.reflect.JavaReflectionUtil;
import org.gradle.util.GUtil;

public class ConventionAwareHelper
implements ConventionMapping,
HasConvention {
    private final Convention _convention;
    private final IConventionAware _source;
    private final Set<String> _propertyNames;
    private final Map<String, MappedPropertyImpl> _mappings = new HashMap<String, MappedPropertyImpl>();

    public ConventionAwareHelper(IConventionAware source) {
        this(source, new DefaultConvention());
    }

    public ConventionAwareHelper(IConventionAware source, Convention convention) {
        this._source = source;
        this._convention = convention;
        this._propertyNames = JavaReflectionUtil.propertyNames(source);
    }

    private ConventionMapping.MappedProperty map(String propertyName, MappedPropertyImpl mapping) {
        if (!this._propertyNames.contains(propertyName)) {
            throw new InvalidUserDataException("You can't map a property that does not exist: propertyName=" + propertyName);
        }
        this._mappings.put(propertyName, mapping);
        return mapping;
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Closure<?> value) {
        return this.map(propertyName, new MappedPropertyImpl(){

            @Override
            public Object doGetValue(Convention convention, IConventionAware conventionAwareObject) {
                switch (value.getMaximumNumberOfParameters()) {
                    case 0: {
                        return value.call();
                    }
                    case 1: {
                        return value.call((Object)convention);
                    }
                }
                return value.call(new Object[]{convention, conventionAwareObject});
            }
        });
    }

    @Override
    public ConventionMapping.MappedProperty map(String propertyName, final Callable<?> value) {
        return this.map(propertyName, new MappedPropertyImpl(){

            @Override
            public Object doGetValue(Convention convention, IConventionAware conventionAwareObject) {
                return GUtil.uncheckedCall(value);
            }
        });
    }

    public void propertyMissing(String name, Object value) {
        if (!(value instanceof Closure)) {
            throw new MissingPropertyException(name, this.getClass());
        }
        this.map(name, (Closure)value);
    }

    @Override
    public <T> T getConventionValue(T actualValue, String propertyName, boolean isExplicitValue) {
        if (isExplicitValue) {
            return actualValue;
        }
        Object returnValue = actualValue;
        if (this._mappings.containsKey(propertyName)) {
            boolean useMapping = true;
            if (actualValue instanceof Collection && !((Collection)actualValue).isEmpty()) {
                useMapping = false;
            } else if (actualValue instanceof Map && !((Map)actualValue).isEmpty()) {
                useMapping = false;
            }
            if (useMapping) {
                returnValue = this._mappings.get(propertyName).getValue(this._convention, this._source);
            }
        }
        return returnValue;
    }

    @Override
    public Convention getConvention() {
        return this._convention;
    }

    private static abstract class MappedPropertyImpl
    implements ConventionMapping.MappedProperty {
        private boolean haveValue;
        private boolean cache;
        private Object cachedValue;

        private MappedPropertyImpl() {
        }

        public Object getValue(Convention convention, IConventionAware conventionAwareObject) {
            if (!this.cache) {
                return this.doGetValue(convention, conventionAwareObject);
            }
            if (!this.haveValue) {
                this.cachedValue = this.doGetValue(convention, conventionAwareObject);
                this.haveValue = true;
            }
            return this.cachedValue;
        }

        @Override
        public void cache() {
            this.cache = true;
            this.cachedValue = null;
        }

        abstract Object doGetValue(Convention var1, IConventionAware var2);
    }
}

