/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.dsl;

import java.io.File;
import org.gradle.internal.impldep.org.apache.commons.lang.StringUtils;

public class ArtifactFile {
    private String name;
    private String classifier;
    private String extension;

    public ArtifactFile(File file, String version) {
        this(file.getName(), version);
    }

    public ArtifactFile(String fileBaseName, String version) {
        this.name = fileBaseName;
        this.extension = "";
        this.classifier = "";
        boolean done = false;
        int startVersion = StringUtils.lastIndexOf((String)this.name, (String)("-" + version));
        if (startVersion >= 0) {
            int endVersion = startVersion + version.length() + 1;
            if (endVersion == this.name.length()) {
                this.name = this.name.substring(0, startVersion);
                done = true;
            } else if (endVersion < this.name.length() && this.name.charAt(endVersion) == '-') {
                String tail = this.name.substring(endVersion + 1);
                this.name = this.name.substring(0, startVersion);
                this.classifier = StringUtils.substringBeforeLast((String)tail, (String)".");
                this.extension = StringUtils.substringAfterLast((String)tail, (String)".");
                done = true;
            } else if (endVersion < this.name.length() && StringUtils.lastIndexOf((String)this.name, (String)".") == endVersion) {
                this.extension = this.name.substring(endVersion + 1);
                this.name = this.name.substring(0, startVersion);
                done = true;
            }
        }
        if (!done) {
            this.extension = StringUtils.substringAfterLast((String)this.name, (String)".");
            this.name = StringUtils.substringBeforeLast((String)this.name, (String)".");
        }
        if (this.classifier.length() == 0) {
            this.classifier = null;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getExtension() {
        return this.extension;
    }
}

