/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.transform;

import java.io.File;
import java.util.List;
import org.gradle.api.Describable;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.transform.ArtifactTransform;
import org.gradle.api.internal.changedetection.state.isolation.Isolatable;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.util.BiFunction;

class TransformArtifactsAction
implements BiFunction<List<File>, File, File>,
Describable {
    private final Class<? extends ArtifactTransform> implementationClass;
    private final Isolatable<Object[]> parameters;
    private final Instantiator instantiator;

    TransformArtifactsAction(Class<? extends ArtifactTransform> implementationClass, Isolatable<Object[]> parameters, Instantiator instantiator) {
        this.implementationClass = implementationClass;
        this.instantiator = instantiator;
        this.parameters = parameters;
    }

    @Override
    public List<File> apply(File file, File outputDir) {
        ArtifactTransform artifactTransform = this.instantiator.newInstance(this.implementationClass, this.parameters.isolate());
        artifactTransform.setOutputDirectory(outputDir);
        List<File> outputs = artifactTransform.transform(file);
        if (outputs == null) {
            throw new InvalidUserDataException("Transform returned null result.");
        }
        String inputFilePrefix = file.getPath() + File.separator;
        String outputDirPrefix = outputDir.getPath() + File.separator;
        for (File output : outputs) {
            if (!output.exists()) {
                throw new InvalidUserDataException("Transform output file " + output.getPath() + " does not exist.");
            }
            if (output.equals(file) || output.equals(outputDir) || output.getPath().startsWith(outputDirPrefix) || output.getPath().startsWith(inputFilePrefix)) continue;
            throw new InvalidUserDataException("Transform output file " + output.getPath() + " is not a child of the transform's input file or output directory.");
        }
        return outputs;
    }

    public Class<? extends ArtifactTransform> getImplementationClass() {
        return this.implementationClass;
    }

    @Override
    public String getDisplayName() {
        return this.implementationClass.getSimpleName();
    }
}

