/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.collections;

import java.util.Iterator;
import org.gradle.api.internal.collections.AbstractIterationOrderRetainingElementSource;
import org.gradle.api.internal.provider.ProviderInternal;
import org.gradle.api.specs.Spec;
import org.gradle.internal.impldep.com.google.common.base.Objects;
import org.gradle.internal.impldep.com.google.common.collect.Iterators;

public class IterationOrderRetainingSetElementSource<T>
extends AbstractIterationOrderRetainingElementSource<T> {
    private final Spec<AbstractIterationOrderRetainingElementSource.Element<T>> noDuplicates = new Spec<AbstractIterationOrderRetainingElementSource.Element<T>>(){

        @Override
        public boolean isSatisfiedBy(AbstractIterationOrderRetainingElementSource.Element<T> element) {
            return !element.isDuplicate();
        }
    };

    @Override
    public Iterator<T> iterator() {
        this.realizePending();
        return new AbstractIterationOrderRetainingElementSource.RealizedElementCollectionIterator(this.getInserted(), this.noDuplicates);
    }

    @Override
    public Iterator<T> iteratorNoFlush() {
        return new AbstractIterationOrderRetainingElementSource.RealizedElementCollectionIterator(this.getInserted(), this.noDuplicates);
    }

    @Override
    public boolean add(T element) {
        if (!Iterators.contains(this.iteratorNoFlush(), element)) {
            this.getInserted().add(new AbstractIterationOrderRetainingElementSource.CachingElement<T>(element));
            return true;
        }
        return false;
    }

    @Override
    public boolean addRealized(T value) {
        this.markDuplicates(value);
        return true;
    }

    private void markDuplicates(T value) {
        boolean seen = false;
        for (AbstractIterationOrderRetainingElementSource.Element element : this.getInserted()) {
            if (!element.isRealized() || !Objects.equal(element.getValue(), value)) continue;
            if (seen) {
                element.setDuplicate(true);
                continue;
            }
            seen = true;
        }
    }

    @Override
    public boolean addPending(ProviderInternal<? extends T> provider) {
        AbstractIterationOrderRetainingElementSource.Element<? extends T> element = this.cachingElement(provider);
        if (!this.getInserted().contains(element)) {
            this.getInserted().add(element);
            return true;
        }
        return false;
    }
}

