/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file;

import groovy.lang.Closure;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.gradle.api.Action;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.file.FileVisitor;
import org.gradle.api.internal.file.AbstractFileCollection;
import org.gradle.api.internal.file.AntFileTreeBuilder;
import org.gradle.api.internal.file.FileCollectionVisitor;
import org.gradle.api.internal.file.FileSystemSubset;
import org.gradle.api.internal.file.FileTreeInternal;
import org.gradle.api.internal.file.UnionFileTree;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskDependency;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.api.tasks.util.internal.PatternSets;
import org.gradle.internal.Cast;
import org.gradle.internal.Factory;
import org.gradle.internal.MutableBoolean;
import org.gradle.util.ConfigureUtil;

public abstract class AbstractFileTree
extends AbstractFileCollection
implements FileTreeInternal {
    protected final Factory<PatternSet> patternSetFactory;

    public AbstractFileTree() {
        this(PatternSets.getNonCachingPatternSetFactory());
    }

    public AbstractFileTree(Factory<PatternSet> patternSetFactory) {
        this.patternSetFactory = patternSetFactory;
    }

    @Override
    public Set<File> getFiles() {
        final LinkedHashSet<File> files = new LinkedHashSet<File>();
        this.visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                files.add(fileDetails.getFile());
            }
        });
        return files;
    }

    @Override
    public boolean isEmpty() {
        final MutableBoolean found = new MutableBoolean();
        this.visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                found.set(true);
                fileDetails.stopVisiting();
            }
        });
        return !found.get();
    }

    @Override
    public FileTree matching(Closure filterConfigClosure) {
        return this.matching(ConfigureUtil.configure(filterConfigClosure, this.patternSetFactory.create()));
    }

    @Override
    public FileTree matching(Action<? super PatternFilterable> filterConfigAction) {
        PatternSet patternSet = this.patternSetFactory.create();
        filterConfigAction.execute(patternSet);
        return this.matching(patternSet);
    }

    @Override
    public FileTree matching(PatternFilterable patterns) {
        PatternSet patternSet = (PatternSet)patterns;
        return new FilteredFileTreeImpl(this, patternSet.getAsSpec());
    }

    public Map<String, File> getAsMap() {
        final LinkedHashMap<String, File> map = new LinkedHashMap<String, File>();
        this.visit(new EmptyFileVisitor(){

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                map.put(fileDetails.getRelativePath().getPathString(), fileDetails.getFile());
            }
        });
        return map;
    }

    @Override
    protected void addAsResourceCollection(Object builder, String nodeName) {
        new AntFileTreeBuilder(this.getAsMap()).addToAntBuilder(builder, nodeName);
    }

    protected boolean visitAll() {
        final MutableBoolean hasContent = new MutableBoolean();
        this.visit(new FileVisitor(){

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
                dirDetails.getFile();
                hasContent.set(true);
            }

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                fileDetails.getFile();
                hasContent.set(true);
            }
        });
        return hasContent.get();
    }

    @Override
    public FileTree getAsFileTree() {
        return this;
    }

    @Override
    public FileTree plus(FileTree fileTree) {
        return new UnionFileTree(this, Cast.cast(FileTreeInternal.class, fileTree));
    }

    @Override
    public FileTree visit(Closure closure) {
        return this.visit(AbstractFileTree.fileVisitorFrom(closure));
    }

    static FileVisitor fileVisitorFrom(Closure closure) {
        return (FileVisitor)DefaultGroovyMethods.asType((Closure)closure, FileVisitor.class);
    }

    @Override
    public FileTree visit(final Action<? super FileVisitDetails> visitor) {
        return this.visit(new FileVisitor(){

            @Override
            public void visitDir(FileVisitDetails dirDetails) {
                visitor.execute(dirDetails);
            }

            @Override
            public void visitFile(FileVisitDetails fileDetails) {
                visitor.execute(fileDetails);
            }
        });
    }

    @Override
    public void visitTreeOrBackingFile(FileVisitor visitor) {
        this.visit(visitor);
    }

    @Override
    public void visitRootElements(FileCollectionVisitor visitor) {
        visitor.visitTree(this);
    }

    private static class FilteredFileTreeImpl
    extends AbstractFileTree {
        private final AbstractFileTree fileTree;
        private final Spec<FileTreeElement> spec;

        public FilteredFileTreeImpl(AbstractFileTree fileTree, Spec<FileTreeElement> spec) {
            this.fileTree = fileTree;
            this.spec = spec;
        }

        @Override
        public String getDisplayName() {
            return this.fileTree.getDisplayName();
        }

        @Override
        public TaskDependency getBuildDependencies() {
            return this.fileTree.getBuildDependencies();
        }

        @Override
        public FileTree visit(final FileVisitor visitor) {
            this.fileTree.visit(new FileVisitor(){

                @Override
                public void visitDir(FileVisitDetails dirDetails) {
                    if (FilteredFileTreeImpl.this.spec.isSatisfiedBy(dirDetails)) {
                        visitor.visitDir(dirDetails);
                    }
                }

                @Override
                public void visitFile(FileVisitDetails fileDetails) {
                    if (FilteredFileTreeImpl.this.spec.isSatisfiedBy(fileDetails)) {
                        visitor.visitFile(fileDetails);
                    }
                }
            });
            return this;
        }

        @Override
        public void registerWatchPoints(FileSystemSubset.Builder builder) {
            this.fileTree.registerWatchPoints(builder);
        }

        @Override
        public void visitTreeOrBackingFile(FileVisitor visitor) {
            this.fileTree.visitTreeOrBackingFile(visitor);
        }
    }
}

