/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import groovy.lang.Closure;
import groovy.lang.MissingPropertyException;
import groovy.lang.Script;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.AntBuilder;
import org.gradle.api.CircularReferenceException;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.PathValidation;
import org.gradle.api.Project;
import org.gradle.api.ProjectConfigurationException;
import org.gradle.api.ProjectEvaluationListener;
import org.gradle.api.Task;
import org.gradle.api.UnknownProjectException;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.dsl.ArtifactHandler;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.dsl.DependencyLockingHandler;
import org.gradle.api.artifacts.dsl.RepositoryHandler;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.ConfigurableFileTree;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.DeleteSpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.ClosureBackedAction;
import org.gradle.api.internal.DynamicObjectAware;
import org.gradle.api.internal.DynamicPropertyNamer;
import org.gradle.api.internal.ExtensibleDynamicObject;
import org.gradle.api.internal.FactoryNamedDomainObjectContainer;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.NoConventionMapping;
import org.gradle.api.internal.ProcessOperations;
import org.gradle.api.internal.artifacts.Module;
import org.gradle.api.internal.artifacts.configurations.DependencyMetaDataProvider;
import org.gradle.api.internal.file.DefaultProjectLayout;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.api.internal.file.SourceDirectorySetFactory;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.plugins.DefaultObjectConfigurationAction;
import org.gradle.api.internal.plugins.ExtensionContainerInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.AbstractPluginAware;
import org.gradle.api.internal.project.CrossProjectConfigurator;
import org.gradle.api.internal.project.DeferredProjectConfiguration;
import org.gradle.api.internal.project.ProjectIdentifier;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.project.ProjectStateInternal;
import org.gradle.api.internal.project.taskfactory.ITaskFactory;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.plugins.Convention;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.api.provider.PropertyState;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.WorkResult;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.internal.ListenerBuildOperationDecorator;
import org.gradle.configuration.project.ProjectConfigurationActionContainer;
import org.gradle.configuration.project.ProjectEvaluator;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.internal.Actions;
import org.gradle.internal.Factories;
import org.gradle.internal.Factory;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.internal.impldep.com.google.common.base.Strings;
import org.gradle.internal.impldep.com.google.common.collect.Maps;
import org.gradle.internal.impldep.com.google.common.primitives.Ints;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.logging.StandardOutputCapture;
import org.gradle.internal.metaobject.BeanDynamicObject;
import org.gradle.internal.metaobject.DynamicObject;
import org.gradle.internal.model.RuleBasedPluginListener;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextResourceLoader;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.typeconversion.TypeConverter;
import org.gradle.listener.ClosureBackedMethodInvocationDispatch;
import org.gradle.model.Model;
import org.gradle.model.RuleSource;
import org.gradle.model.dsl.internal.NonTransformedModelDslBacking;
import org.gradle.model.dsl.internal.TransformedModelDslBacking;
import org.gradle.model.internal.core.DefaultNodeInitializerRegistry;
import org.gradle.model.internal.core.Hidden;
import org.gradle.model.internal.core.ModelReference;
import org.gradle.model.internal.core.ModelRegistrations;
import org.gradle.model.internal.core.NodeInitializerRegistry;
import org.gradle.model.internal.manage.binding.StructBindingsStore;
import org.gradle.model.internal.manage.instance.ManagedProxyFactory;
import org.gradle.model.internal.manage.schema.ModelSchemaStore;
import org.gradle.model.internal.registry.ModelRegistry;
import org.gradle.model.internal.type.ModelType;
import org.gradle.normalization.InputNormalizationHandler;
import org.gradle.process.ExecResult;
import org.gradle.process.ExecSpec;
import org.gradle.process.JavaExecSpec;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GUtil;
import org.gradle.util.Path;

@NoConventionMapping
public class DefaultProject
extends AbstractPluginAware
implements ProjectInternal,
DynamicObjectAware,
FileOperations,
ProcessOperations {
    private static final ModelType<ServiceRegistry> SERVICE_REGISTRY_MODEL_TYPE = ModelType.of(ServiceRegistry.class);
    private static final ModelType<File> FILE_MODEL_TYPE = ModelType.of(File.class);
    private static final ModelType<ProjectIdentifier> PROJECT_IDENTIFIER_MODEL_TYPE = ModelType.of(ProjectIdentifier.class);
    private static final ModelType<ExtensionContainer> EXTENSION_CONTAINER_MODEL_TYPE = ModelType.of(ExtensionContainer.class);
    private static final Logger BUILD_LOGGER = Logging.getLogger(Project.class);
    private final ClassLoaderScope classLoaderScope;
    private final ClassLoaderScope baseClassLoaderScope;
    private ServiceRegistry services;
    private final ProjectInternal rootProject;
    private final GradleInternal gradle;
    private ProjectEvaluator projectEvaluator;
    private ScriptSource buildScriptSource;
    private final File projectDir;
    private final File buildFile;
    private final ProjectInternal parent;
    private final String name;
    private Object group;
    private Object version;
    private Object status;
    private final Map<String, Project> childProjects = Maps.newTreeMap();
    private List<String> defaultTasks = new ArrayList<String>();
    private ProjectStateInternal state;
    private FileResolver fileResolver;
    private Factory<AntBuilder> antBuilderFactory;
    private AntBuilder ant;
    private final int depth;
    private TaskContainerInternal taskContainer;
    private DependencyHandler dependencyHandler;
    private ConfigurationContainer configurationContainer;
    private ArtifactHandler artifactHandler;
    private ListenerBroadcast<ProjectEvaluationListener> evaluationListener = this.newProjectEvaluationListenerBroadcast();
    private final ListenerBroadcast<RuleBasedPluginListener> ruleBasedPluginListenerBroadcast = new ListenerBroadcast<RuleBasedPluginListener>(RuleBasedPluginListener.class);
    private ExtensibleDynamicObject extensibleDynamicObject;
    private String description;
    private final Path path;
    private Path identityPath;
    private boolean preparedForRuleBasedPlugins;

    public DefaultProject(String name, @Nullable ProjectInternal parent, File projectDir, File buildFile, ScriptSource buildScriptSource, GradleInternal gradle, ServiceRegistryFactory serviceRegistryFactory, ClassLoaderScope selfClassLoaderScope, ClassLoaderScope baseClassLoaderScope) {
        this.classLoaderScope = selfClassLoaderScope;
        this.baseClassLoaderScope = baseClassLoaderScope;
        this.rootProject = parent != null ? parent.getRootProject() : this;
        this.projectDir = projectDir;
        this.buildFile = buildFile;
        this.parent = parent;
        this.name = name;
        this.state = new ProjectStateInternal();
        this.buildScriptSource = buildScriptSource;
        this.gradle = gradle;
        if (parent == null) {
            this.path = Path.ROOT;
            this.depth = 0;
        } else {
            this.path = parent.getProjectPath().child(name);
            this.depth = parent.getDepth() + 1;
        }
        this.services = serviceRegistryFactory.createFor(this);
        this.taskContainer = this.services.newInstance(TaskContainerInternal.class);
        this.extensibleDynamicObject = new ExtensibleDynamicObject((Object)this, Project.class, this.services.get(Instantiator.class));
        if (parent != null) {
            this.extensibleDynamicObject.setParent(parent.getInheritedScope());
        }
        this.extensibleDynamicObject.addObject(this.taskContainer.getTasksAsDynamicObject(), ExtensibleDynamicObject.Location.AfterConvention);
        this.evaluationListener.add(gradle.getProjectEvaluationBroadcaster());
        this.ruleBasedPluginListenerBroadcast.add(new RuleBasedPluginListener(){

            @Override
            public void prepareForRuleBasedPlugins(Project project) {
                DefaultProject.this.populateModelRegistry(DefaultProject.this.services.get(ModelRegistry.class));
            }
        });
    }

    private ListenerBroadcast<ProjectEvaluationListener> newProjectEvaluationListenerBroadcast() {
        return new ListenerBroadcast<ProjectEvaluationListener>(ProjectEvaluationListener.class);
    }

    private void populateModelRegistry(ModelRegistry modelRegistry) {
        this.registerServiceOn(modelRegistry, "serviceRegistry", SERVICE_REGISTRY_MODEL_TYPE, this.services, this.instanceDescriptorFor("serviceRegistry"));
        this.registerFactoryOn(modelRegistry, "buildDir", FILE_MODEL_TYPE, new Factory<File>(){

            @Override
            public File create() {
                return DefaultProject.this.getBuildDir();
            }
        });
        this.registerInstanceOn(modelRegistry, "projectIdentifier", PROJECT_IDENTIFIER_MODEL_TYPE, this);
        this.registerInstanceOn(modelRegistry, "extensionContainer", EXTENSION_CONTAINER_MODEL_TYPE, this.getExtensions());
        modelRegistry.getRoot().applyToSelf(BasicServicesRules.class);
    }

    private <T> void registerInstanceOn(ModelRegistry modelRegistry, String path, ModelType<T> type, T instance) {
        this.registerFactoryOn(modelRegistry, path, type, Factories.constant(instance));
    }

    private <T> void registerFactoryOn(ModelRegistry modelRegistry, String path, ModelType<T> type, Factory<T> factory) {
        modelRegistry.register(ModelRegistrations.unmanagedInstance(ModelReference.of(path, type), factory).descriptor(this.instanceDescriptorFor(path)).hidden(true).build());
    }

    private <T> void registerServiceOn(ModelRegistry modelRegistry, String path, ModelType<T> type, T instance, String descriptor) {
        modelRegistry.register(ModelRegistrations.serviceInstance(ModelReference.of(path, type), instance).descriptor(descriptor).build());
    }

    private String instanceDescriptorFor(String path) {
        return "Project.<init>." + path + "()";
    }

    @Override
    public ProjectInternal getRootProject() {
        return this.rootProject;
    }

    @Override
    public GradleInternal getGradle() {
        return this.gradle;
    }

    public ProjectEvaluator getProjectEvaluator() {
        if (this.projectEvaluator == null) {
            this.projectEvaluator = this.services.get(ProjectEvaluator.class);
        }
        return this.projectEvaluator;
    }

    public void setProjectEvaluator(ProjectEvaluator projectEvaluator) {
        this.projectEvaluator = projectEvaluator;
    }

    @Override
    @Inject
    public ScriptHandler getBuildscript() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File getBuildFile() {
        return this.buildFile;
    }

    @Override
    public void setScript(Script buildScript) {
        this.extensibleDynamicObject.addObject(new BeanDynamicObject(buildScript).withNoProperties().withNotImplementsMissing(), ExtensibleDynamicObject.Location.BeforeConvention);
    }

    @Override
    public ScriptSource getBuildScriptSource() {
        return this.buildScriptSource;
    }

    @Override
    public File getRootDir() {
        return this.rootProject.getProjectDir();
    }

    @Override
    public ProjectInternal getParent() {
        return this.parent;
    }

    @Override
    public ProjectIdentifier getParentIdentifier() {
        return this.parent;
    }

    @Override
    public DynamicObject getAsDynamicObject() {
        return this.extensibleDynamicObject;
    }

    @Override
    public DynamicObject getInheritedScope() {
        return this.extensibleDynamicObject.getInheritable();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public Object getGroup() {
        if (this.group != null) {
            return this.group;
        }
        if (this == this.rootProject) {
            return "";
        }
        this.group = this.rootProject.getName() + (this.getParent() == this.rootProject ? "" : "." + this.getParent().getPath().substring(1).replace(':', '.'));
        return this.group;
    }

    @Override
    public void setGroup(Object group) {
        this.group = group;
    }

    @Override
    public Object getVersion() {
        return this.version == null ? "unspecified" : this.version;
    }

    @Override
    public void setVersion(Object version) {
        this.version = version;
    }

    @Override
    public Object getStatus() {
        return this.status == null ? "release" : this.status;
    }

    @Override
    public void setStatus(Object status) {
        this.status = status;
    }

    @Override
    public Map<String, Project> getChildProjects() {
        return this.childProjects;
    }

    @Override
    public List<String> getDefaultTasks() {
        return this.defaultTasks;
    }

    @Override
    public void setDefaultTasks(List<String> defaultTasks) {
        this.defaultTasks = defaultTasks;
    }

    @Override
    public ProjectStateInternal getState() {
        return this.state;
    }

    @Override
    public FileResolver getFileResolver() {
        if (this.fileResolver == null) {
            this.fileResolver = this.services.get(FileResolver.class);
        }
        return this.fileResolver;
    }

    public void setFileResolver(FileResolver fileResolver) {
        this.fileResolver = fileResolver;
    }

    public void setAnt(AntBuilder ant) {
        this.ant = ant;
    }

    @Override
    public ArtifactHandler getArtifacts() {
        if (this.artifactHandler == null) {
            this.artifactHandler = this.services.get(ArtifactHandler.class);
        }
        return this.artifactHandler;
    }

    public void setArtifactHandler(ArtifactHandler artifactHandler) {
        this.artifactHandler = artifactHandler;
    }

    @Override
    @Inject
    public RepositoryHandler getRepositories() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ConfigurationContainer getConfigurations() {
        if (this.configurationContainer == null) {
            this.configurationContainer = this.services.get(ConfigurationContainer.class);
        }
        return this.configurationContainer;
    }

    public void setConfigurationContainer(ConfigurationContainer configurationContainer) {
        this.configurationContainer = configurationContainer;
    }

    @Override
    public Convention getConvention() {
        return this.extensibleDynamicObject.getConvention();
    }

    @Override
    public String getPath() {
        return this.path.toString();
    }

    @Override
    public Path getIdentityPath() {
        if (this.identityPath == null) {
            this.identityPath = this.parent == null ? this.gradle.getIdentityPath() : this.parent.getIdentityPath().child(this.name);
        }
        return this.identityPath;
    }

    @Override
    public int getDepth() {
        return this.depth;
    }

    @Override
    @Inject
    public ProjectRegistry<ProjectInternal> getProjectRegistry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int depthCompare(Project otherProject) {
        return Ints.compare((int)this.getDepth(), (int)otherProject.getDepth());
    }

    @Override
    public int compareTo(Project otherProject) {
        int depthCompare = this.depthCompare(otherProject);
        if (depthCompare == 0) {
            return this.getProjectPath().compareTo(((ProjectInternal)otherProject).getProjectPath());
        }
        return depthCompare;
    }

    @Override
    public String absoluteProjectPath(String path) {
        return this.path.absolutePath(path);
    }

    @Override
    public Path identityPath(String name) {
        return this.getIdentityPath().child(name);
    }

    @Override
    public Path getProjectPath() {
        return this.path;
    }

    @Override
    public Path getBuildPath() {
        return this.gradle.getIdentityPath();
    }

    @Override
    public Path projectPath(String name) {
        return this.path.child(name);
    }

    @Override
    public boolean isScript() {
        return false;
    }

    @Override
    public String relativeProjectPath(String path) {
        return this.path.relativePath(path);
    }

    @Override
    public ProjectInternal project(String path) {
        ProjectInternal project = this.findProject(path);
        if (project == null) {
            throw new UnknownProjectException(String.format("Project with path '%s' could not be found in %s.", path, this));
        }
        return project;
    }

    @Override
    public ProjectInternal findProject(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("A path must be specified!");
        }
        return this.getProjectRegistry().getProject(this.absoluteProjectPath(path));
    }

    @Override
    public Set<Project> getAllprojects() {
        return new TreeSet<Project>(this.getProjectRegistry().getAllProjects(this.getPath()));
    }

    @Override
    public Set<Project> getSubprojects() {
        return new TreeSet<Project>(this.getProjectRegistry().getSubProjects(this.getPath()));
    }

    @Override
    public void subprojects(Action<? super Project> action) {
        this.getProjectConfigurator().subprojects(this.getSubprojects(), action);
    }

    @Override
    public void allprojects(Action<? super Project> action) {
        this.getProjectConfigurator().allprojects(this.getAllprojects(), action);
    }

    @Override
    public <T> Iterable<T> configure(Iterable<T> objects, Action<? super T> configureAction) {
        for (T object : objects) {
            configureAction.execute(object);
        }
        return objects;
    }

    @Override
    public AntBuilder getAnt() {
        if (this.ant == null) {
            this.ant = this.createAntBuilder();
        }
        return this.ant;
    }

    @Override
    public AntBuilder createAntBuilder() {
        return this.getAntBuilderFactory().create();
    }

    @Override
    public Project getProject() {
        return this;
    }

    @Override
    public DefaultProject evaluate() {
        this.getProjectEvaluator().evaluate(this, this.state);
        return this;
    }

    @Override
    public ProjectInternal bindAllModelRules() {
        try {
            this.getModelRegistry().bindAllReferences();
        }
        catch (Exception e) {
            throw new ProjectConfigurationException(String.format("A problem occurred configuring %s.", this), e);
        }
        return this;
    }

    @Override
    public TaskContainerInternal getTasks() {
        return this.taskContainer;
    }

    @Override
    public void defaultTasks(String ... defaultTasks) {
        if (defaultTasks == null) {
            throw new InvalidUserDataException("Default tasks must not be null!");
        }
        this.defaultTasks = new ArrayList<String>();
        for (String defaultTask : defaultTasks) {
            if (defaultTask == null) {
                throw new InvalidUserDataException("Default tasks must not be null!");
            }
            this.defaultTasks.add(defaultTask);
        }
    }

    @Override
    public void addChildProject(ProjectInternal childProject) {
        this.childProjects.put(childProject.getName(), childProject);
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    @Override
    public File getBuildDir() {
        return this.getLayout().getBuildDirectory().getAsFile().get();
    }

    @Override
    public void setBuildDir(File path) {
        this.setBuildDir((Object)path);
    }

    @Override
    public void setBuildDir(Object path) {
        this.getLayout().setBuildDirectory(path);
    }

    @Override
    public void evaluationDependsOnChildren() {
        for (Project project : this.childProjects.values()) {
            DefaultProject defaultProjectToEvaluate = (DefaultProject)project;
            this.evaluationDependsOn(defaultProjectToEvaluate);
        }
    }

    @Override
    public Project evaluationDependsOn(String path) {
        if (Strings.isNullOrEmpty((String)path)) {
            throw new InvalidUserDataException("You must specify a project!");
        }
        DefaultProject projectToEvaluate = (DefaultProject)this.project(path);
        return this.evaluationDependsOn(projectToEvaluate);
    }

    private Project evaluationDependsOn(DefaultProject projectToEvaluate) {
        if (projectToEvaluate.getState().isConfiguring()) {
            throw new CircularReferenceException(String.format("Circular referencing during evaluation for %s.", projectToEvaluate));
        }
        return projectToEvaluate.evaluate();
    }

    @Override
    public String getDisplayName() {
        StringBuilder builder = new StringBuilder();
        if (this.parent == null && this.gradle.getParent() == null) {
            builder.append("root project '");
            builder.append(this.name);
            builder.append('\'');
        } else {
            builder.append("project '");
            builder.append(this.getIdentityPath());
            builder.append("'");
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    @Override
    public Map<Project, Set<Task>> getAllTasks(boolean recursive) {
        final TreeMap<Project, Set<Task>> foundTargets = new TreeMap<Project, Set<Task>>();
        Action<Project> action = new Action<Project>(){

            @Override
            public void execute(Project project) {
                foundTargets.put(project, new TreeSet<Task>(project.getTasks()));
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute(this);
        }
        return foundTargets;
    }

    @Override
    public Set<Task> getTasksByName(final String name, boolean recursive) {
        if (Strings.isNullOrEmpty((String)name)) {
            throw new InvalidUserDataException("Name is not specified!");
        }
        final HashSet<Task> foundTasks = new HashSet<Task>();
        Action<Project> action = new Action<Project>(){

            @Override
            public void execute(Project project) {
                ((ProjectInternal)project).evaluate();
                Task task = (Task)project.getTasks().findByName(name);
                if (task != null) {
                    foundTasks.add(task);
                }
            }
        };
        if (recursive) {
            this.allprojects((Action<? super Project>)action);
        } else {
            action.execute(this);
        }
        return foundTasks;
    }

    @Override
    @Inject
    public FileOperations getFileOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public ProviderFactory getProviders() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public ObjectFactory getObjects() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public DefaultProjectLayout getLayout() {
        throw new UnsupportedOperationException();
    }

    @Override
    public File file(Object path) {
        return this.getFileOperations().file(path);
    }

    @Override
    public File file(Object path, PathValidation validation) {
        return this.getFileOperations().file(path, validation);
    }

    @Override
    public URI uri(Object path) {
        return this.getFileOperations().uri(path);
    }

    @Override
    public ConfigurableFileCollection files(Object ... paths) {
        return this.getLayout().configurableFiles(paths);
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Closure closure) {
        return ConfigureUtil.configure(closure, this.files(paths));
    }

    @Override
    public ConfigurableFileCollection files(Object paths, Action<? super ConfigurableFileCollection> configureAction) {
        ConfigurableFileCollection files = this.files(paths);
        configureAction.execute(files);
        return files;
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir) {
        return this.getFileOperations().fileTree(baseDir);
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Closure closure) {
        return ConfigureUtil.configure(closure, this.fileTree(baseDir));
    }

    @Override
    public ConfigurableFileTree fileTree(Object baseDir, Action<? super ConfigurableFileTree> configureAction) {
        ConfigurableFileTree fileTree = this.fileTree(baseDir);
        configureAction.execute(fileTree);
        return fileTree;
    }

    @Override
    public ConfigurableFileTree fileTree(Map<String, ?> args) {
        return this.getFileOperations().fileTree(args);
    }

    @Override
    public FileTree zipTree(Object zipPath) {
        return this.getFileOperations().zipTree(zipPath);
    }

    @Override
    public FileTree tarTree(Object tarPath) {
        return this.getFileOperations().tarTree(tarPath);
    }

    @Override
    public <T> Provider<T> provider(Callable<T> value) {
        return this.getProviders().provider(value);
    }

    @Override
    public <T> PropertyState<T> property(Class<T> clazz) {
        return this.getProviders().property(clazz);
    }

    @Override
    public ResourceHandler getResources() {
        return this.getFileOperations().getResources();
    }

    @Override
    public String relativePath(Object path) {
        return this.getFileOperations().relativePath(path);
    }

    @Override
    public File mkdir(Object path) {
        return this.getFileOperations().mkdir(path);
    }

    @Override
    public boolean delete(Object ... paths) {
        return this.getFileOperations().delete(paths);
    }

    @Override
    public WorkResult delete(Action<? super DeleteSpec> action) {
        return this.getFileOperations().delete(action);
    }

    public Factory<AntBuilder> getAntBuilderFactory() {
        if (this.antBuilderFactory == null) {
            this.antBuilderFactory = this.services.getFactory(AntBuilder.class);
        }
        return this.antBuilderFactory;
    }

    @Override
    public DependencyHandler getDependencies() {
        if (this.dependencyHandler == null) {
            this.dependencyHandler = this.services.get(DependencyHandler.class);
        }
        return this.dependencyHandler;
    }

    public void setDependencyHandler(DependencyHandler dependencyHandler) {
        this.dependencyHandler = dependencyHandler;
    }

    @Override
    public ProjectEvaluationListener getProjectEvaluationBroadcaster() {
        return this.evaluationListener.getSource();
    }

    @Override
    public void beforeEvaluate(Action<? super Project> action) {
        this.assertMutatingMethodAllowed("Project#beforeEvaluate(Action)");
        this.evaluationListener.add("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.beforeEvaluate", action));
    }

    @Override
    public void afterEvaluate(Action<? super Project> action) {
        this.assertMutatingMethodAllowed("Project#afterEvaluate(Action)");
        this.evaluationListener.add("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.afterEvaluate", action));
    }

    @Override
    public void beforeEvaluate(Closure closure) {
        this.assertMutatingMethodAllowed("Project#beforeEvaluate(Closure)");
        this.evaluationListener.add(new ClosureBackedMethodInvocationDispatch("beforeEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.beforeEvaluate", closure)));
    }

    @Override
    public void afterEvaluate(Closure closure) {
        this.assertMutatingMethodAllowed("Project#afterEvaluate(Closure)");
        this.evaluationListener.add(new ClosureBackedMethodInvocationDispatch("afterEvaluate", this.getListenerBuildOperationDecorator().decorate("Project.afterEvaluate", closure)));
    }

    @Override
    public Logger getLogger() {
        return BUILD_LOGGER;
    }

    @Override
    public StandardOutputCapture getStandardOutputCapture() {
        return this.getLogging();
    }

    @Override
    @Inject
    public LoggingManagerInternal getLogging() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public SoftwareComponentContainer getComponents() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object property(String propertyName) throws MissingPropertyException {
        return this.extensibleDynamicObject.getProperty(propertyName);
    }

    @Override
    public Object findProperty(String propertyName) {
        return this.hasProperty(propertyName) ? this.property(propertyName) : null;
    }

    @Override
    public void setProperty(String name, Object value) {
        this.extensibleDynamicObject.setProperty(name, value);
    }

    @Override
    public boolean hasProperty(String propertyName) {
        return this.extensibleDynamicObject.hasProperty(propertyName);
    }

    @Override
    public Map<String, ?> getProperties() {
        return (Map)DeprecationLogger.whileDisabled(new Factory<Map<String, ?>>(){

            @Override
            public Map<String, ?> create() {
                return DefaultProject.this.extensibleDynamicObject.getProperties();
            }
        });
    }

    @Override
    public WorkResult copy(Closure closure) {
        return this.copy(ConfigureUtil.configureUsing(closure));
    }

    @Override
    public WorkResult copy(Action<? super CopySpec> action) {
        return this.getFileOperations().copy(action);
    }

    @Override
    public WorkResult sync(Action<? super CopySpec> action) {
        return this.getFileOperations().sync(action);
    }

    @Override
    public CopySpec copySpec(Closure closure) {
        return ConfigureUtil.configure(closure, this.copySpec());
    }

    @Override
    public CopySpec copySpec(Action<? super CopySpec> action) {
        return Actions.with(this.copySpec(), action);
    }

    @Override
    public CopySpec copySpec() {
        return this.getFileOperations().copySpec();
    }

    @Inject
    protected ProcessOperations getProcessOperations() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ExecResult javaexec(Closure closure) {
        return this.javaexec(ConfigureUtil.configureUsing(closure));
    }

    @Override
    public ExecResult javaexec(Action<? super JavaExecSpec> action) {
        return this.getProcessOperations().javaexec(action);
    }

    @Override
    public ExecResult exec(Closure closure) {
        return this.exec(ConfigureUtil.configureUsing(closure));
    }

    @Override
    public ExecResult exec(Action<? super ExecSpec> action) {
        return this.getProcessOperations().exec(action);
    }

    @Override
    public ServiceRegistry getServices() {
        return this.services;
    }

    @Override
    public ServiceRegistryFactory getServiceRegistryFactory() {
        return this.services.get(ServiceRegistryFactory.class);
    }

    @Override
    public Module getModule() {
        return this.services.get(DependencyMetaDataProvider.class).getModule();
    }

    @Override
    public AntBuilder ant(Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, this.getAnt());
    }

    @Override
    public AntBuilder ant(Action<? super AntBuilder> configureAction) {
        AntBuilder ant = this.getAnt();
        configureAction.execute(ant);
        return ant;
    }

    @Override
    public void subprojects(Closure configureClosure) {
        this.getProjectConfigurator().subprojects(this.getSubprojects(), ConfigureUtil.configureUsing(configureClosure));
    }

    @Override
    public void allprojects(Closure configureClosure) {
        this.getProjectConfigurator().allprojects(this.getAllprojects(), ConfigureUtil.configureUsing(configureClosure));
    }

    @Override
    public Project project(String path, Closure configureClosure) {
        return this.getProjectConfigurator().project(this.project(path), ConfigureUtil.configureUsing(configureClosure));
    }

    @Override
    public Project project(String path, Action<? super Project> configureAction) {
        return this.getProjectConfigurator().project(this.project(path), configureAction);
    }

    @Override
    public Object configure(Object object, Closure configureClosure) {
        return ConfigureUtil.configure(configureClosure, object);
    }

    @Override
    public Iterable<?> configure(Iterable<?> objects, Closure configureClosure) {
        for (Object object : objects) {
            this.configure(object, configureClosure);
        }
        return objects;
    }

    @Override
    public void configurations(Closure configureClosure) {
        this.getConfigurations().configure(configureClosure);
    }

    @Override
    public void repositories(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getRepositories());
    }

    @Override
    public void dependencies(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getDependencies());
    }

    @Override
    public void artifacts(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getArtifacts());
    }

    @Override
    public void artifacts(Action<? super ArtifactHandler> configureAction) {
        configureAction.execute(this.getArtifacts());
    }

    @Override
    public void buildscript(Closure configureClosure) {
        ConfigureUtil.configure(configureClosure, this.getBuildscript());
    }

    @Override
    public Task task(String task) {
        return this.taskContainer.create(task);
    }

    public Task task(Object task) {
        return this.taskContainer.create(task.toString());
    }

    @Override
    public Task task(String task, Action<? super Task> configureAction) {
        return this.taskContainer.create(task, configureAction);
    }

    @Override
    public Task task(String task, Closure configureClosure) {
        return this.taskContainer.create(task).configure(configureClosure);
    }

    public Task task(Object task, Closure configureClosure) {
        return this.task(task.toString(), configureClosure);
    }

    public Task task(Map options, String task) {
        return this.taskContainer.create(GUtil.addMaps(options, Collections.singletonMap("name", task)));
    }

    public Task task(Map options, Object task) {
        return this.task(options, task.toString());
    }

    public Task task(Map options, String task, Closure configureClosure) {
        return this.taskContainer.create(GUtil.addMaps(options, Collections.singletonMap("name", task))).configure(configureClosure);
    }

    public Task task(Map options, Object task, Closure configureClosure) {
        return this.task(options, task.toString(), configureClosure);
    }

    @Override
    @Inject
    public ProjectConfigurationActionContainer getConfigurationActions() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public ModelRegistry getModelRegistry() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ModelSchemaStore getModelSchemaStore() {
        throw new UnsupportedOperationException();
    }

    @Override
    protected DefaultObjectConfigurationAction createObjectConfigurationAction() {
        return new DefaultObjectConfigurationAction(this.getFileResolver(), this.getScriptPluginFactory(), this.getScriptHandlerFactory(), this.getBaseClassLoaderScope(), this.getResourceLoader(), this);
    }

    @Inject
    protected TextResourceLoader getResourceLoader() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Inject
    public PluginManagerInternal getPluginManager() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptPluginFactory getScriptPluginFactory() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ScriptHandlerFactory getScriptHandlerFactory() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassLoaderScope getClassLoaderScope() {
        return this.classLoaderScope;
    }

    @Override
    public ClassLoaderScope getBaseClassLoaderScope() {
        return this.baseClassLoaderScope;
    }

    public Object passThrough(Object object) {
        return object;
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type) {
        Instantiator instantiator = this.getServices().get(Instantiator.class);
        return instantiator.newInstance(FactoryNamedDomainObjectContainer.class, type, instantiator, new DynamicPropertyNamer());
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, NamedDomainObjectFactory<T> factory) {
        Instantiator instantiator = this.getServices().get(Instantiator.class);
        return instantiator.newInstance(FactoryNamedDomainObjectContainer.class, type, instantiator, new DynamicPropertyNamer(), factory);
    }

    @Override
    public <T> NamedDomainObjectContainer<T> container(Class<T> type, Closure factoryClosure) {
        Instantiator instantiator = this.getServices().get(Instantiator.class);
        return instantiator.newInstance(FactoryNamedDomainObjectContainer.class, type, instantiator, new DynamicPropertyNamer(), factoryClosure);
    }

    @Override
    public ExtensionContainerInternal getExtensions() {
        return (ExtensionContainerInternal)((Object)this.getConvention());
    }

    public void model(Closure<?> modelRules) {
        this.prepareForRuleBasedPlugins();
        ModelRegistry modelRegistry = this.getModelRegistry();
        if (TransformedModelDslBacking.isTransformedBlock(modelRules)) {
            ClosureBackedAction.execute(new TransformedModelDslBacking(modelRegistry, this.getRootProject().getFileResolver()), modelRules);
        } else {
            new NonTransformedModelDslBacking(modelRegistry).configure(modelRules);
        }
    }

    @Inject
    protected DeferredProjectConfiguration getDeferredProjectConfiguration() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected CrossProjectConfigurator getProjectConfigurator() {
        throw new UnsupportedOperationException();
    }

    @Inject
    protected ListenerBuildOperationDecorator getListenerBuildOperationDecorator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addDeferredConfiguration(Runnable configuration) {
        this.getDeferredProjectConfiguration().add(configuration);
    }

    @Override
    public void fireDeferredConfiguration() {
        this.getDeferredProjectConfiguration().fire();
    }

    @Override
    public void addRuleBasedPluginListener(RuleBasedPluginListener listener) {
        if (this.preparedForRuleBasedPlugins) {
            listener.prepareForRuleBasedPlugins(this);
        } else {
            this.ruleBasedPluginListenerBroadcast.add(listener);
        }
    }

    @Override
    public void prepareForRuleBasedPlugins() {
        if (!this.preparedForRuleBasedPlugins) {
            this.preparedForRuleBasedPlugins = true;
            this.ruleBasedPluginListenerBroadcast.getSource().prepareForRuleBasedPlugins(this);
        }
    }

    @Override
    @Inject
    public InputNormalizationHandler getNormalization() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void normalization(Action<? super InputNormalizationHandler> configuration) {
        configuration.execute(this.getNormalization());
    }

    @Override
    @Inject
    public DependencyLockingHandler getDependencyLocking() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void dependencyLocking(Action<? super DependencyLockingHandler> configuration) {
        configuration.execute(this.getDependencyLocking());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ProjectEvaluationListener stepEvaluationListener(ProjectEvaluationListener listener, Action<ProjectEvaluationListener> step) {
        ListenerBroadcast<ProjectEvaluationListener> original = this.evaluationListener;
        ListenerBroadcast<ProjectEvaluationListener> nextBatch = this.newProjectEvaluationListenerBroadcast();
        this.evaluationListener = nextBatch;
        try {
            step.execute(listener);
        }
        finally {
            this.evaluationListener = original;
        }
        return nextBatch.isEmpty() ? null : nextBatch.getSource();
    }

    private void assertMutatingMethodAllowed(String methodName) {
        this.getProjectConfigurator().assertCrossProjectConfigurationAllowed(methodName, this);
    }

    @Override
    @Deprecated
    public ConfigurableFileCollection configurableFiles() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ConfigurableFileCollection configurableFiles(Object ... paths) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public FileCollection immutableFiles(Object ... paths) {
        throw new UnsupportedOperationException();
    }

    static class BasicServicesRules
    extends RuleSource {
        BasicServicesRules() {
        }

        @Hidden
        @Model
        SourceDirectorySetFactory sourceDirectorySetFactory(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(SourceDirectorySetFactory.class);
        }

        @Hidden
        @Model
        ITaskFactory taskFactory(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(ITaskFactory.class);
        }

        @Hidden
        @Model
        Instantiator instantiator(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(Instantiator.class);
        }

        @Hidden
        @Model
        ModelSchemaStore schemaStore(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(ModelSchemaStore.class);
        }

        @Hidden
        @Model
        ManagedProxyFactory proxyFactory(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(ManagedProxyFactory.class);
        }

        @Hidden
        @Model
        StructBindingsStore structBindingsStore(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(StructBindingsStore.class);
        }

        @Hidden
        @Model
        NodeInitializerRegistry nodeInitializerRegistry(ModelSchemaStore schemaStore, StructBindingsStore structBindingsStore) {
            return new DefaultNodeInitializerRegistry(schemaStore, structBindingsStore);
        }

        @Hidden
        @Model
        TypeConverter typeConverter(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(TypeConverter.class);
        }

        @Hidden
        @Model
        FileOperations fileOperations(ServiceRegistry serviceRegistry) {
            return serviceRegistry.get(FileOperations.class);
        }
    }
}

