/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.scala;

import groovy.lang.Closure;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.project.antbuilder.AntBuilderDelegate;
import org.gradle.api.tasks.scala.ScalaDocOptions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;

public class AntScalaDoc {
    private final IsolatedAntBuilder antBuilder;
    private final List<File> bootclasspathFiles;
    private final List<File> extensionDirs;

    public AntScalaDoc(IsolatedAntBuilder antBuilder) {
        this(antBuilder, (Iterable<File>)ImmutableList.of(), (Iterable<File>)ImmutableList.of());
    }

    public AntScalaDoc(IsolatedAntBuilder antBuilder, Iterable<File> bootclasspathFiles, Iterable<File> extensionDirs) {
        this.antBuilder = antBuilder;
        this.bootclasspathFiles = ImmutableList.copyOf(bootclasspathFiles);
        this.extensionDirs = ImmutableList.copyOf(extensionDirs);
    }

    public void execute(final FileCollection source, final File targetDir, final Iterable<File> classpathFiles, Iterable<File> scalaClasspath, final ScalaDocOptions docOptions) {
        this.antBuilder.withClasspath(scalaClasspath).execute((Closure)new Closure<Object>((Object)this){

            public Object doCall(final AntBuilderDelegate ant) {
                ant.invokeMethod("taskdef", Collections.singletonMap("resource", "scala/tools/ant/antlib.xml"));
                ImmutableMap.Builder optionsBuilder = ImmutableMap.builder();
                optionsBuilder.put((Object)"destDir", (Object)targetDir);
                optionsBuilder.putAll(docOptions.optionMap());
                ImmutableMap options = optionsBuilder.build();
                return ant.invokeMethod("scaladoc", new Object[]{options, new Closure<Void>((Object)this){

                    public void doCall() {
                        source.addToAntBuilder((Object)ant, "src", FileCollection.AntType.MatchingTask);
                        for (File file : AntScalaDoc.this.bootclasspathFiles) {
                            ant.invokeMethod("bootclasspath", Collections.singletonMap("location", file));
                        }
                        for (File dir : AntScalaDoc.this.extensionDirs) {
                            ant.invokeMethod("extdirs", Collections.singletonMap("location", dir));
                        }
                        for (File file : classpathFiles) {
                            ant.invokeMethod("classpath", Collections.singletonMap("location", file));
                        }
                    }
                }});
            }
        });
    }
}

