/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.tasks.testing.report;

import java.io.IOException;
import org.gradle.api.Action;
import org.gradle.api.internal.tasks.testing.report.AllTestResults;
import org.gradle.api.internal.tasks.testing.report.ClassTestResults;
import org.gradle.api.internal.tasks.testing.report.PackageTestResults;
import org.gradle.api.internal.tasks.testing.report.PageRenderer;
import org.gradle.internal.ErroringAction;
import org.gradle.internal.html.SimpleHtmlWriter;

class OverviewPageRenderer
extends PageRenderer<AllTestResults> {
    OverviewPageRenderer() {
    }

    @Override
    protected void registerTabs() {
        this.addFailuresTab();
        this.addIgnoredTab();
        if (!((AllTestResults)this.getResults()).getPackages().isEmpty()) {
            this.addTab("Packages", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

                @Override
                protected void doExecute(SimpleHtmlWriter writer) throws IOException {
                    OverviewPageRenderer.this.renderPackages(writer);
                }
            });
        }
        this.addTab("Classes", (Action<SimpleHtmlWriter>)new ErroringAction<SimpleHtmlWriter>(){

            @Override
            public void doExecute(SimpleHtmlWriter htmlWriter) throws IOException {
                OverviewPageRenderer.this.renderClasses(htmlWriter);
            }
        });
    }

    @Override
    protected void renderBreadcrumbs(SimpleHtmlWriter htmlWriter) {
    }

    private void renderPackages(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thead");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters("Package").endElement();
        htmlWriter.startElement("th").characters("Tests").endElement();
        htmlWriter.startElement("th").characters("Failures").endElement();
        htmlWriter.startElement("th").characters("Ignored").endElement();
        htmlWriter.startElement("th").characters("Duration").endElement();
        htmlWriter.startElement("th").characters("Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        htmlWriter.startElement("tbody");
        for (PackageTestResults testPackage : ((AllTestResults)this.getResults()).getPackages()) {
            htmlWriter.startElement("tr");
            htmlWriter.startElement("td").attribute("class", testPackage.getStatusClass());
            htmlWriter.startElement("a").attribute("href", testPackage.getBaseUrl()).characters(testPackage.getName()).endElement();
            htmlWriter.endElement();
            htmlWriter.startElement("td").characters(Integer.toString(testPackage.getTestCount())).endElement();
            htmlWriter.startElement("td").characters(Integer.toString(testPackage.getFailureCount())).endElement();
            htmlWriter.startElement("td").characters(Integer.toString(testPackage.getIgnoredCount())).endElement();
            htmlWriter.startElement("td").characters(testPackage.getFormattedDuration()).endElement();
            htmlWriter.startElement("td").attribute("class", testPackage.getStatusClass()).characters(testPackage.getFormattedSuccessRate()).endElement();
            htmlWriter.endElement();
        }
        htmlWriter.endElement();
        htmlWriter.endElement();
    }

    private void renderClasses(SimpleHtmlWriter htmlWriter) throws IOException {
        htmlWriter.startElement("table");
        htmlWriter.startElement("thead");
        htmlWriter.startElement("tr");
        htmlWriter.startElement("th").characters("Class").endElement();
        htmlWriter.startElement("th").characters("Tests").endElement();
        htmlWriter.startElement("th").characters("Failures").endElement();
        htmlWriter.startElement("th").characters("Ignored").endElement();
        htmlWriter.startElement("th").characters("Duration").endElement();
        htmlWriter.startElement("th").characters("Success rate").endElement();
        htmlWriter.endElement();
        htmlWriter.endElement();
        htmlWriter.startElement("tbody");
        for (PackageTestResults testPackage : ((AllTestResults)this.getResults()).getPackages()) {
            for (ClassTestResults testClass : testPackage.getClasses()) {
                htmlWriter.startElement("tr");
                htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).endElement();
                htmlWriter.startElement("a").attribute("href", this.asHtmlLinkEncoded(testClass.getBaseUrl())).characters(testClass.getName()).endElement();
                htmlWriter.startElement("td").characters(Integer.toString(testClass.getTestCount())).endElement();
                htmlWriter.startElement("td").characters(Integer.toString(testClass.getFailureCount())).endElement();
                htmlWriter.startElement("td").characters(Integer.toString(testClass.getIgnoredCount())).endElement();
                htmlWriter.startElement("td").characters(testClass.getFormattedDuration()).endElement();
                htmlWriter.startElement("td").attribute("class", testClass.getStatusClass()).characters(testClass.getFormattedSuccessRate()).endElement();
                htmlWriter.endElement();
            }
        }
        htmlWriter.endElement();
        htmlWriter.endElement();
    }
}

