/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.osgi;

import groovy.lang.Closure;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.internal.ConventionMapping;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.internal.plugins.osgi.DefaultOsgiManifest;
import org.gradle.api.internal.plugins.osgi.OsgiHelper;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.plugins.BasePluginConvention;
import org.gradle.api.plugins.osgi.OsgiManifest;
import org.gradle.internal.Actions;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.util.ConfigureUtil;
import org.gradle.util.DeprecationLogger;

public class OsgiPluginConvention {
    private final ProjectInternal project;

    @Deprecated
    public OsgiPluginConvention(ProjectInternal project) {
        DeprecationLogger.nagUserOfDeprecated("Creating instances of OsgiPluginConvention");
        this.project = project;
    }

    public OsgiManifest osgiManifest() {
        return this.osgiManifest(Actions.doNothing());
    }

    public OsgiManifest osgiManifest(Closure closure) {
        return ConfigureUtil.configure(closure, this.createDefaultOsgiManifest());
    }

    public OsgiManifest osgiManifest(Action<? super OsgiManifest> action) {
        OsgiManifest manifest = this.createDefaultOsgiManifest();
        action.execute(manifest);
        return manifest;
    }

    private OsgiManifest createDefaultOsgiManifest() {
        OsgiManifest osgiManifest = this.project.getServices().get(Instantiator.class).newInstance(DefaultOsgiManifest.class, this.project.getFileResolver());
        ConventionMapping mapping = ((IConventionAware)((Object)osgiManifest)).getConventionMapping();
        final OsgiHelper osgiHelper = new OsgiHelper();
        mapping.map("version", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return osgiHelper.getVersion(OsgiPluginConvention.this.project.getVersion().toString());
            }
        });
        mapping.map("name", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return OsgiPluginConvention.this.project.getConvention().getPlugin(BasePluginConvention.class).getArchivesBaseName();
            }
        });
        mapping.map("symbolicName", new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return osgiHelper.getBundleSymbolicName(OsgiPluginConvention.this.project);
            }
        });
        return osgiManifest;
    }
}

