/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins.quality;

import java.io.File;
import java.util.Collection;
import javax.annotation.Nullable;
import org.gradle.api.Incubating;
import org.gradle.api.Project;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.resources.TextResource;

public class FindBugsExtension
extends CodeQualityExtension {
    private final Project project;
    private String effort;
    private String reportLevel;
    private Collection<String> visitors;
    private Collection<String> omitVisitors;
    private TextResource includeFilterConfig;
    private TextResource excludeFilterConfig;
    private TextResource excludeBugsFilterConfig;
    private Collection<String> extraArgs;
    private Collection<String> jvmArgs;
    private boolean showProgress;

    public FindBugsExtension(Project project) {
        this.project = project;
    }

    public String getEffort() {
        return this.effort;
    }

    public void setEffort(String effort) {
        this.effort = effort;
    }

    public String getReportLevel() {
        return this.reportLevel;
    }

    public void setReportLevel(String reportLevel) {
        this.reportLevel = reportLevel;
    }

    public Collection<String> getVisitors() {
        return this.visitors;
    }

    public void setVisitors(Collection<String> visitors) {
        this.visitors = visitors;
    }

    public Collection<String> getOmitVisitors() {
        return this.omitVisitors;
    }

    public void setOmitVisitors(Collection<String> omitVisitors) {
        this.omitVisitors = omitVisitors;
    }

    @Nullable
    @Incubating
    public TextResource getIncludeFilterConfig() {
        return this.includeFilterConfig;
    }

    @Incubating
    public void setIncludeFilterConfig(@Nullable TextResource includeFilterConfig) {
        this.includeFilterConfig = includeFilterConfig;
    }

    @Nullable
    public File getIncludeFilter() {
        TextResource includeFilterConfig = this.getIncludeFilterConfig();
        if (includeFilterConfig == null) {
            return null;
        }
        return includeFilterConfig.asFile();
    }

    public void setIncludeFilter(File filter) {
        this.setIncludeFilterConfig(this.project.getResources().getText().fromFile(filter));
    }

    @Incubating
    @Nullable
    public TextResource getExcludeFilterConfig() {
        return this.excludeFilterConfig;
    }

    @Incubating
    public void setExcludeFilterConfig(@Nullable TextResource excludeFilterConfig) {
        this.excludeFilterConfig = excludeFilterConfig;
    }

    @Nullable
    public File getExcludeFilter() {
        TextResource excludeFilterConfig = this.getExcludeFilterConfig();
        if (excludeFilterConfig == null) {
            return null;
        }
        return excludeFilterConfig.asFile();
    }

    public void setExcludeFilter(File filter) {
        this.setExcludeFilterConfig(this.project.getResources().getText().fromFile(filter));
    }

    @Incubating
    @Nullable
    public TextResource getExcludeBugsFilterConfig() {
        return this.excludeBugsFilterConfig;
    }

    @Incubating
    public void setExcludeBugsFilterConfig(@Nullable TextResource excludeBugsFilterConfig) {
        this.excludeBugsFilterConfig = excludeBugsFilterConfig;
    }

    @Nullable
    public File getExcludeBugsFilter() {
        TextResource excludeBugsFilterConfig = this.getExcludeBugsFilterConfig();
        if (excludeBugsFilterConfig == null) {
            return null;
        }
        return excludeBugsFilterConfig.asFile();
    }

    public void setExcludeBugsFilter(File filter) {
        this.setExcludeBugsFilterConfig(this.project.getResources().getText().fromFile(filter));
    }

    public Collection<String> getExtraArgs() {
        return this.extraArgs;
    }

    public void setExtraArgs(Collection<String> extraArgs) {
        this.extraArgs = extraArgs;
    }

    @Incubating
    public Collection<String> getJvmArgs() {
        return this.jvmArgs;
    }

    @Incubating
    public void setJvmArgs(Collection<String> jvmArgs) {
        this.jvmArgs = jvmArgs;
    }

    @Incubating
    public boolean isShowProgress() {
        return this.showProgress;
    }

    @Incubating
    public void setShowProgress(boolean showProgress) {
        this.showProgress = showProgress;
    }
}

