/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.apache.tools.ant.types.Commandline;
import org.gradle.api.Incubating;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.ConventionTask;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.options.Option;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.ExecActionFactory;
import org.gradle.process.internal.JavaExecAction;

public class JavaExec
extends ConventionTask
implements JavaExecSpec {
    private final JavaExecAction javaExecHandleBuilder = this.getExecActionFactory().newJavaExecAction();

    @Inject
    protected ExecActionFactory getExecActionFactory() {
        throw new UnsupportedOperationException();
    }

    @TaskAction
    public void exec() {
        this.setMain(this.getMain());
        this.setJvmArgs(this.getJvmArgs());
        this.javaExecHandleBuilder.execute();
    }

    @Override
    public List<String> getAllJvmArgs() {
        return this.javaExecHandleBuilder.getAllJvmArgs();
    }

    @Override
    public void setAllJvmArgs(List<String> arguments) {
        this.javaExecHandleBuilder.setAllJvmArgs(arguments);
    }

    @Override
    public void setAllJvmArgs(Iterable<?> arguments) {
        this.javaExecHandleBuilder.setAllJvmArgs(arguments);
    }

    @Override
    public List<String> getJvmArgs() {
        return this.javaExecHandleBuilder.getJvmArgs();
    }

    @Override
    public void setJvmArgs(List<String> arguments) {
        this.javaExecHandleBuilder.setJvmArgs(arguments);
    }

    @Override
    public void setJvmArgs(Iterable<?> arguments) {
        this.javaExecHandleBuilder.setJvmArgs(arguments);
    }

    @Override
    public JavaExec jvmArgs(Iterable<?> arguments) {
        this.javaExecHandleBuilder.jvmArgs(arguments);
        return this;
    }

    @Override
    public JavaExec jvmArgs(Object ... arguments) {
        this.javaExecHandleBuilder.jvmArgs(arguments);
        return this;
    }

    @Override
    public Map<String, Object> getSystemProperties() {
        return this.javaExecHandleBuilder.getSystemProperties();
    }

    @Override
    public void setSystemProperties(Map<String, ?> properties) {
        this.javaExecHandleBuilder.setSystemProperties(properties);
    }

    @Override
    public JavaExec systemProperties(Map<String, ?> properties) {
        this.javaExecHandleBuilder.systemProperties(properties);
        return this;
    }

    @Override
    public JavaExec systemProperty(String name, Object value) {
        this.javaExecHandleBuilder.systemProperty(name, value);
        return this;
    }

    @Override
    public FileCollection getBootstrapClasspath() {
        return this.javaExecHandleBuilder.getBootstrapClasspath();
    }

    @Override
    public void setBootstrapClasspath(FileCollection classpath) {
        this.javaExecHandleBuilder.setBootstrapClasspath(classpath);
    }

    @Override
    public JavaExec bootstrapClasspath(Object ... classpath) {
        this.javaExecHandleBuilder.bootstrapClasspath(classpath);
        return this;
    }

    @Override
    public String getMinHeapSize() {
        return this.javaExecHandleBuilder.getMinHeapSize();
    }

    @Override
    public void setMinHeapSize(String heapSize) {
        this.javaExecHandleBuilder.setMinHeapSize(heapSize);
    }

    @Override
    public String getDefaultCharacterEncoding() {
        return this.javaExecHandleBuilder.getDefaultCharacterEncoding();
    }

    @Override
    public void setDefaultCharacterEncoding(String defaultCharacterEncoding) {
        this.javaExecHandleBuilder.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    @Override
    public String getMaxHeapSize() {
        return this.javaExecHandleBuilder.getMaxHeapSize();
    }

    @Override
    public void setMaxHeapSize(String heapSize) {
        this.javaExecHandleBuilder.setMaxHeapSize(heapSize);
    }

    @Override
    public boolean getEnableAssertions() {
        return this.javaExecHandleBuilder.getEnableAssertions();
    }

    @Override
    public void setEnableAssertions(boolean enabled) {
        this.javaExecHandleBuilder.setEnableAssertions(enabled);
    }

    @Override
    public boolean getDebug() {
        return this.javaExecHandleBuilder.getDebug();
    }

    @Override
    @Option(option="debug-jvm", description="Enable debugging for the process. The process is started suspended and listening on port 5005. [INCUBATING]")
    public void setDebug(boolean enabled) {
        this.javaExecHandleBuilder.setDebug(enabled);
    }

    @Override
    public String getMain() {
        return this.javaExecHandleBuilder.getMain();
    }

    @Override
    public JavaExec setMain(String mainClassName) {
        this.javaExecHandleBuilder.setMain(mainClassName);
        return this;
    }

    @Override
    public List<String> getArgs() {
        return this.javaExecHandleBuilder.getArgs();
    }

    @Incubating
    @Option(option="args", description="Command line arguments passed to the main class. [INCUBATING]")
    public JavaExec setArgsString(String args) {
        return this.setArgs((List)Arrays.asList(Commandline.translateCommandline((String)args)));
    }

    @Override
    public JavaExec setArgs(List<String> applicationArgs) {
        this.javaExecHandleBuilder.setArgs(applicationArgs);
        return this;
    }

    @Override
    public JavaExec setArgs(Iterable<?> applicationArgs) {
        this.javaExecHandleBuilder.setArgs(applicationArgs);
        return this;
    }

    @Override
    public JavaExec args(Object ... args) {
        this.javaExecHandleBuilder.args(args);
        return this;
    }

    @Override
    public JavaExecSpec args(Iterable<?> args) {
        this.javaExecHandleBuilder.args(args);
        return this;
    }

    @Override
    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.javaExecHandleBuilder.getArgumentProviders();
    }

    @Override
    public JavaExec setClasspath(FileCollection classpath) {
        this.javaExecHandleBuilder.setClasspath(classpath);
        return this;
    }

    @Override
    public JavaExec classpath(Object ... paths) {
        this.javaExecHandleBuilder.classpath(paths);
        return this;
    }

    @Override
    public FileCollection getClasspath() {
        return this.javaExecHandleBuilder.getClasspath();
    }

    @Override
    public JavaExec copyTo(JavaForkOptions options) {
        this.javaExecHandleBuilder.copyTo(options);
        return this;
    }

    @Override
    @Nullable
    @Optional
    @Input
    public String getExecutable() {
        return this.javaExecHandleBuilder.getExecutable();
    }

    @Override
    public void setExecutable(String executable) {
        this.javaExecHandleBuilder.setExecutable(executable);
    }

    @Override
    public void setExecutable(Object executable) {
        this.javaExecHandleBuilder.setExecutable(executable);
    }

    @Override
    public JavaExec executable(Object executable) {
        this.javaExecHandleBuilder.executable(executable);
        return this;
    }

    @Override
    @Internal
    public File getWorkingDir() {
        return this.javaExecHandleBuilder.getWorkingDir();
    }

    @Override
    public void setWorkingDir(File dir) {
        this.javaExecHandleBuilder.setWorkingDir(dir);
    }

    @Override
    public void setWorkingDir(Object dir) {
        this.javaExecHandleBuilder.setWorkingDir(dir);
    }

    @Override
    public JavaExec workingDir(Object dir) {
        this.javaExecHandleBuilder.workingDir(dir);
        return this;
    }

    @Override
    @Internal
    public Map<String, Object> getEnvironment() {
        return this.javaExecHandleBuilder.getEnvironment();
    }

    @Override
    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.javaExecHandleBuilder.setEnvironment(environmentVariables);
    }

    @Override
    public JavaExec environment(String name, Object value) {
        this.javaExecHandleBuilder.environment(name, value);
        return this;
    }

    @Override
    public JavaExec environment(Map<String, ?> environmentVariables) {
        this.javaExecHandleBuilder.environment(environmentVariables);
        return this;
    }

    @Override
    public JavaExec copyTo(ProcessForkOptions target) {
        this.javaExecHandleBuilder.copyTo(target);
        return this;
    }

    @Override
    public JavaExec setStandardInput(InputStream inputStream) {
        this.javaExecHandleBuilder.setStandardInput(inputStream);
        return this;
    }

    @Override
    @Internal
    public InputStream getStandardInput() {
        return this.javaExecHandleBuilder.getStandardInput();
    }

    @Override
    public JavaExec setStandardOutput(OutputStream outputStream) {
        this.javaExecHandleBuilder.setStandardOutput(outputStream);
        return this;
    }

    @Override
    @Internal
    public OutputStream getStandardOutput() {
        return this.javaExecHandleBuilder.getStandardOutput();
    }

    @Override
    public JavaExec setErrorOutput(OutputStream outputStream) {
        this.javaExecHandleBuilder.setErrorOutput(outputStream);
        return this;
    }

    @Override
    @Internal
    public OutputStream getErrorOutput() {
        return this.javaExecHandleBuilder.getErrorOutput();
    }

    @Override
    public JavaExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.javaExecHandleBuilder.setIgnoreExitValue(ignoreExitValue);
        return this;
    }

    @Override
    @Input
    public boolean isIgnoreExitValue() {
        return this.javaExecHandleBuilder.isIgnoreExitValue();
    }

    @Override
    @Internal
    public List<String> getCommandLine() {
        return this.javaExecHandleBuilder.getCommandLine();
    }

    @Override
    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.javaExecHandleBuilder.getJvmArgumentProviders();
    }
}

