/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.util.concurrent.locks.Lock;
import org.gradle.api.Action;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.FileLockReleasedSignal;
import org.gradle.cache.LockOptions;
import org.gradle.cache.internal.AbstractCrossProcessCacheAccess;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.internal.Factory;
import org.gradle.internal.UncheckedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LockOnDemandCrossProcessCacheAccess
extends AbstractCrossProcessCacheAccess {
    private static final Logger LOGGER = LoggerFactory.getLogger(LockOnDemandCrossProcessCacheAccess.class);
    private final String cacheDisplayName;
    private final File lockTarget;
    private final LockOptions lockOptions;
    private final FileLockManager lockManager;
    private final Lock stateLock;
    private final Action<FileLock> onOpen;
    private final Action<FileLock> onClose;
    private final Runnable unlocker;
    private final Action<FileLockReleasedSignal> whenContended;
    private int lockCount;
    private FileLock fileLock;
    private CacheInitializationAction initAction;
    private FileLockReleasedSignal lockReleaseSignal;

    public LockOnDemandCrossProcessCacheAccess(String cacheDisplayName, File lockTarget, LockOptions lockOptions, FileLockManager lockManager, Lock stateLock, CacheInitializationAction initAction, Action<FileLock> onOpen, Action<FileLock> onClose) {
        this.cacheDisplayName = cacheDisplayName;
        this.lockTarget = lockTarget;
        this.lockOptions = lockOptions;
        this.lockManager = lockManager;
        this.stateLock = stateLock;
        this.initAction = initAction;
        this.onOpen = onOpen;
        this.onClose = onClose;
        this.unlocker = new UnlockAction();
        this.whenContended = new ContendedAction();
    }

    @Override
    public void open() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.stateLock.lock();
        try {
            if (this.lockCount != 0) {
                throw new IllegalStateException(String.format("Cannot close cache access for %s as it is currently in use for %s operations.", this.cacheDisplayName, this.lockCount));
            }
            this.releaseLockIfHeld();
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T withFileLock(Factory<T> factory) {
        this.incrementLockCount();
        try {
            T t = factory.create();
            return t;
        }
        finally {
            this.decrementLockCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementLockCount() {
        this.stateLock.lock();
        try {
            if (this.fileLock == null) {
                if (this.lockCount != 0) {
                    throw new IllegalStateException("Mismatched lock count.");
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Acquiring file lock for {}", (Object)this.cacheDisplayName);
                }
                this.fileLock = this.lockManager.lock(this.lockTarget, this.lockOptions, this.cacheDisplayName, "", this.whenContended);
                try {
                    if (this.initAction.requiresInitialization(this.fileLock)) {
                        this.fileLock.writeFile(new Runnable(){

                            @Override
                            public void run() {
                                LockOnDemandCrossProcessCacheAccess.this.initAction.initialize(LockOnDemandCrossProcessCacheAccess.this.fileLock);
                            }
                        });
                    }
                    this.onOpen.execute(this.fileLock);
                }
                catch (Exception e) {
                    this.fileLock.close();
                    this.fileLock = null;
                    throw UncheckedException.throwAsUncheckedException(e);
                }
            }
            ++this.lockCount;
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementLockCount() {
        this.stateLock.lock();
        try {
            if (this.lockCount <= 0 || this.fileLock == null) {
                throw new IllegalStateException("Mismatched lock count.");
            }
            --this.lockCount;
            if (this.lockCount == 0 && this.lockReleaseSignal != null) {
                this.releaseLockIfHeld();
            }
        }
        finally {
            this.stateLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLockIfHeld() {
        if (this.fileLock == null) {
            return;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Releasing file lock for {}", (Object)this.cacheDisplayName);
        }
        try {
            this.onClose.execute(this.fileLock);
        }
        finally {
            this.fileLock.close();
            this.fileLock = null;
            if (this.lockReleaseSignal != null) {
                this.lockReleaseSignal.trigger();
                this.lockReleaseSignal = null;
            }
        }
    }

    @Override
    public Runnable acquireFileLock() {
        this.incrementLockCount();
        return this.unlocker;
    }

    private class UnlockAction
    implements Runnable {
        private UnlockAction() {
        }

        @Override
        public void run() {
            LockOnDemandCrossProcessCacheAccess.this.decrementLockCount();
        }
    }

    private class ContendedAction
    implements Action<FileLockReleasedSignal> {
        private ContendedAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void execute(FileLockReleasedSignal signal) {
            LockOnDemandCrossProcessCacheAccess.this.stateLock.lock();
            try {
                if (LockOnDemandCrossProcessCacheAccess.this.lockCount == 0) {
                    LOGGER.debug("Lock on {} requested by another process - releasing lock.", (Object)LockOnDemandCrossProcessCacheAccess.this.cacheDisplayName);
                    LockOnDemandCrossProcessCacheAccess.this.releaseLockIfHeld();
                    signal.trigger();
                } else {
                    LOGGER.debug("Lock on {} requested by another process - lock is in use and will be released when operation completed.", (Object)LockOnDemandCrossProcessCacheAccess.this.cacheDisplayName);
                    LockOnDemandCrossProcessCacheAccess.this.lockReleaseSignal = signal;
                }
            }
            finally {
                LockOnDemandCrossProcessCacheAccess.this.stateLock.unlock();
            }
        }
    }
}

