/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.configuration;

import org.gradle.api.initialization.dsl.ScriptHandler;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.SettingsInternal;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.file.FileLookup;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.initialization.ClassLoaderScope;
import org.gradle.api.internal.initialization.ScriptHandlerFactory;
import org.gradle.api.internal.initialization.ScriptHandlerInternal;
import org.gradle.api.internal.plugins.PluginManagerInternal;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.configuration.DefaultScriptTarget;
import org.gradle.configuration.InitScriptTarget;
import org.gradle.configuration.InitialPassSettingScriptTarget;
import org.gradle.configuration.ProjectScriptTarget;
import org.gradle.configuration.ScriptPlugin;
import org.gradle.configuration.ScriptPluginFactory;
import org.gradle.configuration.ScriptTarget;
import org.gradle.configuration.SettingScriptTarget;
import org.gradle.groovy.scripts.BasicScript;
import org.gradle.groovy.scripts.ScriptCompiler;
import org.gradle.groovy.scripts.ScriptCompilerFactory;
import org.gradle.groovy.scripts.ScriptRunner;
import org.gradle.groovy.scripts.ScriptSource;
import org.gradle.groovy.scripts.internal.BuildScriptData;
import org.gradle.groovy.scripts.internal.BuildScriptDataSerializer;
import org.gradle.groovy.scripts.internal.BuildScriptTransformer;
import org.gradle.groovy.scripts.internal.FactoryBackedCompileOperation;
import org.gradle.groovy.scripts.internal.InitialPassStatementTransformer;
import org.gradle.groovy.scripts.internal.SubsetScriptTransformer;
import org.gradle.internal.Actions;
import org.gradle.internal.Factory;
import org.gradle.internal.hash.FileHasher;
import org.gradle.internal.hash.StreamHasher;
import org.gradle.internal.logging.LoggingManagerInternal;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.resource.TextResourceLoader;
import org.gradle.internal.service.DefaultServiceRegistry;
import org.gradle.model.dsl.internal.transform.ClosureCreationInterceptingVerifier;
import org.gradle.model.internal.inspect.ModelRuleSourceDetector;
import org.gradle.plugin.management.internal.PluginRequests;
import org.gradle.plugin.management.internal.PluginRequestsSerializer;
import org.gradle.plugin.management.internal.autoapply.AutoAppliedPluginHandler;
import org.gradle.plugin.use.internal.PluginRequestApplicator;
import org.gradle.process.internal.ExecFactory;

public class DefaultScriptPluginFactory
implements ScriptPluginFactory {
    private static final StringInterner INTERNER = new StringInterner();
    private static final String CLASSPATH_COMPILE_STAGE = "CLASSPATH";
    private static final String BODY_COMPILE_STAGE = "BODY";
    private final ScriptCompilerFactory scriptCompilerFactory;
    private final Factory<LoggingManagerInternal> loggingManagerFactory;
    private final Instantiator instantiator;
    private final ScriptHandlerFactory scriptHandlerFactory;
    private final PluginRequestApplicator pluginRequestApplicator;
    private final FileLookup fileLookup;
    private final DirectoryFileTreeFactory directoryFileTreeFactory;
    private final DocumentationRegistry documentationRegistry;
    private final ModelRuleSourceDetector modelRuleSourceDetector;
    private final BuildScriptDataSerializer buildScriptDataSerializer = new BuildScriptDataSerializer();
    private final PluginRequestsSerializer pluginRequestsSerializer = new PluginRequestsSerializer();
    private final ProviderFactory providerFactory;
    private final TextResourceLoader textResourceLoader;
    private final ExecFactory execFactory;
    private final StreamHasher streamHasher;
    private final FileHasher fileHasher;
    private final AutoAppliedPluginHandler autoAppliedPluginHandler;
    private ScriptPluginFactory scriptPluginFactory;

    public DefaultScriptPluginFactory(ScriptCompilerFactory scriptCompilerFactory, Factory<LoggingManagerInternal> loggingManagerFactory, Instantiator instantiator, ScriptHandlerFactory scriptHandlerFactory, PluginRequestApplicator pluginRequestApplicator, FileLookup fileLookup, DirectoryFileTreeFactory directoryFileTreeFactory, DocumentationRegistry documentationRegistry, ModelRuleSourceDetector modelRuleSourceDetector, ProviderFactory providerFactory, TextResourceLoader textResourceLoader, StreamHasher streamHasher, FileHasher fileHasher, ExecFactory execFactory, AutoAppliedPluginHandler autoAppliedPluginHandler) {
        this.scriptCompilerFactory = scriptCompilerFactory;
        this.loggingManagerFactory = loggingManagerFactory;
        this.instantiator = instantiator;
        this.scriptHandlerFactory = scriptHandlerFactory;
        this.pluginRequestApplicator = pluginRequestApplicator;
        this.fileLookup = fileLookup;
        this.directoryFileTreeFactory = directoryFileTreeFactory;
        this.documentationRegistry = documentationRegistry;
        this.modelRuleSourceDetector = modelRuleSourceDetector;
        this.providerFactory = providerFactory;
        this.textResourceLoader = textResourceLoader;
        this.execFactory = execFactory;
        this.scriptPluginFactory = this;
        this.streamHasher = streamHasher;
        this.fileHasher = fileHasher;
        this.autoAppliedPluginHandler = autoAppliedPluginHandler;
    }

    public void setScriptPluginFactory(ScriptPluginFactory scriptPluginFactory) {
        this.scriptPluginFactory = scriptPluginFactory;
    }

    @Override
    public ScriptPlugin create(ScriptSource scriptSource, ScriptHandler scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
        return new ScriptPluginImpl(scriptSource, (ScriptHandlerInternal)scriptHandler, targetScope, baseScope, topLevelScript);
    }

    private class ScriptPluginImpl
    implements ScriptPlugin {
        private final ScriptSource scriptSource;
        private final ClassLoaderScope targetScope;
        private final ClassLoaderScope baseScope;
        private final ScriptHandlerInternal scriptHandler;
        private final boolean topLevelScript;

        public ScriptPluginImpl(ScriptSource scriptSource, ScriptHandlerInternal scriptHandler, ClassLoaderScope targetScope, ClassLoaderScope baseScope, boolean topLevelScript) {
            this.scriptSource = scriptSource;
            this.targetScope = targetScope;
            this.baseScope = baseScope;
            this.scriptHandler = scriptHandler;
            this.topLevelScript = topLevelScript;
        }

        @Override
        public ScriptSource getSource() {
            return this.scriptSource;
        }

        @Override
        public void apply(final Object target) {
            final DefaultServiceRegistry services = new DefaultServiceRegistry(){

                Factory<PatternSet> createPatternSetFactory() {
                    return DefaultScriptPluginFactory.this.fileLookup.getFileResolver().getPatternSetFactory();
                }
            };
            services.add(ScriptPluginFactory.class, DefaultScriptPluginFactory.this.scriptPluginFactory);
            services.add(ScriptHandlerFactory.class, DefaultScriptPluginFactory.this.scriptHandlerFactory);
            services.add(ClassLoaderScope.class, this.baseScope);
            services.add(LoggingManagerInternal.class, DefaultScriptPluginFactory.this.loggingManagerFactory.create());
            services.add(Instantiator.class, DefaultScriptPluginFactory.this.instantiator);
            services.add(ScriptHandler.class, this.scriptHandler);
            services.add(FileLookup.class, DefaultScriptPluginFactory.this.fileLookup);
            services.add(DirectoryFileTreeFactory.class, DefaultScriptPluginFactory.this.directoryFileTreeFactory);
            services.add(ModelRuleSourceDetector.class, DefaultScriptPluginFactory.this.modelRuleSourceDetector);
            services.add(ProviderFactory.class, DefaultScriptPluginFactory.this.providerFactory);
            services.add(TextResourceLoader.class, DefaultScriptPluginFactory.this.textResourceLoader);
            services.add(StreamHasher.class, DefaultScriptPluginFactory.this.streamHasher);
            services.add(FileHasher.class, DefaultScriptPluginFactory.this.fileHasher);
            services.add(ExecFactory.class, DefaultScriptPluginFactory.this.execFactory);
            ScriptTarget initialPassScriptTarget = this.initialPassTarget(target);
            ScriptCompiler compiler = DefaultScriptPluginFactory.this.scriptCompilerFactory.createCompiler(this.scriptSource);
            Class<? extends BasicScript> scriptType = initialPassScriptTarget.getScriptClass();
            InitialPassStatementTransformer initialPassStatementTransformer = new InitialPassStatementTransformer(this.scriptSource, initialPassScriptTarget, DefaultScriptPluginFactory.this.documentationRegistry);
            SubsetScriptTransformer initialTransformer = new SubsetScriptTransformer(initialPassStatementTransformer);
            String id = INTERNER.intern("cp_" + initialPassScriptTarget.getId());
            FactoryBackedCompileOperation<PluginRequests> initialOperation = new FactoryBackedCompileOperation<PluginRequests>(id, DefaultScriptPluginFactory.CLASSPATH_COMPILE_STAGE, initialTransformer, initialPassStatementTransformer, DefaultScriptPluginFactory.this.pluginRequestsSerializer);
            ScriptRunner<? extends BasicScript, PluginRequests> initialRunner = compiler.compile(scriptType, initialOperation, this.baseScope.getExportClassLoader(), Actions.doNothing());
            initialRunner.run(target, services);
            PluginRequests initialPluginRequests = initialRunner.getData();
            PluginRequests mergedPluginRequests = DefaultScriptPluginFactory.this.autoAppliedPluginHandler.mergeWithAutoAppliedPlugins(initialPluginRequests, target);
            PluginManagerInternal pluginManager = this.topLevelScript ? initialPassScriptTarget.getPluginManager() : null;
            DefaultScriptPluginFactory.this.pluginRequestApplicator.applyPlugins(mergedPluginRequests, this.scriptHandler, pluginManager, this.targetScope);
            ScriptTarget scriptTarget = this.secondPassTarget(target);
            scriptType = scriptTarget.getScriptClass();
            BuildScriptTransformer buildScriptTransformer = new BuildScriptTransformer(this.scriptSource, scriptTarget);
            String operationId = scriptTarget.getId();
            FactoryBackedCompileOperation<BuildScriptData> operation = new FactoryBackedCompileOperation<BuildScriptData>(operationId, DefaultScriptPluginFactory.BODY_COMPILE_STAGE, buildScriptTransformer, buildScriptTransformer, DefaultScriptPluginFactory.this.buildScriptDataSerializer);
            final ScriptRunner<? extends BasicScript, BuildScriptData> runner = compiler.compile(scriptType, operation, this.targetScope.getLocalClassLoader(), ClosureCreationInterceptingVerifier.INSTANCE);
            if (scriptTarget.getSupportsMethodInheritance() && runner.getHasMethods()) {
                scriptTarget.attachScript(runner.getScript());
            }
            if (!runner.getRunDoesSomething()) {
                return;
            }
            Runnable buildScriptRunner = new Runnable(){

                @Override
                public void run() {
                    runner.run(target, services);
                }
            };
            boolean hasImperativeStatements = runner.getData().getHasImperativeStatements();
            scriptTarget.addConfiguration(buildScriptRunner, !hasImperativeStatements);
        }

        private ScriptTarget initialPassTarget(Object target) {
            return this.wrap(target, true);
        }

        private ScriptTarget secondPassTarget(Object target) {
            return this.wrap(target, false);
        }

        private ScriptTarget wrap(Object target, boolean isInitialPass) {
            if (target instanceof ProjectInternal && this.topLevelScript) {
                return new ProjectScriptTarget((ProjectInternal)target);
            }
            if (target instanceof GradleInternal && this.topLevelScript) {
                return new InitScriptTarget((GradleInternal)target);
            }
            if (target instanceof SettingsInternal && this.topLevelScript) {
                if (isInitialPass) {
                    return new InitialPassSettingScriptTarget((SettingsInternal)target);
                }
                return new SettingScriptTarget((SettingsInternal)target);
            }
            return new DefaultScriptTarget(target);
        }
    }
}

