/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.initialization;

import java.util.List;
import javax.annotation.Nullable;
import org.gradle.BuildResult;
import org.gradle.StartParameter;
import org.gradle.api.internal.BuildDefinition;
import org.gradle.api.internal.ExceptionAnalyser;
import org.gradle.api.internal.GradleInternal;
import org.gradle.api.internal.tasks.execution.statistics.TaskExecutionStatisticsEventAdapter;
import org.gradle.api.logging.Logging;
import org.gradle.api.logging.configuration.ShowStacktrace;
import org.gradle.composite.internal.IncludedBuildControllers;
import org.gradle.configuration.BuildConfigurer;
import org.gradle.deployment.internal.DefaultDeploymentRegistry;
import org.gradle.execution.BuildConfigurationActionExecuter;
import org.gradle.execution.BuildExecuter;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildClientMetaData;
import org.gradle.initialization.BuildCompletionListener;
import org.gradle.initialization.BuildEventConsumer;
import org.gradle.initialization.BuildLoader;
import org.gradle.initialization.BuildRequestContext;
import org.gradle.initialization.BuildRequestMetaData;
import org.gradle.initialization.DefaultBuildRequestMetaData;
import org.gradle.initialization.DefaultGradleLauncher;
import org.gradle.initialization.GradleLauncher;
import org.gradle.initialization.GradleLauncherFactory;
import org.gradle.initialization.InitScriptHandler;
import org.gradle.initialization.ModelConfigurationListener;
import org.gradle.initialization.NestedBuildFactory;
import org.gradle.initialization.SettingsLoader;
import org.gradle.initialization.SettingsLoaderFactory;
import org.gradle.internal.InternalBuildAdapter;
import org.gradle.internal.build.BuildState;
import org.gradle.internal.build.NestedBuildState;
import org.gradle.internal.build.RootBuildState;
import org.gradle.internal.buildevents.BuildLogger;
import org.gradle.internal.buildevents.BuildStartedTime;
import org.gradle.internal.buildevents.TaskExecutionStatisticsReporter;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.Stoppable;
import org.gradle.internal.event.ListenerManager;
import org.gradle.internal.featurelifecycle.DeprecatedUsageBuildOperationProgressBroadaster;
import org.gradle.internal.featurelifecycle.LoggingDeprecatedFeatureHandler;
import org.gradle.internal.featurelifecycle.ScriptUsageLocationReporter;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableList;
import org.gradle.internal.logging.text.StyledTextOutputFactory;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.scopes.BuildScopeServices;
import org.gradle.internal.service.scopes.BuildSessionScopeServices;
import org.gradle.internal.service.scopes.BuildTreeScopeServices;
import org.gradle.internal.service.scopes.CrossBuildSessionScopeServices;
import org.gradle.internal.service.scopes.GradleUserHomeScopeServiceRegistry;
import org.gradle.internal.service.scopes.ServiceRegistryFactory;
import org.gradle.internal.time.Clock;
import org.gradle.internal.time.Time;
import org.gradle.invocation.DefaultGradle;
import org.gradle.profile.ProfileEventAdapter;
import org.gradle.profile.ReportGeneratingProfileListener;
import org.gradle.util.DeprecationLogger;

public class DefaultGradleLauncherFactory
implements GradleLauncherFactory {
    private final GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry;
    private final CrossBuildSessionScopeServices crossBuildSessionScopeServices;
    private DefaultGradleLauncher rootBuild;

    public DefaultGradleLauncherFactory(GradleUserHomeScopeServiceRegistry userHomeDirServiceRegistry, CrossBuildSessionScopeServices crossBuildSessionScopeServices) {
        this.userHomeDirServiceRegistry = userHomeDirServiceRegistry;
        this.crossBuildSessionScopeServices = crossBuildSessionScopeServices;
    }

    private GradleLauncher createChildInstance(BuildDefinition buildDefinition, BuildState build, GradleLauncher parent, BuildTreeScopeServices buildTreeScopeServices, List<?> servicesToStop) {
        ServiceRegistry services = parent.getGradle().getServices();
        DefaultBuildRequestMetaData requestMetaData = new DefaultBuildRequestMetaData(services.get(BuildClientMetaData.class));
        BuildCancellationToken cancellationToken = services.get(BuildCancellationToken.class);
        BuildEventConsumer buildEventConsumer = services.get(BuildEventConsumer.class);
        return this.doNewInstance(buildDefinition, build, parent, cancellationToken, requestMetaData, buildEventConsumer, buildTreeScopeServices, servicesToStop);
    }

    @Override
    public GradleLauncher newInstance(BuildDefinition buildDefinition, RootBuildState build, BuildRequestContext requestContext, ServiceRegistry parentRegistry) {
        DefaultGradleLauncher launcher;
        if (this.rootBuild != null) {
            throw new IllegalStateException("Cannot have a current root build");
        }
        if (!(parentRegistry instanceof BuildTreeScopeServices)) {
            throw new IllegalArgumentException("Service registry must be of build-tree scope");
        }
        BuildTreeScopeServices buildTreeScopeServices = (BuildTreeScopeServices)parentRegistry;
        this.rootBuild = launcher = this.doNewInstance(buildDefinition, build, null, requestContext.getCancellationToken(), requestContext, requestContext.getEventConsumer(), buildTreeScopeServices, (List<?>)ImmutableList.of((Object)new Stoppable(){

            @Override
            public void stop() {
                DefaultGradleLauncherFactory.this.rootBuild = null;
            }
        }));
        final DefaultDeploymentRegistry deploymentRegistry = parentRegistry.get(DefaultDeploymentRegistry.class);
        launcher.getGradle().addBuildListener(new InternalBuildAdapter(){

            @Override
            public void buildFinished(BuildResult result) {
                deploymentRegistry.buildFinished(result);
            }
        });
        return launcher;
    }

    private DefaultGradleLauncher doNewInstance(BuildDefinition buildDefinition, BuildState build, @Nullable GradleLauncher parent, BuildCancellationToken cancellationToken, BuildRequestMetaData requestMetaData, BuildEventConsumer buildEventConsumer, BuildTreeScopeServices buildTreeScopeServices, List<?> servicesToStop) {
        BuildScopeServices serviceRegistry = new BuildScopeServices((ServiceRegistry)buildTreeScopeServices);
        serviceRegistry.add(BuildDefinition.class, buildDefinition);
        serviceRegistry.add(BuildRequestMetaData.class, requestMetaData);
        serviceRegistry.add(BuildClientMetaData.class, requestMetaData.getClient());
        serviceRegistry.add(BuildEventConsumer.class, buildEventConsumer);
        serviceRegistry.add(BuildCancellationToken.class, cancellationToken);
        serviceRegistry.add(BuildState.class, build);
        NestedBuildFactoryImpl nestedBuildFactory = new NestedBuildFactoryImpl(buildTreeScopeServices);
        serviceRegistry.add(NestedBuildFactory.class, nestedBuildFactory);
        StartParameter startParameter = buildDefinition.getStartParameter();
        ListenerManager listenerManager = serviceRegistry.get(ListenerManager.class);
        Clock clock = serviceRegistry.get(Clock.class);
        if (parent == null) {
            BuildStartedTime buildStartedTime = serviceRegistry.get(BuildStartedTime.class);
            listenerManager.useLogger(new BuildLogger(Logging.getLogger(BuildLogger.class), serviceRegistry.get(StyledTextOutputFactory.class), startParameter, requestMetaData, buildStartedTime, clock));
        }
        listenerManager.addListener(serviceRegistry.get(TaskExecutionStatisticsEventAdapter.class));
        listenerManager.addListener(new TaskExecutionStatisticsReporter(serviceRegistry.get(StyledTextOutputFactory.class)));
        listenerManager.addListener(serviceRegistry.get(ProfileEventAdapter.class));
        if (startParameter.isProfile()) {
            listenerManager.addListener(new ReportGeneratingProfileListener(serviceRegistry.get(StyledTextOutputFactory.class)));
        }
        ScriptUsageLocationReporter usageLocationReporter = new ScriptUsageLocationReporter();
        listenerManager.addListener(usageLocationReporter);
        ShowStacktrace showStacktrace = startParameter.getShowStacktrace();
        switch (showStacktrace) {
            case ALWAYS: 
            case ALWAYS_FULL: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(true);
                break;
            }
            default: {
                LoggingDeprecatedFeatureHandler.setTraceLoggingEnabled(false);
            }
        }
        BuildOperationExecutor buildOperationExecutor = serviceRegistry.get(BuildOperationExecutor.class);
        DeprecatedUsageBuildOperationProgressBroadaster deprecationWarningBuildOperationProgressBroadaster = serviceRegistry.get(DeprecatedUsageBuildOperationProgressBroadaster.class);
        DeprecationLogger.init(usageLocationReporter, startParameter.getWarningMode(), deprecationWarningBuildOperationProgressBroadaster);
        SettingsLoaderFactory settingsLoaderFactory = serviceRegistry.get(SettingsLoaderFactory.class);
        SettingsLoader settingsLoader = parent != null ? settingsLoaderFactory.forNestedBuild() : settingsLoaderFactory.forTopLevelBuild();
        GradleInternal parentBuild = parent == null ? null : parent.getGradle();
        GradleInternal gradle = serviceRegistry.get(Instantiator.class).newInstance(DefaultGradle.class, parentBuild, startParameter, serviceRegistry.get(ServiceRegistryFactory.class));
        IncludedBuildControllers includedBuildControllers = parent == null ? buildTreeScopeServices.get(IncludedBuildControllers.class) : IncludedBuildControllers.EMPTY;
        DefaultGradleLauncher gradleLauncher = new DefaultGradleLauncher(gradle, serviceRegistry.get(InitScriptHandler.class), settingsLoader, serviceRegistry.get(BuildLoader.class), serviceRegistry.get(BuildConfigurer.class), serviceRegistry.get(ExceptionAnalyser.class), gradle.getBuildListenerBroadcaster(), listenerManager.getBroadcaster(ModelConfigurationListener.class), listenerManager.getBroadcaster(BuildCompletionListener.class), buildOperationExecutor, gradle.getServices().get(BuildConfigurationActionExecuter.class), gradle.getServices().get(BuildExecuter.class), serviceRegistry, servicesToStop, includedBuildControllers, buildDefinition.getFromBuild());
        nestedBuildFactory.setParent(gradleLauncher);
        nestedBuildFactory.setBuildCancellationToken(cancellationToken);
        return gradleLauncher;
    }

    private class NestedBuildFactoryImpl
    implements NestedBuildFactory {
        private final BuildTreeScopeServices buildTreeScopeServices;
        private DefaultGradleLauncher parent;
        private BuildCancellationToken buildCancellationToken;

        public NestedBuildFactoryImpl(BuildTreeScopeServices buildTreeScopeServices) {
            this.buildTreeScopeServices = buildTreeScopeServices;
        }

        @Override
        public GradleLauncher nestedInstance(BuildDefinition buildDefinition, NestedBuildState build) {
            return DefaultGradleLauncherFactory.this.createChildInstance(buildDefinition, build, this.parent, this.buildTreeScopeServices, (List)ImmutableList.of());
        }

        @Override
        public GradleLauncher nestedBuildTree(BuildDefinition buildDefinition, NestedBuildState build) {
            StartParameter startParameter = buildDefinition.getStartParameter();
            final ServiceRegistry userHomeServices = DefaultGradleLauncherFactory.this.userHomeDirServiceRegistry.getServicesFor(startParameter.getGradleUserHomeDir());
            DefaultBuildRequestMetaData buildRequestMetaData = new DefaultBuildRequestMetaData(Time.currentTimeMillis());
            BuildSessionScopeServices sessionScopeServices = new BuildSessionScopeServices(userHomeServices, DefaultGradleLauncherFactory.this.crossBuildSessionScopeServices, startParameter, buildRequestMetaData, ClassPath.EMPTY, this.buildCancellationToken);
            BuildTreeScopeServices buildTreeScopeServices = new BuildTreeScopeServices((ServiceRegistry)sessionScopeServices);
            return DefaultGradleLauncherFactory.this.createChildInstance(buildDefinition, build, this.parent, buildTreeScopeServices, (List)ImmutableList.of((Object)buildTreeScopeServices, (Object)sessionScopeServices, (Object)new Stoppable(){

                @Override
                public void stop() {
                    DefaultGradleLauncherFactory.this.userHomeDirServiceRegistry.release(userHomeServices);
                }
            }));
        }

        private void setParent(DefaultGradleLauncher parent) {
            this.parent = parent;
        }

        private void setBuildCancellationToken(BuildCancellationToken buildCancellationToken) {
            this.buildCancellationToken = buildCancellationToken;
        }
    }
}

